/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavadocContentAccess;

public class JavadocContentAccess2 {
    private final IMember fMember;
    private String fSource;
    private StringBuffer fBuf;
    private int fLiteralContent;

    private JavadocContentAccess2(IMember member) {
        this.fMember = member;
    }

    public static String getHTMLContent(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaModelException {
        String sourceJavadoc = JavadocContentAccess2.getHTMLContentFromSource(member, allowInherited);
        if (sourceJavadoc != null) {
            return sourceJavadoc;
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null) {
            return member.getAttachedJavadoc(null);
        }
        if (allowInherited && member.getElementType() == 9) {
            return JavadocContentAccess2.findDocInHierarchy((IMethod)member, useAttachedJavadoc);
        }
        return null;
    }

    private static String getHTMLContentFromSource(IMember member, boolean allowInherited) throws JavaModelException {
        String rawJavadoc;
        String javadoc;
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange != null && !JavadocContentAccess2.containsOnlyInheritDoc(javadoc = JavadocContentAccess2.javadoc2HTML(member, rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength())))) {
            return javadoc;
        }
        if (allowInherited && member.getElementType() == 9) {
            return JavadocContentAccess2.findDocInHierarchy((IMethod)member, false);
        }
        return null;
    }

    private static String javadoc2HTML(IMember member, String rawJavadoc) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(member.getJavaProject());
        String source = String.valueOf(rawJavadoc) + "class C{}";
        parser.setSource(source.toCharArray());
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root == null) {
            return null;
        }
        List types = root.types();
        if (types.size() != 1) {
            return null;
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
        Javadoc javadoc = type.getJavadoc();
        if (javadoc == null) {
            try {
                Reader contentReader = JavadocContentAccess.getHTMLContentReader(member, false, false);
                if (contentReader != null) {
                    return JavadocContentAccess2.getString(contentReader);
                }
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return new JavadocContentAccess2(member).toHTML(javadoc, source);
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    private static boolean containsOnlyInheritDoc(String javadoc) {
        return javadoc != null && javadoc.trim().equals("{@inheritDoc}");
    }

    private static String findDocInHierarchy(IMethod method, boolean useAttachedJavadoc) throws JavaModelException {
        if (!method.getJavaProject().exists()) {
            return null;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            IType curr = superTypes[i];
            IMethod overridden = tester.findOverriddenMethodInType(curr, method);
            if (overridden != null) {
                String javadoc = JavadocContentAccess2.getHTMLContentFromSource((IMember)overridden, false);
                if (javadoc != null) {
                    return javadoc;
                }
                if (useAttachedJavadoc) {
                    if (overridden.getOpenable().getBuffer() == null) {
                        return overridden.getAttachedJavadoc(null);
                    }
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    private String toHTML(Javadoc javadoc, String source) {
        this.fSource = source;
        this.fBuf = new StringBuffer();
        this.fLiteralContent = 0;
        TagElement start = null;
        ArrayList<TagElement> parameters = new ArrayList<TagElement>();
        TagElement returnTag = null;
        ArrayList<TagElement> exceptions = new ArrayList<TagElement>();
        ArrayList<TagElement> authors = new ArrayList<TagElement>();
        ArrayList<TagElement> sees = new ArrayList<TagElement>();
        ArrayList<TagElement> since = new ArrayList<TagElement>();
        ArrayList<TagElement> rest = new ArrayList<TagElement>();
        List tags = javadoc.tags();
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            String tagName = tag.getTagName();
            if (tagName == null) {
                start = tag;
                continue;
            }
            if ("@param".equals(tagName)) {
                parameters.add(tag);
                continue;
            }
            if ("@return".equals(tagName)) {
                if (returnTag != null) continue;
                returnTag = tag;
                continue;
            }
            if ("@exception".equals(tagName) || "@throws".equals(tagName)) {
                exceptions.add(tag);
                continue;
            }
            if ("@author".equals(tagName)) {
                authors.add(tag);
                continue;
            }
            if ("@see".equals(tagName)) {
                sees.add(tag);
                continue;
            }
            if ("@since".equals(tagName)) {
                since.add(tag);
                continue;
            }
            rest.add(tag);
        }
        if (start != null) {
            this.handleContentElements(start.fragments());
        }
        if (sees.size() > 0 || parameters.size() > 0 || returnTag != null || exceptions.size() > 0 || authors.size() > 0 || since.size() > 0 || rest.size() > 0) {
            this.fBuf.append("<dl>");
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_see_section, sees);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section, parameters);
            this.handleBlockTag(JavaDocMessages.JavaDoc2HTMLTextReader_returns_section, returnTag);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_throws_section, exceptions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_author_section, authors);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_since_section, since);
            this.handleBlockTags(rest);
            this.fBuf.append("</dl>");
        }
        String result = this.fBuf.toString();
        this.fBuf = null;
        return result;
    }

    private void handleContentElements(List nodes) {
        ASTNode lastNode = null;
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            int childStart;
            int lastEnd;
            ASTNode child = (ASTNode)iter.next();
            if (lastNode != null && (lastEnd = lastNode.getStartPosition() + lastNode.getLength()) != (childStart = child.getStartPosition())) {
                String textWithStars = this.fSource.substring(lastEnd, childStart);
                String text = this.removeDocLineIntros(textWithStars);
                this.fBuf.append(text);
            }
            lastNode = child;
            if (child instanceof TextElement) {
                this.handleText(((TextElement)child).getText());
                continue;
            }
            if (child instanceof TagElement) {
                this.handleInlineTagElement((TagElement)child);
                continue;
            }
            int start = child.getStartPosition();
            String text = this.fSource.substring(start, start + child.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
    }

    private String removeDocLineIntros(String textWithStars) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithStars.replaceAll(String.valueOf(lineBreakGroup) + noBreakSpace + "+\\*", "$1");
    }

    private void handleText(String text) {
        if (this.fLiteralContent == 0) {
            this.fBuf.append(text);
        } else {
            JavadocContentAccess2.appendEscaped(this.fBuf, text);
        }
    }

    private static void appendEscaped(StringBuffer buf, String text) {
        int nextToCopy = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i));
                }
                buf.append(rep);
                nextToCopy = i + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
    }

    private void handleInlineTagElement(TagElement node) {
        String name = node.getTagName();
        boolean isLink = "@link".equals(name);
        boolean isLinkplain = "@linkplain".equals(name);
        boolean isCode = "@code".equals(name);
        boolean isLiteral = "@literal".equals(name);
        if (isLiteral || isCode) {
            ++this.fLiteralContent;
        }
        if (isLink || isCode) {
            this.fBuf.append("<code>");
        }
        if (isLink || isLinkplain) {
            this.handleLink(node.fragments());
        } else if (isCode || isLiteral) {
            this.handleContentElements(node.fragments());
        } else {
            int start = node.getStartPosition();
            String text = this.fSource.substring(start, start + node.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
        if (isLink || isCode) {
            this.fBuf.append("</code>");
        }
        if (isLiteral || isCode) {
            --this.fLiteralContent;
        }
    }

    private void handleBlockTags(String title, List tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.fBuf.append("<dt>");
        this.fBuf.append(title);
        this.fBuf.append("</dt>");
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            this.fBuf.append("<dd>");
            if ("@param".equals(tag.getTagName())) {
                this.handleParamTag(tag);
            } else if ("@see".equals(tag.getTagName())) {
                this.handleSeeTag(tag);
            } else if ("@throws".equals(tag.getTagName()) || "@exception".equals(tag.getTagName())) {
                this.handleThrowsTag(tag);
            } else {
                this.handleContentElements(tag.fragments());
            }
            this.fBuf.append("</dd>");
        }
    }

    private void handleBlockTag(String title, TagElement tag) {
        if (tag == null) {
            return;
        }
        this.fBuf.append("<dt>");
        this.fBuf.append(title);
        this.fBuf.append("</dt>");
        this.fBuf.append("<dd>");
        this.handleContentElements(tag.fragments());
        this.fBuf.append("</dd>");
    }

    private void handleBlockTags(List tags) {
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            this.fBuf.append("<dt>");
            this.fBuf.append(tag.getTagName());
            this.fBuf.append("</dt>");
            this.fBuf.append("<dd>");
            this.handleContentElements(tag.fragments());
            this.fBuf.append("</dd>");
        }
    }

    private void handleSeeTag(TagElement tag) {
        this.handleLink(tag.fragments());
    }

    private void handleThrowsTag(TagElement tag) {
        List fragments = tag.fragments();
        int size = fragments.size();
        if (size > 0) {
            this.handleLink(fragments.subList(0, 1));
            this.fBuf.append(JavaElementLabels.CONCAT_STRING);
            this.handleContentElements(fragments.subList(1, size));
        }
    }

    private void handleParamTag(TagElement tag) {
        List fragments = tag.fragments();
        int i = 0;
        int size = fragments.size();
        if (size > 0) {
            String firstText;
            Object first = fragments.get(0);
            this.fBuf.append("<b>");
            if (first instanceof Name) {
                String name = ((Name)first).getFullyQualifiedName();
                this.fBuf.append(name);
                ++i;
            } else if (first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                Object second;
                this.fBuf.append("&lt;");
                ++i;
                if (size > 1 && (second = fragments.get(1)) instanceof Name) {
                    Object third;
                    String thirdText;
                    String name = ((Name)second).getFullyQualifiedName();
                    this.fBuf.append(name);
                    ++i;
                    if (size > 2 && ">".equals(thirdText = ((TextElement)(third = fragments.get(2))).getText())) {
                        this.fBuf.append("&gt;");
                        ++i;
                    }
                }
            }
            this.fBuf.append("</b> ");
            this.handleContentElements(fragments.subList(i, fragments.size()));
        }
    }

    private void handleLink(List fragments) {
        int fs = fragments.size();
        if (fs > 0) {
            Name qualifier;
            Object first = fragments.get(0);
            String refTypeName = null;
            String refMemberName = null;
            String[] refMethodParamTypes = null;
            String[] refMethodParamNames = null;
            if (first instanceof Name) {
                Name name = (Name)first;
                refTypeName = name.getFullyQualifiedName();
            } else if (first instanceof MemberRef) {
                MemberRef memberRef = (MemberRef)first;
                qualifier = memberRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = memberRef.getName().getIdentifier();
            } else if (first instanceof MethodRef) {
                MethodRef methodRef = (MethodRef)first;
                qualifier = methodRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = methodRef.getName().getIdentifier();
                List params = methodRef.parameters();
                int ps = params.size();
                refMethodParamTypes = new String[ps];
                refMethodParamNames = new String[ps];
                int i = 0;
                while (i < ps) {
                    MethodRefParameter param = (MethodRefParameter)params.get(i);
                    refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                    SimpleName paramName = param.getName();
                    if (paramName != null) {
                        refMethodParamNames[i] = paramName.getIdentifier();
                    }
                    ++i;
                }
            }
            if (refTypeName != null) {
                this.fBuf.append("<a href='");
                try {
                    String scheme = "eclipse-javadoc";
                    String uri = JavaElementLinks.createURI(scheme, (IJavaElement)this.fMember, refTypeName, refMemberName, refMethodParamTypes);
                    this.fBuf.append(uri);
                }
                catch (URISyntaxException e) {
                    JavaPlugin.log(e);
                }
                this.fBuf.append("'>");
                if (fs > 1) {
                    this.handleContentElements(fragments.subList(1, fs));
                } else {
                    this.fBuf.append(refTypeName);
                    if (refMemberName != null) {
                        if (refTypeName.length() > 0) {
                            this.fBuf.append('.');
                        }
                        this.fBuf.append(refMemberName);
                        if (refMethodParamTypes != null) {
                            this.fBuf.append('(');
                            int i = 0;
                            while (i < refMethodParamTypes.length) {
                                String pType = refMethodParamTypes[i];
                                this.fBuf.append(pType);
                                String pName = refMethodParamNames[i];
                                if (pName != null) {
                                    this.fBuf.append(' ').append(pName);
                                }
                                if (i < refMethodParamTypes.length - 1) {
                                    this.fBuf.append(", ");
                                }
                                ++i;
                            }
                            this.fBuf.append(')');
                        }
                    }
                }
                this.fBuf.append("</a>");
            } else {
                this.handleContentElements(fragments);
            }
        }
    }
}

