/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.breadcrumb;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PatternFilter
extends ViewerFilter {
    private StringMatcher fMatcher;

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    public void setPattern(String patternString) {
        if (patternString == null || patternString.equals("")) {
            this.fMatcher = null;
        } else {
            String pattern = String.valueOf(patternString) + "*";
            this.fMatcher = new StringMatcher(pattern, true, false);
        }
    }

    private boolean match(String string) {
        if (this.fMatcher == null) {
            return true;
        }
        return this.fMatcher.match(string);
    }

    private String[] getWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i))) {
                String word = text.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    private boolean wordMatches(String text) {
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] words = this.getWords(text);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (this.match(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

