/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.jarpackager.AbstractJarDestinationWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.jdt.internal.ui.jarpackager.ContainerFilter;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarRefactoringDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

class JarPackageWizardPage
extends AbstractJarDestinationWizardPage {
    private JarPackageData fJarPackage;
    private IStructuredSelection fInitialSelection;
    private CheckboxTreeAndListGroup fInputGroup;
    private Button fExportClassFilesCheckbox;
    private Button fExportOutputFoldersCheckbox;
    private Button fExportJavaFilesCheckbox;
    private Button fExportRefactoringsCheckbox;
    private Link fRefactoringLink;
    private Button fCompressCheckbox;
    private Button fOverwriteCheckbox;
    private Button fIncludeDirectoryEntriesCheckbox;
    private boolean fInitiallySelecting = true;
    private static final String PAGE_NAME = "JarPackageWizardPage";
    private static final String STORE_EXPORT_CLASS_FILES = "JarPackageWizardPage.EXPORT_CLASS_FILES";
    private static final String STORE_EXPORT_OUTPUT_FOLDERS = "JarPackageWizardPage.EXPORT_OUTPUT_FOLDER";
    private static final String STORE_EXPORT_JAVA_FILES = "JarPackageWizardPage.EXPORT_JAVA_FILES";
    private static final String STORE_REFACTORINGS = "JarPackageWizardPage.REFACTORINGS";
    private static final String STORE_COMPRESS = "JarPackageWizardPage.COMPRESS";
    private static final String STORE_OVERWRITE = "JarPackageWizardPage.OVERWRITE";
    private static final String STORE_INCLUDE_DIRECTORY_ENTRIES = "JarPackageWizardPage.INCLUDE_DIRECTORY_ENTRIES";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    static /* synthetic */ Class class$0;

    public JarPackageWizardPage(JarPackageData jarPackage, IStructuredSelection selection) {
        super(PAGE_NAME, selection, jarPackage);
        this.setTitle(JarPackagerMessages.JarPackageWizardPage_title);
        this.setDescription(JarPackagerMessages.JarPackageWizardPage_description);
        this.fJarPackage = jarPackage;
        this.fInitialSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_whatToExport_label);
        this.createInputGroup(composite);
        this.createExportTypeGroup(composite);
        new Label(composite, 0);
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_whereToExport_label);
        this.createDestinationGroup(composite);
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_options_label);
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    JarPackageWizardPage.this.setupBasedOnInitialSelections();
                }
            });
        }
        this.setControl((Control)composite);
        this.update();
        this.fRefactoringLink.setEnabled(this.fExportRefactoringsCheckbox.getSelection());
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_packager_wizard_page_context");
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.fCompressCheckbox = new Button(optionsGroup, 16416);
        this.fCompressCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_compress_text);
        this.fCompressCheckbox.addListener(13, (Listener)this);
        this.fIncludeDirectoryEntriesCheckbox = new Button(optionsGroup, 16416);
        this.fIncludeDirectoryEntriesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_includeDirectoryEntries_text);
        this.fIncludeDirectoryEntriesCheckbox.addListener(13, (Listener)this);
        this.fOverwriteCheckbox = new Button(optionsGroup, 16416);
        this.fOverwriteCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_overwrite_text);
        this.fOverwriteCheckbox.addListener(13, (Listener)this);
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.fInputGroup.getAllCheckedListItems();
    }

    public final void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_EXPORT_CLASS_FILES, this.fJarPackage.areClassFilesExported());
            settings.put(STORE_EXPORT_OUTPUT_FOLDERS, this.fJarPackage.areOutputFoldersExported());
            settings.put(STORE_EXPORT_JAVA_FILES, this.fJarPackage.areJavaFilesExported());
            settings.put(STORE_REFACTORINGS, this.fJarPackage.isRefactoringAware());
            settings.put(STORE_COMPRESS, this.fJarPackage.isCompressed());
            settings.put(STORE_INCLUDE_DIRECTORY_ENTRIES, this.fJarPackage.areDirectoryEntriesIncluded());
            settings.put(STORE_OVERWRITE, this.fJarPackage.allowOverwrite());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((JarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        this.fExportClassFilesCheckbox.setSelection(this.fJarPackage.areClassFilesExported());
        this.fExportOutputFoldersCheckbox.setSelection(this.fJarPackage.areOutputFoldersExported());
        this.fExportJavaFilesCheckbox.setSelection(this.fJarPackage.areJavaFilesExported());
        super.restoreWidgetValues();
        if (this.fExportRefactoringsCheckbox != null) {
            this.fExportRefactoringsCheckbox.setSelection(this.fJarPackage.isRefactoringAware());
        }
        this.fCompressCheckbox.setSelection(this.fJarPackage.isCompressed());
        this.fIncludeDirectoryEntriesCheckbox.setSelection(this.fJarPackage.areDirectoryEntriesIncluded());
        this.fOverwriteCheckbox.setSelection(this.fJarPackage.allowOverwrite());
    }

    protected void initializeJarPackage() {
        super.initializeJarPackage();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackage.setElements(this.getSelectedElements());
            this.fJarPackage.setExportClassFiles(settings.getBoolean(STORE_EXPORT_CLASS_FILES));
            this.fJarPackage.setExportOutputFolders(settings.getBoolean(STORE_EXPORT_OUTPUT_FOLDERS));
            this.fJarPackage.setExportJavaFiles(settings.getBoolean(STORE_EXPORT_JAVA_FILES));
            this.fJarPackage.setRefactoringAware(settings.getBoolean(STORE_REFACTORINGS));
            this.fJarPackage.setCompress(settings.getBoolean(STORE_COMPRESS));
            this.fJarPackage.setIncludeDirectoryEntries(settings.getBoolean(STORE_INCLUDE_DIRECTORY_ENTRIES));
            this.fJarPackage.setOverwrite(settings.getBoolean(STORE_OVERWRITE));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        if (this.fExportClassFilesCheckbox.getSelection() && !this.fJarPackage.areClassFilesExported()) {
            this.fExportOutputFoldersCheckbox.setSelection(false);
        }
        if (this.fExportOutputFoldersCheckbox.getSelection() && !this.fJarPackage.areOutputFoldersExported()) {
            this.fExportClassFilesCheckbox.setSelection(false);
        }
        this.fJarPackage.setExportClassFiles(this.fExportClassFilesCheckbox.getSelection());
        this.fJarPackage.setExportOutputFolders(this.fExportOutputFoldersCheckbox.getSelection());
        this.fJarPackage.setExportJavaFiles(this.fExportJavaFilesCheckbox.getSelection());
        this.fJarPackage.setElements(this.getSelectedElements());
        super.updateModel();
        if (this.fExportRefactoringsCheckbox != null) {
            this.fJarPackage.setRefactoringAware(this.fExportRefactoringsCheckbox.getSelection());
        } else {
            this.fJarPackage.setRefactoringAware(false);
        }
        this.fJarPackage.setCompress(this.fCompressCheckbox.getSelection());
        this.fJarPackage.setIncludeDirectoryEntries(this.fIncludeDirectoryEntriesCheckbox.getSelection());
        this.fJarPackage.setOverwrite(this.fOverwriteCheckbox.getSelection());
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected void createInputGroup(Composite parent) {
        int labelFlags = 272;
        StandardJavaElementContentProvider treeContentProvider = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object element) {
                return !(element instanceof IPackageFragment) && super.hasChildren(element);
            }
        };
        DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(labelFlags), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fInputGroup = new CheckboxTreeAndListGroup(parent, JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), treeContentProvider, (ILabelProvider)provider, (IStructuredContentProvider)new StandardJavaElementContentProvider(), (ILabelProvider)provider, 0, 480, 150){

            protected void setTreeChecked(Object element, boolean state) {
                IResource resource;
                if (JarPackageWizardPage.this.fInitiallySelecting && element instanceof IResource && (resource = (IResource)element).getName().charAt(0) == '.') {
                    return;
                }
                super.setTreeChecked(element, state);
            }
        };
        this.fInputGroup.addTreeFilter(new EmptyInnerPackageFilter());
        this.fInputGroup.setTreeComparator(new JavaElementComparator());
        this.fInputGroup.setListComparator(new JavaElementComparator());
        this.fInputGroup.addTreeFilter(new ContainerFilter(ContainerFilter.FILTER_NON_CONTAINERS));
        this.fInputGroup.addTreeFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object p, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    return !root.isArchive() && !root.isExternal();
                }
                return true;
            }
        });
        this.fInputGroup.addListFilter(new ContainerFilter(ContainerFilter.FILTER_CONTAINERS));
        this.fInputGroup.getTree().addListener(4, (Listener)this);
        this.fInputGroup.getTable().addListener(4, (Listener)this);
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JarPackageWizardPage.this.update();
            }
        };
        this.fInputGroup.addCheckStateListener(listener);
    }

    protected void createExportTypeGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.fExportClassFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportClassFilesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportClassFiles_text);
        this.fExportClassFilesCheckbox.addListener(13, (Listener)this);
        this.fExportOutputFoldersCheckbox = new Button(optionsGroup, 16416);
        this.fExportOutputFoldersCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportOutputFolders_text);
        this.fExportOutputFoldersCheckbox.addListener(13, (Listener)this);
        this.fExportJavaFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportJavaFilesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportJavaFiles_text);
        this.fExportJavaFilesCheckbox.addListener(13, (Listener)this);
        Composite refactoringsGroup = new Composite(optionsGroup, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        refactoringsGroup.setLayout((Layout)layout);
        this.fExportRefactoringsCheckbox = new Button(refactoringsGroup, 16416);
        this.fExportRefactoringsCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_refactorings_text);
        this.fExportRefactoringsCheckbox.addListener(13, (Listener)this);
        this.fRefactoringLink = new Link(refactoringsGroup, 64);
        this.fRefactoringLink.setText(JarPackagerMessages.JarPackageWizardPage_configure_label);
        this.fRefactoringLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JarPackageWizardPage.this.openRefactoringDialog();
            }
        });
        this.fRefactoringLink.setToolTipText(JarPackagerMessages.JarPackageWizardPage_configure_tooltip);
        GridData data = new GridData(513);
        this.fRefactoringLink.setLayoutData((Object)data);
        this.fExportRefactoringsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JarPackageWizardPage.this.fRefactoringLink.setEnabled(JarPackageWizardPage.this.fExportRefactoringsCheckbox.getSelection());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void openRefactoringDialog() {
        block14: {
            final RefactoringHistory[] history = new RefactoringHistory[1];
            final IRefactoringHistoryService service = RefactoringCore.getHistoryService();
            service.connect();
            final HashSet<IProject> set = new HashSet<IProject>();
            Object[] elements = this.fJarPackage.getElements();
            int index = 0;
            while (index < elements.length) {
                if (elements[index] instanceof IAdaptable) {
                    IResource resource;
                    IAdaptable adaptable = (IAdaptable)elements[index];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                        set.add(resource.getProject());
                    }
                }
                ++index;
            }
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        history[0] = service.getRefactoringHistory(set.toArray(new IProject[set.size()]), 0L, Long.MAX_VALUE, 65536, monitor);
                    }
                });
            }
            catch (InvocationTargetException exception) {
                ExceptionHandler.handle(exception, this.getShell(), JarPackagerMessages.JarPackageWizardPage_error_caption, JarPackagerMessages.JarPackageWizardPage_error_label);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            new JarRefactoringDialog(this.getShell(), this.getDialogSettings(), this.fJarPackage, history[0]).open();
            break block14;
            finally {
                service.disconnect();
            }
        }
        this.updatePageCompletion();
    }

    protected void updateWidgetEnablements() {
        if (this.fExportRefactoringsCheckbox != null) {
            boolean selection = this.fExportRefactoringsCheckbox.getSelection();
            this.fIncludeDirectoryEntriesCheckbox.setEnabled(!selection);
            if (selection) {
                this.fIncludeDirectoryEntriesCheckbox.setSelection(true);
                this.fJarPackage.setIncludeDirectoryEntries(true);
            }
        }
    }

    public boolean isPageComplete() {
        boolean complete = this.validateSourceGroup();
        complete = this.validateDestinationGroup() && complete;
        boolean bl = complete = this.validateOptionsGroup() && complete;
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
        this.updateRefactoringMessage();
    }

    protected void updateRefactoringMessage() {
        String currentMessage = this.getMessage();
        if (this.fJarPackage.isRefactoringAware() && this.fJarPackage.getRefactoringDescriptors().length == 0) {
            if (currentMessage == null) {
                this.setMessage(JarPackagerMessages.JarPackageWizardPage_no_refactorings_selected, 1);
            }
        } else if (JarPackagerMessages.JarPackageWizardPage_no_refactorings_selected.equals(currentMessage)) {
            this.setMessage(null);
        }
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        if (!(this.fExportClassFilesCheckbox.getSelection() || this.fExportOutputFoldersCheckbox.getSelection() || this.fExportJavaFilesCheckbox.getSelection())) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_noExportTypeChecked);
            return false;
        }
        if (this.getSelectedResources().size() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (this.fExportClassFilesCheckbox.getSelection() || this.fExportOutputFoldersCheckbox.getSelection()) {
            return true;
        }
        Iterator iter = this.getSelectedResourcesIterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IClassFile) {
                IClasspathEntry cpEntry;
                IPackageFragmentRoot root = (IPackageFragmentRoot)((IClassFile)element).getAncestor(3);
                if (root == null) continue;
                try {
                    cpEntry = root.getRawClasspathEntry();
                }
                catch (JavaModelException javaModelException) {
                    continue;
                }
                if (cpEntry.getEntryKind() != 1) continue;
                return true;
            }
            return true;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return false;
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected void setupBasedOnInitialSelections() {
        Iterator iterator = this.fInitialSelection.iterator();
        while (iterator.hasNext()) {
            IJavaElement je;
            Object selectedElement = iterator.next();
            if (selectedElement instanceof IResource && !((IResource)selectedElement).isAccessible() || selectedElement instanceof IJavaElement && !((IJavaElement)selectedElement).exists()) continue;
            if (selectedElement instanceof ICompilationUnit || selectedElement instanceof IClassFile || selectedElement instanceof IFile) {
                this.fInputGroup.initialCheckListItem(selectedElement);
                continue;
            }
            if (selectedElement instanceof IFolder && (je = JavaCore.create((IResource)((IResource)selectedElement))) != null && je.exists() && je.getJavaProject().isOnClasspath((IResource)selectedElement)) {
                selectedElement = je;
            }
            try {
                this.fInputGroup.initialCheckTreeItem(selectedElement);
            }
            finally {
                this.fInitiallySelecting = false;
            }
        }
        TreeItem[] items = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < items.length && !items[i].getChecked()) {
            ++i;
        }
        if (i < items.length) {
            this.fInputGroup.getTree().setSelection(new TreeItem[]{items[i]});
            this.fInputGroup.getTree().showSelection();
            this.fInputGroup.populateListViewer(items[i].getData());
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    Object[] getSelectedElementsWithoutContainedChildren() {
        Set closure = this.removeContainedChildren(this.fInputGroup.getWhiteCheckedTreeItems());
        closure.addAll(this.getExportedNonContainers());
        return closure.toArray();
    }

    private Set removeContainedChildren(Set elements) {
        HashSet newList = new HashSet(elements.size());
        Set javaElementResources = this.getCorrespondingContainers(elements);
        Iterator iter = elements.iterator();
        boolean removedOne = false;
        while (iter.hasNext()) {
            IContainer parent;
            Object element = iter.next();
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IJavaElement) {
                parent = ((IJavaElement)element).getParent();
                if (parent instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)parent;
                    try {
                        if (pkgRoot.getCorrespondingResource() instanceof IProject) {
                            parent = pkgRoot.getJavaProject();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            } else {
                newList.add(element);
                continue;
            }
            if (element instanceof IJavaModel || !(parent instanceof IJavaModel) && (elements.contains(parent) || javaElementResources.contains(parent))) {
                removedOne = true;
                continue;
            }
            newList.add(element);
        }
        if (removedOne) {
            return this.removeContainedChildren(newList);
        }
        return newList;
    }

    private Set getExportedNonContainers() {
        Set whiteCheckedTreeItems = this.fInputGroup.getWhiteCheckedTreeItems();
        HashSet exportedNonContainers = new HashSet(whiteCheckedTreeItems.size());
        Set javaElementResources = this.getCorrespondingContainers(whiteCheckedTreeItems);
        Iterator iter = this.fInputGroup.getAllCheckedListItems();
        while (iter.hasNext()) {
            Object element = iter.next();
            IContainer parent = null;
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IJavaElement) {
                parent = ((IJavaElement)element).getParent();
            }
            if (whiteCheckedTreeItems.contains(parent) || javaElementResources.contains(parent)) continue;
            exportedNonContainers.add(element);
        }
        return exportedNonContainers;
    }

    private Set getCorrespondingContainers(Set elements) {
        HashSet<IResource> javaElementResources = new HashSet<IResource>(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IResource resource;
            IJavaElement je;
            int type;
            Object element = iter.next();
            if (!(element instanceof IJavaElement) || (type = (je = (IJavaElement)element).getElementType()) != 2 && type != 4 && type != 3 || type == 4 && ((IPackageFragment)element).isDefaultPackage()) continue;
            try {
                resource = je.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                resource = null;
            }
            if (resource == null) continue;
            javaElementResources.add(resource);
        }
        return javaElementResources;
    }

    private Object[] getSelectedElements() {
        return this.getSelectedResources().toArray();
    }
}

