/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.net.URL;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class OpenExternalBrowserAction
extends SelectionDispatchAction {
    public OpenExternalBrowserAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenExternalBrowserAction_javadoc_label);
        this.setToolTipText(ActionMessages.OpenExternalBrowserAction_javadoc_toolTip);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_EXTERNAL_BROWSER);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_EXTERNAL_BROWSER);
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (this.canEnable(selection)) {
            this.setEnabled(true);
            Object element = selection.getFirstElement();
            if (element instanceof URL) {
                this.setText(ActionMessages.OpenExternalBrowserAction_url_label);
                this.setToolTipText(ActionMessages.OpenExternalBrowserAction_url_toolTip);
            } else {
                this.setText(ActionMessages.OpenExternalBrowserAction_javadoc_label);
                this.setToolTipText(ActionMessages.OpenExternalBrowserAction_javadoc_toolTip);
            }
        } else {
            this.setEnabled(false);
            this.setText(ActionMessages.OpenExternalBrowserAction_javadoc_label);
            this.setToolTipText(ActionMessages.OpenExternalBrowserAction_javadoc_toolTip);
        }
    }

    public void run(IStructuredSelection selection) {
        URL url;
        Object element = selection.getFirstElement();
        if (element instanceof IJavaElement) {
            try {
                url = JavaUI.getJavadocLocation((IJavaElement)element, true);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return;
            }
        } else {
            url = (URL)element;
        }
        OpenBrowserUtil.open(url, this.getShell().getDisplay(), null);
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof URL) {
            return true;
        }
        if (!(element instanceof IJavaElement)) {
            return false;
        }
        IJavaElement input = (IJavaElement)element;
        try {
            URL url = JavaUI.getJavadocLocation(input, true);
            return url != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

