/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MoveCuUpdateCreator {
    private final String fNewPackage;
    private ICompilationUnit[] fCus;
    private IPackageFragment fDestination;
    private Map fImportRewrites;

    public MoveCuUpdateCreator(ICompilationUnit cu, IPackageFragment pack) {
        this(new ICompilationUnit[]{cu}, pack);
    }

    public MoveCuUpdateCreator(ICompilationUnit[] cus, IPackageFragment pack) {
        Assert.isNotNull((Object)cus);
        Assert.isNotNull((Object)pack);
        this.fCus = cus;
        this.fDestination = pack;
        this.fImportRewrites = new HashMap();
        this.fNewPackage = this.fDestination.isDefaultPackage() ? "" : String.valueOf(this.fDestination.getElementName()) + '.';
    }

    public TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        pm.beginTask("", 5);
        try {
            TextChangeManager changeManager = new TextChangeManager();
            this.addUpdates(changeManager, (IProgressMonitor)new SubProgressMonitor(pm, 4), status);
            this.addImportRewriteUpdates(changeManager);
            TextChangeManager textChangeManager = changeManager;
            return textChangeManager;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        finally {
            pm.done();
        }
    }

    private void addImportRewriteUpdates(TextChangeManager changeManager) throws CoreException {
        Iterator iter = this.fImportRewrites.keySet().iterator();
        while (iter.hasNext()) {
            ICompilationUnit cu = (ICompilationUnit)iter.next();
            ImportRewrite importRewrite = (ImportRewrite)this.fImportRewrites.get(cu);
            if (importRewrite == null || !importRewrite.hasRecordedChanges()) continue;
            TextChangeCompatibility.addTextEdit(changeManager.get(cu), RefactoringCoreMessages.MoveCuUpdateCreator_update_imports, importRewrite.rewriteImports(null));
        }
    }

    private void addUpdates(TextChangeManager changeManager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", this.fCus.length);
        int i = 0;
        while (i < this.fCus.length) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addUpdates(changeManager, this.fCus[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            ++i;
        }
    }

    private void addUpdates(TextChangeManager changeManager, ICompilationUnit movedUnit, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        try {
            pm.beginTask("", 3);
            pm.subTask(Messages.format(RefactoringCoreMessages.MoveCuUpdateCreator_searching, BasicElementLabels.getFileName((ITypeRoot)movedUnit)));
            if (MoveCuUpdateCreator.isInAnotherFragmentOfSamePackage(movedUnit, this.fDestination)) {
                pm.worked(3);
                return;
            }
            this.addImportToSourcePackageTypes(movedUnit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.removeImportsToDestinationPackageTypes(movedUnit);
            this.addReferenceUpdates(changeManager, movedUnit, (IProgressMonitor)new SubProgressMonitor(pm, 2), status);
        }
        finally {
            pm.done();
        }
    }

    private void addReferenceUpdates(TextChangeManager changeManager, ICompilationUnit movedUnit, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException, CoreException {
        List<ICompilationUnit> cuList = Arrays.asList(this.fCus);
        SearchResultGroup[] references = MoveCuUpdateCreator.getReferences(movedUnit, pm, status);
        int i = 0;
        while (i < references.length) {
            SearchResultGroup searchResultGroup = references[i];
            ICompilationUnit referencingCu = searchResultGroup.getCompilationUnit();
            if (referencingCu != null) {
                boolean simpleReferencesNeedNewImport = this.simpleReferencesNeedNewImport(movedUnit, referencingCu, cuList);
                SearchMatch[] results = searchResultGroup.getSearchResults();
                int j = 0;
                while (j < results.length) {
                    TypeReference reference = (TypeReference)results[j];
                    if (reference.isImportDeclaration()) {
                        ImportRewrite rewrite = this.getImportRewrite(referencingCu);
                        IImportDeclaration importDecl = (IImportDeclaration)SearchUtils.getEnclosingJavaElement(results[j]);
                        if (Flags.isStatic((int)importDecl.getFlags())) {
                            rewrite.removeStaticImport(importDecl.getElementName());
                            this.addStaticImport(movedUnit, importDecl, rewrite);
                        } else {
                            rewrite.removeImport(importDecl.getElementName());
                            rewrite.addImport(this.createStringForNewImport(movedUnit, importDecl));
                        }
                    } else if (reference.isQualified()) {
                        TextChange textChange = changeManager.get(referencingCu);
                        String changeName = RefactoringCoreMessages.MoveCuUpdateCreator_update_references;
                        ReplaceEdit replaceEdit = new ReplaceEdit(reference.getOffset(), reference.getSimpleNameStart() - reference.getOffset(), this.fNewPackage);
                        TextChangeCompatibility.addTextEdit(textChange, changeName, (TextEdit)replaceEdit);
                    } else if (simpleReferencesNeedNewImport) {
                        ImportRewrite importEdit = this.getImportRewrite(referencingCu);
                        String typeName = reference.getSimpleName();
                        importEdit.addImport(this.getQualifiedType(this.fDestination.getElementName(), typeName));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addStaticImport(ICompilationUnit movedUnit, IImportDeclaration importDecl, ImportRewrite rewrite) {
        String old = importDecl.getElementName();
        int oldPackLength = movedUnit.getParent().getElementName().length();
        StringBuffer result = new StringBuffer(this.fDestination.getElementName());
        if (oldPackLength == 0) {
            result.append('.').append(old);
        } else if (result.length() == 0) {
            result.append(old.substring(oldPackLength + 1));
        } else {
            result.append(old.substring(oldPackLength));
        }
        int index = result.lastIndexOf(".");
        if (index > 0 && index < result.length() - 1) {
            rewrite.addStaticImport(result.substring(0, index), result.substring(index + 1, result.length()), true);
        }
    }

    private String getQualifiedType(String packageName, String typeName) {
        if (packageName.length() == 0) {
            return typeName;
        }
        return String.valueOf(packageName) + '.' + typeName;
    }

    private String createStringForNewImport(ICompilationUnit movedUnit, IImportDeclaration importDecl) {
        String old = importDecl.getElementName();
        int oldPackLength = movedUnit.getParent().getElementName().length();
        StringBuffer result = new StringBuffer(this.fDestination.getElementName());
        if (oldPackLength == 0) {
            result.append('.').append(old);
        } else if (result.length() == 0) {
            result.append(old.substring(oldPackLength + 1));
        } else {
            result.append(old.substring(oldPackLength));
        }
        return result.toString();
    }

    private void removeImportsToDestinationPackageTypes(ICompilationUnit movedUnit) throws CoreException {
        ImportRewrite importEdit = this.getImportRewrite(movedUnit);
        IType[] destinationTypes = this.getDestinationPackageTypes();
        int i = 0;
        while (i < destinationTypes.length) {
            importEdit.removeImport(destinationTypes[i].getFullyQualifiedName('.'));
            ++i;
        }
    }

    private IType[] getDestinationPackageTypes() throws JavaModelException {
        ArrayList<IType> types = new ArrayList<IType>();
        if (this.fDestination.exists()) {
            ICompilationUnit[] cus = this.fDestination.getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                types.addAll(Arrays.asList(cus[i].getAllTypes()));
                ++i;
            }
        }
        return types.toArray(new IType[types.size()]);
    }

    private void addImportToSourcePackageTypes(ICompilationUnit movedUnit, IProgressMonitor pm) throws CoreException {
        List<ICompilationUnit> cuList = Arrays.asList(this.fCus);
        IType[] allCuTypes = movedUnit.getAllTypes();
        IType[] referencedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])allCuTypes, pm);
        ImportRewrite importEdit = this.getImportRewrite(movedUnit);
        importEdit.setFilterImplicitImports(false);
        IPackageFragment srcPack = (IPackageFragment)movedUnit.getParent();
        int i = 0;
        while (i < referencedTypes.length) {
            IType iType = referencedTypes[i];
            if (iType.exists() && iType.getPackageFragment().equals(srcPack) && !cuList.contains(iType.getCompilationUnit())) {
                importEdit.addImport(iType.getFullyQualifiedName('.'));
            }
            ++i;
        }
    }

    private ImportRewrite getImportRewrite(ICompilationUnit cu) throws CoreException {
        if (this.fImportRewrites.containsKey(cu)) {
            return (ImportRewrite)this.fImportRewrites.get(cu);
        }
        ImportRewrite importEdit = StubUtility.createImportRewrite(cu, true);
        this.fImportRewrites.put(cu, importEdit);
        return importEdit;
    }

    private boolean simpleReferencesNeedNewImport(ICompilationUnit movedUnit, ICompilationUnit referencingCu, List cuList) {
        if (referencingCu.equals(movedUnit)) {
            return false;
        }
        if (cuList.contains(referencingCu)) {
            return false;
        }
        if (this.isReferenceInAnotherFragmentOfSamePackage(referencingCu, movedUnit)) {
            return true;
        }
        if (referencingCu.getImport(String.valueOf(movedUnit.getParent().getElementName()) + ".*").exists()) {
            return true;
        }
        return referencingCu.getParent().equals(movedUnit.getParent());
    }

    private boolean isReferenceInAnotherFragmentOfSamePackage(ICompilationUnit referencingCu, ICompilationUnit movedUnit) {
        if (referencingCu == null) {
            return false;
        }
        if (!(referencingCu.getParent() instanceof IPackageFragment)) {
            return false;
        }
        IPackageFragment pack = (IPackageFragment)referencingCu.getParent();
        return MoveCuUpdateCreator.isInAnotherFragmentOfSamePackage(movedUnit, pack);
    }

    private static boolean isInAnotherFragmentOfSamePackage(ICompilationUnit cu, IPackageFragment pack) {
        if (!(cu.getParent() instanceof IPackageFragment)) {
            return false;
        }
        IPackageFragment cuPack = (IPackageFragment)cu.getParent();
        return !cuPack.equals(pack) && JavaModelUtil.isSamePackage(cuPack, pack);
    }

    private static SearchResultGroup[] getReferences(ICompilationUnit unit, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])unit.getTypes(), 2);
        if (pattern != null) {
            String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getFileName((ITypeRoot)unit));
            ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
            Collector requestor = new Collector((IPackageFragment)unit.getParent(), binaryRefs);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)unit, true, false);
            SearchResultGroup[] result = RefactoringSearchEngine.search(pattern, scope, requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            binaryRefs.addErrorIfNecessary(status);
            return result;
        }
        return new SearchResultGroup[0];
    }

    private static final class Collector
    extends CollectingSearchRequestor {
        private IPackageFragment fSource;
        private IScanner fScanner;

        public Collector(IPackageFragment source, ReferencesInBinaryContext binaryRefs) {
            super(binaryRefs);
            this.fSource = source;
            this.fScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (this.filterMatch(match)) {
                return;
            }
            IJavaElement element = SearchUtils.getEnclosingJavaElement(match);
            int accuracy = match.getAccuracy();
            int start = match.getOffset();
            int length = match.getLength();
            boolean insideDocComment = match.isInsideDocComment();
            IResource res = match.getResource();
            if (element.getAncestor(13) != null) {
                this.collectMatch((SearchMatch)TypeReference.createImportReference(element, accuracy, start, length, insideDocComment, res));
            } else {
                ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
                if (unit != null) {
                    IBuffer buffer = unit.getBuffer();
                    String matchText = buffer.getText(start, length);
                    if (this.fSource.isDefaultPackage()) {
                        this.collectMatch((SearchMatch)TypeReference.createSimpleReference(element, accuracy, start, length, insideDocComment, res, matchText));
                    } else {
                        int simpleNameStart = this.getLastSimpleNameStart(matchText);
                        if (simpleNameStart != 0) {
                            this.collectMatch((SearchMatch)TypeReference.createQualifiedReference(element, accuracy, start, length, insideDocComment, res, start + simpleNameStart));
                        } else {
                            this.collectMatch((SearchMatch)TypeReference.createSimpleReference(element, accuracy, start, length, insideDocComment, res, matchText));
                        }
                    }
                }
            }
        }

        private int getLastSimpleNameStart(String reference) {
            this.fScanner.setSource(reference.toCharArray());
            int lastIdentifierStart = -1;
            try {
                int tokenType = this.fScanner.getNextToken();
                while (tokenType != 158) {
                    if (tokenType == 5) {
                        lastIdentifierStart = this.fScanner.getCurrentTokenStartPosition();
                    }
                    tokenType = this.fScanner.getNextToken();
                }
            }
            catch (InvalidInputException e) {
                JavaPlugin.log(e);
            }
            return lastIdentifierStart;
        }
    }

    private static final class TypeReference
    extends TypeReferenceMatch {
        private String fSimpleTypeName;
        private int fSimpleNameStart;

        private TypeReference(IJavaElement enclosingElement, int accuracy, int start, int length, boolean insideDocComment, IResource resource, int simpleNameStart, String simpleName) {
            super(enclosingElement, accuracy, start, length, insideDocComment, SearchEngine.getDefaultSearchParticipant(), resource);
            this.fSimpleNameStart = simpleNameStart;
            this.fSimpleTypeName = simpleName;
        }

        public static TypeReference createQualifiedReference(IJavaElement enclosingElement, int accuracy, int start, int length, boolean insideDocComment, IResource resource, int simpleNameStart) {
            Assert.isTrue((start < simpleNameStart && simpleNameStart < start + length ? 1 : 0) != 0);
            return new TypeReference(enclosingElement, accuracy, start, length, insideDocComment, resource, simpleNameStart, null);
        }

        public static TypeReference createImportReference(IJavaElement enclosingElement, int accuracy, int start, int length, boolean insideDocComment, IResource resource) {
            return new TypeReference(enclosingElement, accuracy, start, length, insideDocComment, resource, -1, null);
        }

        public static TypeReference createSimpleReference(IJavaElement enclosingElement, int accuracy, int start, int length, boolean insideDocComment, IResource resource, String simpleName) {
            return new TypeReference(enclosingElement, accuracy, start, length, insideDocComment, resource, -1, simpleName);
        }

        public boolean isImportDeclaration() {
            return SearchUtils.getEnclosingJavaElement((SearchMatch)this).getAncestor(13) != null;
        }

        public boolean isQualified() {
            return this.fSimpleNameStart != -1;
        }

        public boolean isSimpleReference() {
            return this.fSimpleTypeName != null;
        }

        public int getSimpleNameStart() {
            return this.fSimpleNameStart;
        }

        public String getSimpleName() {
            return this.fSimpleTypeName;
        }
    }
}

