/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.ReplaceEdit;

public class RenameNonVirtualMethodProcessor
extends RenameMethodProcessor {
    RenameNonVirtualMethodProcessor(IMethod method, TextChangeManager manager, GroupCategorySet categorySet) {
        super(method, manager, categorySet);
    }

    public RenameNonVirtualMethodProcessor(IMethod method) {
        super(method);
    }

    public RenameNonVirtualMethodProcessor(IMethod method, JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(method);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameNonVirtualMethodAvailable(this.getMethod());
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        try {
            pm.beginTask("", 3);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(super.doCheckFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), checkContext));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IMethod method = this.getMethod();
            IType declaring = method.getDeclaringType();
            String name = this.getNewElementName();
            IMethod[] hierarchyMethods = RenameNonVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), declaring.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)), method, name);
            int i = 0;
            while (i < hierarchyMethods.length) {
                String message;
                IMethod hierarchyMethod = hierarchyMethods[i];
                RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                if (Checks.compareParamTypes(method.getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                    message = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines, new String[]{declaring.getFullyQualifiedName('.'), name});
                    result.addError(message, context);
                } else {
                    message = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines2, new String[]{declaring.getFullyQualifiedName('.'), name});
                    result.addWarning(message, context);
                }
                ++i;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 1);
        this.addDeclarationUpdate(manager);
        if (this.getUpdateReferences()) {
            this.addReferenceUpdates(manager, pm);
        }
        pm.worked(1);
    }

    private ICompilationUnit getDeclaringCU() {
        return this.getMethod().getCompilationUnit();
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        if (this.getDelegateUpdating()) {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.getDeclaringCU());
            rewrite.setResolveBindings(true);
            MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.getMethod(), rewrite.getRoot());
            DelegateMethodCreator creator = new DelegateMethodCreator();
            creator.setDeclaration((BodyDeclaration)methodDeclaration);
            creator.setDeclareDeprecated(this.getDeprecateDelegates());
            creator.setSourceRewrite(rewrite);
            creator.setCopy(true);
            creator.setNewElementName(this.getNewElementName());
            creator.prepareDelegate();
            creator.createEdit();
            CompilationUnitChange cuChange = rewrite.createChange();
            if (cuChange != null) {
                cuChange.setKeepPreviewEdits(true);
                manager.manage(this.getDeclaringCU(), (TextChange)cuChange);
            }
        }
        String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_declaration;
        ISourceRange nameRange = this.getMethod().getNameRange();
        ReplaceEdit replaceEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        this.addTextEdit(manager.get(this.getDeclaringCU()), editName, replaceEdit);
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        SearchResultGroup[] grouped = this.getOccurrences();
        int i = 0;
        while (i < grouped.length) {
            SearchResultGroup group = grouped[i];
            SearchMatch[] results = group.getSearchResults();
            ICompilationUnit cu = group.getCompilationUnit();
            TextChange change = manager.get(cu);
            int j = 0;
            while (j < results.length) {
                SearchMatch match = results[j];
                if (!(match instanceof MethodDeclarationMatch)) {
                    ReplaceEdit replaceEdit = this.createReplaceEdit(match, cu);
                    String editName = RefactoringCoreMessages.RenamePrivateMethodRefactoring_update;
                    this.addTextEdit(change, editName, replaceEdit);
                }
                ++j;
            }
            ++i;
        }
        pm.done();
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

