/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateFieldCreator;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameFieldProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IDelegateUpdating {
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    protected IField fField;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    protected boolean fUpdateReferences;
    protected boolean fUpdateTextualMatches;
    private boolean fRenameGetter;
    private boolean fRenameSetter;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;

    public RenameFieldProcessor(IField field) {
        this(field, new TextChangeManager(true), null);
        this.fIsComposite = false;
    }

    public RenameFieldProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    RenameFieldProcessor(IField field, TextChangeManager manager, GroupCategorySet categorySet) {
        this.initialize(field);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        this.fIsComposite = true;
    }

    private void initialize(IField field) {
        this.fField = field;
        if (this.fField != null) {
            this.setNewElementName(this.fField.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameGetter = false;
        this.fRenameSetter = false;
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameFieldProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameFieldAvailable(this.fField);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameFieldRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fField);
    }

    public IField getField() {
        return this.fField;
    }

    public Object[] getElements() {
        return new Object[]{this.fField};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        IMethod setter;
        IMethod getter;
        RenameModifications result = new RenameModifications();
        result.rename(this.fField, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameGetter && (getter = this.getGetter()) != null) {
            result.rename(getter, new RenameArguments(this.getNewGetterName(), this.getUpdateReferences()));
        }
        if (this.fRenameSetter && (setter = this.getSetter()) != null) {
            result.rename(setter, new RenameArguments(this.getNewSetterName(), this.getUpdateReferences()));
        }
        return result;
    }

    protected IFile[] getChangedFiles() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    public final String getCurrentElementName() {
        return this.fField.getElementName();
    }

    public final String getCurrentElementQualifier() {
        return this.fField.getDeclaringType().getFullyQualifiedName('.');
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkFieldName(newName, (IJavaElement)this.fField);
        if (RenameFieldProcessor.isInstanceField(this.fField) && !Checks.startsWithLowerCase(newName)) {
            result.addWarning(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_should_start_lowercase2, new String[]{newName, this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameFieldRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fField, newName)) {
            result.addError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_another_name2, new String[]{newName, this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameFieldRefactoring_another_name, JavaStatusContext.create((IMember)this.fField));
        }
        if (this.fField.getDeclaringType().getField(newName).exists()) {
            result.addError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined2, new String[]{newName, this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined, JavaStatusContext.create((IMember)this.fField.getDeclaringType().getField(newName)));
        }
        return result;
    }

    private String getDeclaringTypeLabel() {
        return JavaElementLabels.getElementLabel((IJavaElement)this.fField.getDeclaringType(), JavaElementLabels.ALL_DEFAULT);
    }

    public Object getNewElement() {
        return this.fField.getDeclaringType().getField(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String canEnableGetterRenaming() throws CoreException {
        ITypeHierarchy hierarchy;
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getGetter() == null ? "" : null;
        }
        IMethod getter = this.getGetter();
        if (getter == null) {
            return "";
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (MethodChecks.isVirtual(getter) && (MethodChecks.isDeclaredInInterface(getter, hierarchy = getter.getDeclaringType().newTypeHierarchy((IProgressMonitor)monitor), (IProgressMonitor)monitor) != null || MethodChecks.overridesAnotherMethod(getter, hierarchy) != null)) {
            return RefactoringCoreMessages.RenameFieldRefactoring_declared_in_supertype;
        }
        return null;
    }

    public String canEnableSetterRenaming() throws CoreException {
        ITypeHierarchy hierarchy;
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getSetter() == null ? "" : null;
        }
        IMethod setter = this.getSetter();
        if (setter == null) {
            return "";
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (MethodChecks.isVirtual(setter) && (MethodChecks.isDeclaredInInterface(setter, hierarchy = setter.getDeclaringType().newTypeHierarchy((IProgressMonitor)monitor), (IProgressMonitor)monitor) != null || MethodChecks.overridesAnotherMethod(setter, hierarchy) != null)) {
            return RefactoringCoreMessages.RenameFieldRefactoring_declared_in_supertype;
        }
        return null;
    }

    public boolean getRenameGetter() {
        return this.fRenameGetter;
    }

    public void setRenameGetter(boolean renameGetter) {
        this.fRenameGetter = renameGetter;
    }

    public boolean getRenameSetter() {
        return this.fRenameSetter;
    }

    public void setRenameSetter(boolean renameSetter) {
        this.fRenameSetter = renameSetter;
    }

    public IMethod getGetter() throws CoreException {
        return GetterSetterUtil.getGetter(this.fField);
    }

    public IMethod getSetter() throws CoreException {
        return GetterSetterUtil.getSetter(this.fField);
    }

    public String getNewGetterName() throws CoreException {
        IMethod primaryGetterCandidate = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(this.fField, new String[0]), new String[0], false, this.fField.getDeclaringType());
        if (!JavaModelUtil.isBoolean(this.fField) || primaryGetterCandidate != null && primaryGetterCandidate.exists()) {
            return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
        }
        return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), false, null);
    }

    public String getNewSetterName() throws CoreException {
        return GetterSetterUtil.getSetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
    }

    public boolean canEnableDelegateUpdating() {
        return this.getDelegateCount() > 0;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean update) {
        this.fDelegateUpdating = update;
    }

    public void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public int getDelegateCount() {
        int count = 0;
        try {
            if (RefactoringAvailabilityTester.isDelegateCreationAvailable(this.getField())) {
                ++count;
            }
            if (this.fRenameGetter && this.getGetter() != null) {
                ++count;
            }
            if (this.fRenameSetter && this.getSetter() != null) {
                ++count;
            }
        }
        catch (CoreException coreException) {}
        return count;
    }

    public int getSaveMode() {
        return 3;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IField primary = (IField)this.fField.getPrimaryElement();
        if (primary == null || !primary.exists()) {
            String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_deleted, BasicElementLabels.getFileName((ITypeRoot)this.fField.getCompilationUnit()));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fField = primary;
        return Checks.checkIfCuBroken((IMember)this.fField);
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            pm.beginTask("", 18);
            pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(Checks.checkIfCuBroken((IMember)this.fField));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            result.merge(this.checkEnclosingHierarchy());
            pm.worked(1);
            result.merge(this.checkNestedHierarchy(this.fField.getDeclaringType()));
            pm.worked(1);
            if (this.fUpdateReferences) {
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_searching);
                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            } else {
                this.fReferences = new SearchResultGroup[0];
                pm.worked(3);
            }
            if (this.fUpdateReferences) {
                result.merge(this.analyzeAffectedCompilationUnits());
            } else {
                Checks.checkCompileErrorsInAffectedFile(result, this.fField.getResource());
            }
            if (this.getGetter() != null && this.fRenameGetter) {
                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getGetter(), this.getNewGetterName()));
                result.merge(Checks.checkIfConstructorName(this.getGetter(), this.getNewGetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            if (this.getSetter() != null && this.fRenameSetter) {
                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getSetter(), this.getNewSetterName()));
                result.merge(Checks.checkIfConstructorName(this.getSetter(), this.getNewSetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            result.merge(this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 10)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkAccessor(IProgressMonitor pm, IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessorDeclarations(pm, existingAccessor));
        result.merge(this.checkNewAccessor(existingAccessor, newAccessorName));
        return result;
    }

    private RefactoringStatus checkNewAccessor(IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod accessor = JavaModelUtil.findMethod(newAccessorName, existingAccessor.getParameterTypes(), false, this.fField.getDeclaringType());
        if (accessor == null || !accessor.exists()) {
            return null;
        }
        String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_already_exists, new String[]{JavaElementUtil.createMethodSignature(accessor), this.fField.getDeclaringType().getFullyQualifiedName('.')});
        result.addError(message, JavaStatusContext.create((IMember)accessor));
        return result;
    }

    private RefactoringStatus checkAccessorDeclarations(IProgressMonitor pm, IMethod existingAccessor) throws CoreException {
        IJavaSearchScope scope;
        RefactoringStatus result = new RefactoringStatus();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)existingAccessor, (int)0, (int)24);
        SearchResultGroup[] groupDeclarations = RefactoringSearchEngine.search(pattern, scope = SearchEngine.createHierarchyScope((IType)this.fField.getDeclaringType()), pm, result);
        Assert.isTrue((groupDeclarations.length > 0 ? 1 : 0) != 0);
        if (groupDeclarations.length != 1) {
            String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_overridden, JavaElementUtil.createMethodSignature(existingAccessor));
            result.addError(message);
        } else {
            SearchResultGroup group = groupDeclarations[0];
            Assert.isTrue((group.getSearchResults().length > 0 ? 1 : 0) != 0);
            if (group.getSearchResults().length != 1) {
                String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_overridden_or_overrides, JavaElementUtil.createMethodSignature(existingAccessor));
                result.addError(message);
            }
        }
        return result;
    }

    private static boolean isInstanceField(IField field) throws CoreException {
        if (JavaModelUtil.isInterfaceOrAnnotation(field.getDeclaringType())) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)field);
    }

    private RefactoringStatus checkNestedHierarchy(IType type) throws CoreException {
        IType[] nestedTypes = type.getTypes();
        if (nestedTypes == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < nestedTypes.length) {
            IField otherField = nestedTypes[i].getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_hiding, new String[]{this.fField.getElementName(), this.getNewElementName(), nestedTypes[i].getFullyQualifiedName('.')});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            result.merge(this.checkNestedHierarchy(nestedTypes[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkEnclosingHierarchy() {
        IType current = this.fField.getDeclaringType();
        if (Checks.isTopLevel(current)) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        while (current != null) {
            IField otherField = current.getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_hiding2, new String[]{this.getNewElementName(), current.getFullyQualifiedName('.'), otherField.getElementName()});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            current = current.getDeclaringType();
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return result;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.fField, (int)2);
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fField, true, false);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, this.getCurrentElementName());
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        SearchResultGroup[] result = RefactoringSearchEngine.search(this.createSearchPattern(), this.createRefactoringScope(), new CuCollectingSearchRequestor(binaryRefs), pm, status);
        binaryRefs.addErrorIfNecessary(status);
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 1);
            TextChange[] changes = this.fChangeManager.getAllChanges();
            RenameJavaElementDescriptor descriptor = this.createRefactoringDescriptor();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, this.getProcessorName(), (Change[])changes);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    protected RenameJavaElementDescriptor createRefactoringDescriptor() {
        String project = null;
        IJavaProject javaProject = this.fField.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589826;
        try {
            if (!Flags.isPrivate((int)this.fField.getFlags())) {
                flags |= 4;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        IType declaring = this.fField.getDeclaringType();
        try {
            if (declaring.isAnonymous() || declaring.isLocal()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_descriptor_description_short, this.fField.getElementName());
        String header = Messages.format(RefactoringCoreMessages.RenameFieldProcessor_descriptor_description, new String[]{this.fField.getElementName(), JavaElementLabels.getElementLabel(this.fField.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        if (this.fRenameGetter) {
            comment.addSetting(RefactoringCoreMessages.RenameFieldRefactoring_setting_rename_getter);
        }
        if (this.fRenameSetter) {
            comment.addSetting(RefactoringCoreMessages.RenameFieldRefactoring_setting_rename_settter);
        }
        RenameJavaElementDescriptor descriptor = new RenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.field");
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment.asString());
        descriptor.setFlags(flags);
        descriptor.setJavaElement((IJavaElement)this.fField);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
        descriptor.setRenameGetters(this.fRenameGetter);
        descriptor.setRenameSetters(this.fRenameSetter);
        descriptor.setKeepOriginal(this.fDelegateUpdating);
        descriptor.setDeprecateDelegate(this.fDelegateDeprecation);
        return descriptor;
    }

    private RefactoringStatus createChanges(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 10);
        RefactoringStatus result = new RefactoringStatus();
        if (!this.fIsComposite) {
            this.fChangeManager.clear();
        }
        if (this.fDelegateUpdating) {
            result.merge(this.addDelegates());
        }
        this.addDeclarationUpdate();
        if (this.fUpdateReferences) {
            this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 2)));
            if (result.hasFatalError()) {
                return result;
            }
        } else {
            pm.worked(3);
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addGetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        } else {
            pm.worked(1);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addSetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        } else {
            pm.worked(1);
        }
        if (this.fUpdateTextualMatches) {
            this.addTextMatches((IProgressMonitor)new SubProgressMonitor(pm, 5));
        } else {
            pm.worked(5);
        }
        pm.done();
        return result;
    }

    private void addDeclarationUpdate() throws CoreException {
        ISourceRange nameRange = this.fField.getNameRange();
        ReplaceEdit textEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        ICompilationUnit cu = this.fField.getCompilationUnit();
        String groupName = RefactoringCoreMessages.RenameFieldRefactoring_Update_field_declaration;
        this.addTextEdit(this.fChangeManager.get(cu), groupName, (TextEdit)textEdit);
    }

    private RefactoringStatus addDelegates() throws JavaModelException, CoreException {
        CompilationUnitChange change;
        RefactoringStatus status = new RefactoringStatus();
        CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fField.getCompilationUnit());
        rewrite.setResolveBindings(true);
        if (RefactoringAvailabilityTester.isDelegateCreationAvailable(this.fField)) {
            FieldDeclaration fieldDeclaration = ASTNodeSearchUtil.getFieldDeclarationNode(this.fField, rewrite.getRoot());
            if (fieldDeclaration.fragments().size() > 1) {
                status.addWarning(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_more_than_one_fragment, this.fField.getElementName()), JavaStatusContext.create((IMember)this.fField));
            } else if (((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getInitializer() == null) {
                status.addWarning(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_no_initializer, this.fField.getElementName()), JavaStatusContext.create((IMember)this.fField));
            } else {
                DelegateFieldCreator creator = new DelegateFieldCreator();
                creator.setDeclareDeprecated(this.fDelegateDeprecation);
                creator.setDeclaration((BodyDeclaration)fieldDeclaration);
                creator.setNewElementName(this.getNewElementName());
                creator.setSourceRewrite(rewrite);
                creator.prepareDelegate();
                creator.createEdit();
            }
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addMethodDelegate(this.getGetter(), this.getNewGetterName(), rewrite);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addMethodDelegate(this.getSetter(), this.getNewSetterName(), rewrite);
        }
        if ((change = rewrite.createChange()) != null) {
            change.setKeepPreviewEdits(true);
            this.fChangeManager.manage(this.fField.getCompilationUnit(), (TextChange)change);
        }
        return status;
    }

    private void addMethodDelegate(IMethod getter, String newName, CompilationUnitRewrite rewrite) throws JavaModelException {
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(getter, rewrite.getRoot());
        DelegateMethodCreator creator = new DelegateMethodCreator();
        creator.setDeclareDeprecated(this.fDelegateDeprecation);
        creator.setDeclaration((BodyDeclaration)declaration);
        creator.setNewElementName(newName);
        creator.setSourceRewrite(rewrite);
        creator.prepareDelegate();
        creator.createEdit();
    }

    private void addTextEdit(TextChange change, String groupName, TextEdit textEdit) {
        if (this.fIsComposite) {
            TextChangeCompatibility.addTextEdit(change, groupName, textEdit, this.fCategorySet);
        } else {
            TextChangeCompatibility.addTextEdit(change, groupName, textEdit);
        }
    }

    private void addReferenceUpdates(IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        String editName = RefactoringCoreMessages.RenameFieldRefactoring_Update_field_reference;
        int i = 0;
        while (i < this.fReferences.length) {
            ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu != null) {
                SearchMatch[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    this.addTextEdit(this.fChangeManager.get(cu), editName, this.createTextChange(results[j]));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private TextEdit createTextChange(SearchMatch match) {
        return new ReplaceEdit(match.getOffset(), match.getLength(), this.getNewElementName());
    }

    private void addGetterOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        this.addAccessorOccurrences(pm, this.getGetter(), RefactoringCoreMessages.RenameFieldRefactoring_Update_getter_occurrence, this.getNewGetterName(), status);
    }

    private void addSetterOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        this.addAccessorOccurrences(pm, this.getSetter(), RefactoringCoreMessages.RenameFieldRefactoring_Update_setter_occurrence, this.getNewSetterName(), status);
    }

    private void addAccessorOccurrences(IProgressMonitor pm, IMethod accessor, String editName, String newAccessorName, RefactoringStatus status) throws CoreException {
        Assert.isTrue((boolean)accessor.exists());
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)accessor);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)accessor, (int)3, (int)24);
        SearchResultGroup[] groupedResults = RefactoringSearchEngine.search(pattern, scope, new MethodOccurenceCollector(accessor.getElementName()), pm, status);
        int i = 0;
        while (i < groupedResults.length) {
            ICompilationUnit cu = groupedResults[i].getCompilationUnit();
            if (cu != null) {
                SearchMatch[] results = groupedResults[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch searchResult = results[j];
                    ReplaceEdit edit = new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), newAccessorName);
                    this.addTextEdit(this.fChangeManager.get(cu), editName, (TextEdit)edit);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addTextMatches(IProgressMonitor pm) throws CoreException {
        TextMatchUpdater.perform(pm, this.createRefactoringScope(), this, this.fChangeManager, this.fReferences);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        newWorkingCopies = null;
        newWCOwner = new WorkingCopyOwner(){};
        try {
            block6: {
                block5: {
                    pm.beginTask("", 2);
                    result = new RefactoringStatus();
                    oldReferences = this.fReferences;
                    compilationUnitsToModify = new ArrayList<ICompilationUnit>();
                    if (!this.fIsComposite) break block5;
                    i = 0;
                    if (true) ** GOTO lbl19
                }
                compilationUnitsToModify.addAll(Arrays.asList(this.fChangeManager.getAllCompilationUnits()));
                break block6;
                do {
                    compilationUnitsToModify.add(oldReferences[i].getCompilationUnit());
                    ++i;
lbl19:
                    // 2 sources

                } while (i < oldReferences.length);
                compilationUnitsToModify.add(this.fField.getCompilationUnit());
            }
            newWorkingCopies = RenameAnalyzeUtil.createNewWorkingCopies(compilationUnitsToModify.toArray(new ICompilationUnit[compilationUnitsToModify.size()]), this.fChangeManager, newWCOwner, new SubProgressMonitor(pm, 1));
            newReferences = this.getNewReferences((IProgressMonitor)new SubProgressMonitor(pm, 1), result, newWCOwner, newWorkingCopies);
            result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, oldReferences, newReferences, this.getNewElementName()));
            var9_9 = result;
            return var9_9;
        }
        finally {
            pm.done();
            if (newWorkingCopies == null) return var9_9;
            i = 0;
            ** while (i < newWorkingCopies.length)
        }
lbl-1000:
        // 1 sources

        {
            newWorkingCopies[i].discardWorkingCopy();
            ++i;
            continue;
        }
lbl36:
        // 1 sources

        return var9_9;
    }

    private SearchResultGroup[] getNewReferences(IProgressMonitor pm, RefactoringStatus status, WorkingCopyOwner owner, ICompilationUnit[] newWorkingCopies) throws CoreException {
        pm.beginTask("", 2);
        ICompilationUnit declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(newWorkingCopies, this.fField.getCompilationUnit());
        if (declaringCuWorkingCopy == null) {
            return new SearchResultGroup[0];
        }
        IField field = this.getFieldInWorkingCopy(declaringCuWorkingCopy, this.getNewElementName());
        if (field == null || !field.exists()) {
            return new SearchResultGroup[0];
        }
        CollectingSearchRequestor requestor = null;
        if (this.fDelegateUpdating && RefactoringAvailabilityTester.isDelegateCreationAvailable(this.getField())) {
            final IField oldField = this.getFieldInWorkingCopy(declaringCuWorkingCopy, this.getCurrentElementName());
            requestor = new CollectingSearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!oldField.equals(match.getElement())) {
                        super.acceptSearchMatch(match);
                    }
                }
            };
        } else {
            requestor = new CollectingSearchRequestor();
        }
        SearchPattern newPattern = SearchPattern.createPattern((IJavaElement)field, (int)2);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fField, true, true);
        return RefactoringSearchEngine.search(newPattern, owner, scope, requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
    }

    private IField getFieldInWorkingCopy(ICompilationUnit newWorkingCopyOfDeclaringCu, String elementName) {
        IType type = this.fField.getDeclaringType();
        IType typeWc = (IType)JavaModelUtil.findInCompilationUnit(newWorkingCopyOfDeclaringCu, (IJavaElement)type);
        if (typeWc == null) {
            return null;
        }
        return typeWc.getField(elementName);
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 8) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.field");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fField = (IField)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.valueOf(matches);
        String getters = extended.getAttribute(ATTRIBUTE_RENAME_GETTER);
        this.fRenameGetter = getters != null ? Boolean.valueOf(getters) : false;
        String setters = extended.getAttribute(ATTRIBUTE_RENAME_SETTER);
        this.fRenameSetter = setters != null ? Boolean.valueOf(setters) : false;
        String delegate = extended.getAttribute(ATTRIBUTE_DELEGATE);
        this.fDelegateUpdating = delegate != null ? Boolean.valueOf(delegate) : false;
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        this.fDelegateDeprecation = deprecate != null ? Boolean.valueOf(deprecate) : false;
        return new RefactoringStatus();
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateFieldCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateFieldCreator_keep_original_renamed_singular;
    }
}

