/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractConstantDescriptor;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractConstantRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_QUALIFY = "qualify";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String MODIFIER = "static final";
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private CompilationUnitRewrite fCuRewrite;
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private IExpressionFragment fSelectedExpression;
    private Type fConstantTypeCache;
    private boolean fReplaceAllOccurrences = true;
    private boolean fQualifyReferencesWithDeclaringClassName = false;
    private String fVisibility = "private";
    private boolean fTargetIsInterface = false;
    private String fConstantName;
    private String[] fExcludedVariableNames;
    private boolean fSelectionAllStaticFinal;
    private boolean fAllStaticFinalCheckPerformed = false;
    private List fBodyDeclarations;
    private BodyDeclaration fToInsertAfter;
    private boolean fInsertFirst;
    private CompilationUnitChange fChange;
    private String[] fGuessedConstNames;
    private LinkedProposalModel fLinkedProposalModel;
    private boolean fCheckResultForCompileProblems;
    static /* synthetic */ Class class$0;

    public ExtractConstantRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fCuRewrite = null;
        this.fLinkedProposalModel = null;
        this.fConstantName = "";
        this.fCheckResultForCompileProblems = true;
    }

    public ExtractConstantRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(astRoot.getTypeRoot() instanceof ICompilationUnit));
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = (ICompilationUnit)astRoot.getTypeRoot();
        this.fCuRewrite = new CompilationUnitRewrite(this.fCu, astRoot);
        this.fLinkedProposalModel = null;
        this.fConstantName = "";
        this.fCheckResultForCompileProblems = true;
    }

    public ExtractConstantRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public void setCheckResultForCompileProblems(boolean checkResultForCompileProblems) {
        this.fCheckResultForCompileProblems = checkResultForCompileProblems;
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractConstantRefactoring_name;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setVisibility(String am) {
        Assert.isTrue((am == "private" || am == "protected" || am == "" || am == "public" ? 1 : 0) != 0);
        this.fVisibility = am;
    }

    public String getVisibility() {
        return this.fVisibility;
    }

    public boolean getTargetIsInterface() {
        return this.fTargetIsInterface;
    }

    public boolean qualifyReferencesWithDeclaringClassName() {
        return this.fQualifyReferencesWithDeclaringClassName;
    }

    public void setQualifyReferencesWithDeclaringClassName(boolean qualify) {
        this.fQualifyReferencesWithDeclaringClassName = qualify;
    }

    public String guessConstantName() {
        String[] proposals = this.guessConstantNames();
        if (proposals.length > 0) {
            return proposals[0];
        }
        return this.fConstantName;
    }

    public String[] guessConstantNames() {
        if (this.fGuessedConstNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding binding = expression.resolveTypeBinding();
                    this.fGuessedConstNames = StubUtility.getVariableNameSuggestions(3, this.fCu.getJavaProject(), binding, expression, Arrays.asList(this.getExcludedVariableNames()));
                }
            }
            catch (JavaModelException javaModelException) {}
            if (this.fGuessedConstNames == null) {
                this.fGuessedConstNames = new String[0];
            }
        }
        return this.fGuessedConstNames;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IExpressionFragment expr = this.getSelectedExpression();
                Collection takenNames = new ScopeAnalyzer(this.fCuRewrite.getRoot()).getUsedVariableNames(expr.getStartPosition(), expr.getLength());
                this.fExcludedVariableNames = takenNames.toArray(new String[takenNames.size()]);
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            ITypeBinding targetType;
            pm.beginTask("", 7);
            RefactoringStatus result = Checks.validateEdit(this.fCu, this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.fCuRewrite == null) {
                CompilationUnit cuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
                this.fCuRewrite = new CompilationUnitRewrite(this.fCu, cuNode);
            } else {
                pm.worked(3);
            }
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            if ((targetType = this.getContainingTypeBinding()).isAnnotation() || targetType.isInterface()) {
                this.fTargetIsInterface = true;
                this.fVisibility = "public";
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean selectionAllStaticFinal() {
        Assert.isTrue((boolean)this.fAllStaticFinalCheckPerformed);
        return this.fSelectionAllStaticFinal;
    }

    private void checkAllStaticFinal() throws JavaModelException {
        this.fSelectionAllStaticFinal = ConstantChecks.isStaticFinalConstant(this.getSelectedExpression());
        this.fAllStaticFinalCheckPerformed = true;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask("", 2);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractConstantRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCuRewrite.getRoot(), message);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkExpressionBinding() throws JavaModelException {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractConstantRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkExpressionBinding());
        if (result.hasFatalError()) {
            return result;
        }
        this.checkAllStaticFinal();
        IExpressionFragment selectedExpression = this.getSelectedExpression();
        Expression associatedExpression = selectedExpression.getAssociatedExpression();
        if (associatedExpression instanceof NullLiteral) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_null_literals));
        } else if (!ConstantChecks.isLoadTimeConstant(selectedExpression)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_not_load_time_constant));
        } else if (associatedExpression instanceof SimpleName && (associatedExpression.getParent() instanceof QualifiedName && associatedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || associatedExpression.getParent() instanceof FieldAccess && associatedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression);
        }
        return result;
    }

    public void setConstantName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fConstantName = newName;
    }

    public String getConstantName() {
        return this.fConstantName;
    }

    public RefactoringStatus checkConstantNameOnChange() throws JavaModelException {
        if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fConstantName)) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_another_variable, this.getConstantName()));
        }
        return Checks.checkConstantName(this.fConstantName, (IJavaElement)this.fCu);
    }

    public String getConstantSignaturePreview() throws JavaModelException {
        String space = " ";
        return String.valueOf(this.getVisibility()) + space + MODIFIER + space + this.getConstantTypeName() + space + this.fConstantName;
    }

    public CompilationUnitChange createTextChange(IProgressMonitor pm) throws CoreException {
        this.createConstantDeclaration();
        this.replaceExpressionsWithConstant();
        return this.fCuRewrite.createChange(RefactoringCoreMessages.ExtractConstantRefactoring_change_name, true, pm);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ExtractConstantRefactoring_checking_preconditions, 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.createConstantDeclaration();
            this.replaceExpressionsWithConstant();
            this.fChange = this.fCuRewrite.createChange(RefactoringCoreMessages.ExtractConstantRefactoring_change_name, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.fCheckResultForCompileProblems) {
                this.checkSource(new SubProgressMonitor(pm, 1), result);
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            this.fConstantTypeCache = null;
            this.fCuRewrite.clearASTAndImportRewrites();
            pm.done();
        }
    }

    private void checkSource(SubProgressMonitor monitor, RefactoringStatus result) throws CoreException {
        String newCuSource = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit newCUNode = new RefactoringASTParser(3).parse(newCuSource, this.fCu, true, true, (IProgressMonitor)monitor);
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCuRewrite.getRoot());
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, new SourceRange(problem))));
            }
            ++i;
        }
    }

    private void createConstantDeclaration() throws CoreException {
        String comment;
        Type type = this.getConstantType();
        IExpressionFragment fragment = this.getSelectedExpression();
        String initializerSource = this.fCu.getBuffer().getText(fragment.getStartPosition(), fragment.getLength());
        AST ast = this.fCuRewrite.getAST();
        VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(ast.newSimpleName(this.fConstantName));
        variableDeclarationFragment.setInitializer((Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(initializerSource, 42));
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType(type);
        Modifier.ModifierKeyword accessModifier = Modifier.ModifierKeyword.toKeyword((String)this.fVisibility);
        if (accessModifier != null) {
            fieldDeclaration.modifiers().add(ast.newModifier(accessModifier));
        }
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        boolean createComments = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fCu.getJavaProject()).createComments;
        if (createComments && (comment = CodeGeneration.getFieldComment(this.fCu, this.getConstantTypeName(), this.fConstantName, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu))) != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)this.fCuRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            fieldDeclaration.setJavadoc(doc);
        }
        AbstractTypeDeclaration parent = this.getContainingTypeDeclarationNode();
        ListRewrite listRewrite = this.fCuRewrite.getASTRewrite().getListRewrite((ASTNode)parent, parent.getBodyDeclarationsProperty());
        TextEditGroup msg = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractConstantRefactoring_declare_constant);
        if (this.insertFirst()) {
            listRewrite.insertFirst((ASTNode)fieldDeclaration, msg);
        } else {
            listRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)this.getNodeToInsertConstantDeclarationAfter(), msg);
        }
        if (this.fLinkedProposalModel != null) {
            ASTRewrite rewrite = this.fCuRewrite.getASTRewrite();
            LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            nameGroup.addPosition(rewrite.track((ASTNode)variableDeclarationFragment.getName()), true);
            String[] nameSuggestions = this.guessConstantNames();
            if (nameSuggestions.length > 0 && !nameSuggestions[0].equals(this.fConstantName)) {
                nameGroup.addProposal(this.fConstantName, null, nameSuggestions.length + 1);
            }
            int i = 0;
            while (i < nameSuggestions.length) {
                nameGroup.addProposal(nameSuggestions[i], null, nameSuggestions.length - i);
                ++i;
            }
            LinkedProposalPositionGroup typeGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
            typeGroup.addPosition(rewrite.track((ASTNode)type), true);
            ITypeBinding typeBinding = fragment.getAssociatedExpression().resolveTypeBinding();
            if (typeBinding != null) {
                ITypeBinding[] relaxingTypes = ASTResolving.getNarrowingTypes(ast, typeBinding);
                int i2 = 0;
                while (i2 < relaxingTypes.length) {
                    typeGroup.addProposal(relaxingTypes[i2], this.fCuRewrite.getCu(), relaxingTypes.length - i2);
                    ++i2;
                }
            }
            boolean isInterface = parent.resolveBinding() != null && parent.resolveBinding().isInterface();
            ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.fLinkedProposalModel, rewrite, fieldDeclaration.modifiers(), isInterface);
        }
    }

    private Type getConstantType() throws JavaModelException {
        if (this.fConstantTypeCache == null) {
            IExpressionFragment fragment = this.getSelectedExpression();
            ITypeBinding typeBinding = fragment.getAssociatedExpression().resolveTypeBinding();
            AST ast = this.fCuRewrite.getAST();
            typeBinding = Bindings.normalizeForDeclarationUse(typeBinding, ast);
            this.fConstantTypeCache = this.fCuRewrite.getImportRewrite().addImport(typeBinding, ast);
        }
        return this.fConstantTypeCache;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        ExtractConstantDescriptor descriptor = this.createRefactoringDescriptor();
        this.fChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
        return this.fChange;
    }

    private ExtractConstantDescriptor createRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 786432;
        if (JdtFlags.getVisibilityCode(this.fVisibility) != 2) {
            flags |= 2;
        }
        String pattern = "";
        try {
            pattern = String.valueOf(BindingLabelProvider.getBindingLabel((IBinding)this.getContainingTypeBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)) + ".";
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String expression = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String description = Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description_short, this.fConstantName);
        String header = Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description, new String[]{String.valueOf(pattern) + this.fConstantName, expression});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_constant_name_pattern, this.fConstantName));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_constant_expression_pattern, expression));
        String visibility = this.fVisibility;
        if ("".equals(visibility)) {
            visibility = RefactoringCoreMessages.ExtractConstantRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_visibility_pattern, visibility));
        if (this.fReplaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_replace_occurrences);
        }
        if (this.fQualifyReferencesWithDeclaringClassName) {
            comment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_qualify_references);
        }
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
        arguments.put(KEY_NAME, this.fConstantName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        arguments.put(ATTRIBUTE_QUALIFY, Boolean.valueOf(this.fQualifyReferencesWithDeclaringClassName).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(JdtFlags.getVisibilityCode(this.fVisibility)).toString());
        ExtractConstantDescriptor descriptor = new ExtractConstantDescriptor(project, description, comment.asString(), arguments, flags);
        return descriptor;
    }

    private void replaceExpressionsWithConstant() throws JavaModelException {
        ASTRewrite astRewrite = this.fCuRewrite.getASTRewrite();
        AST ast = astRewrite.getAST();
        IASTFragment[] fragmentsToReplace = this.getFragmentsToReplace();
        int i = 0;
        while (i < fragmentsToReplace.length) {
            SimpleName ref;
            IASTFragment fragment = fragmentsToReplace[i];
            SimpleName replacement = ref = ast.newSimpleName(this.fConstantName);
            if (this.qualifyReferencesWithDeclaringClassName()) {
                replacement = ast.newQualifiedName((Name)ast.newSimpleName(this.getContainingTypeBinding().getName()), ref);
            }
            TextEditGroup description = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractConstantRefactoring_replace);
            fragment.replace(astRewrite, (ASTNode)replacement, description);
            if (this.fLinkedProposalModel != null) {
                this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(astRewrite.track((ASTNode)ref), false);
            }
            ++i;
        }
    }

    private void computeConstantDeclarationLocation() throws JavaModelException {
        if (this.isDeclarationLocationComputed()) {
            return;
        }
        BodyDeclaration lastStaticDependency = null;
        Iterator decls = this.getBodyDeclarations();
        Assert.isTrue((boolean)decls.hasNext());
        while (decls.hasNext()) {
            int modifiers;
            BodyDeclaration decl = (BodyDeclaration)decls.next();
            if (decl instanceof FieldDeclaration) {
                modifiers = ((FieldDeclaration)decl).getModifiers();
            } else {
                if (!(decl instanceof Initializer)) continue;
                modifiers = ((Initializer)decl).getModifiers();
            }
            if (!Modifier.isStatic((int)modifiers) || !ExtractConstantRefactoring.depends(this.getSelectedExpression(), decl)) continue;
            lastStaticDependency = decl;
        }
        if (lastStaticDependency == null) {
            this.fInsertFirst = true;
        } else {
            this.fToInsertAfter = lastStaticDependency;
        }
    }

    private static boolean depends(IExpressionFragment selected, BodyDeclaration bd) {
        if (bd instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)bd;
            Iterator fragments = fieldDecl.fragments().iterator();
            while (fragments.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.next();
                SimpleName staticFieldName = fragment.getName();
                if (selected.getSubFragmentsMatching(ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)staticFieldName)).length == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeclarationLocationComputed() {
        return this.fInsertFirst || this.fToInsertAfter != null;
    }

    private boolean insertFirst() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fInsertFirst;
    }

    private BodyDeclaration getNodeToInsertConstantDeclarationAfter() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fToInsertAfter;
    }

    private Iterator getBodyDeclarations() throws JavaModelException {
        if (this.fBodyDeclarations == null) {
            this.fBodyDeclarations = this.getContainingTypeDeclarationNode().bodyDeclarations();
        }
        return this.fBodyDeclarations.iterator();
    }

    private String getConstantTypeName() throws JavaModelException {
        return ASTNodes.asString((ASTNode)this.getConstantType());
    }

    private static boolean isStaticFieldOrStaticInitializer(BodyDeclaration node) {
        int modifiers;
        if (node instanceof MethodDeclaration || node instanceof AbstractTypeDeclaration) {
            return false;
        }
        if (node instanceof FieldDeclaration) {
            modifiers = ((FieldDeclaration)node).getModifiers();
        } else if (node instanceof Initializer) {
            modifiers = ((Initializer)node).getModifiers();
        } else {
            Assert.isTrue((boolean)false);
            return false;
        }
        return Modifier.isStatic((int)modifiers);
    }

    private Iterator getReplacementScope() throws JavaModelException {
        boolean declPredecessorReached = false;
        ArrayList<BodyDeclaration> scope = new ArrayList<BodyDeclaration>();
        Iterator bodyDeclarations = this.getBodyDeclarations();
        while (bodyDeclarations.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.next();
            if (bodyDeclaration == this.getNodeToInsertConstantDeclarationAfter()) {
                declPredecessorReached = true;
            }
            if (!this.insertFirst() && !declPredecessorReached && ExtractConstantRefactoring.isStaticFieldOrStaticInitializer(bodyDeclaration)) continue;
            scope.add(bodyDeclaration);
        }
        return scope.iterator();
    }

    private IASTFragment[] getFragmentsToReplace() throws JavaModelException {
        ArrayList<IASTFragment> toReplace = new ArrayList<IASTFragment>();
        if (this.fReplaceAllOccurrences) {
            Iterator replacementScope = this.getReplacementScope();
            while (replacementScope.hasNext()) {
                BodyDeclaration bodyDecl = (BodyDeclaration)replacementScope.next();
                IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)bodyDecl).getSubFragmentsMatching(this.getSelectedExpression());
                IASTFragment[] replaceableMatches = ExtractConstantRefactoring.retainOnlyReplacableMatches(allMatches);
                int i = 0;
                while (i < replaceableMatches.length) {
                    toReplace.add(replaceableMatches[i]);
                    ++i;
                }
            }
        } else if (ExtractConstantRefactoring.canReplace(this.getSelectedExpression())) {
            toReplace.add(this.getSelectedExpression());
        }
        return toReplace.toArray(new IASTFragment[toReplace.size()]);
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractConstantRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCuRewrite.getRoot(), this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private AbstractTypeDeclaration getContainingTypeDeclarationNode() throws JavaModelException {
        ASTNode aSTNode = this.getSelectedExpression().getAssociatedNode();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration result = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
        Assert.isNotNull((Object)result);
        return result;
    }

    private ITypeBinding getContainingTypeBinding() throws JavaModelException {
        ITypeBinding result = this.getContainingTypeDeclarationNode().resolveBinding();
        Assert.isNotNull((Object)result);
        return result;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String name;
        IJavaElement element;
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.extract.constant");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && !"".equals(visibility)) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = JdtFlags.getVisibilityString(flag);
        }
        if ((name = arguments.getAttribute(KEY_NAME)) == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
        }
        this.fConstantName = name;
        String replace = arguments.getAttribute(ATTRIBUTE_REPLACE);
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
        }
        this.fReplaceAllOccurrences = Boolean.valueOf(replace);
        String declareFinal = arguments.getAttribute(ATTRIBUTE_QUALIFY);
        if (declareFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFY));
        }
        this.fQualifyReferencesWithDeclaringClassName = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }
}

