/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;

public final class RenameJavaProjectChange
extends AbstractJavaElementRenameChange {
    private boolean fUpdateReferences;

    public RenameJavaProjectChange(IJavaProject project, String newName, boolean updateReferences) {
        this(project.getPath(), project.getElementName(), newName, -1L, updateReferences);
        Assert.isTrue((!project.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
    }

    private RenameJavaProjectChange(IPath resourcePath, String oldName, String newName, long stampToRestore, boolean updateReferences) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.fUpdateReferences = updateReferences;
        this.setValidationMethod(2);
    }

    private IClasspathEntry createModifiedEntry(IClasspathEntry oldEntry) {
        return JavaCore.newProjectEntry((IPath)this.createNewPath(), (IAccessRule[])oldEntry.getAccessRules(), (boolean)oldEntry.combineAccessRules(), (IClasspathAttribute[])oldEntry.getExtraAttributes(), (boolean)oldEntry.isExported());
    }

    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long stampToRestore) throws JavaModelException {
        return new RenameJavaProjectChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore, this.fUpdateReferences);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        try {
            IProject project;
            pm.beginTask(this.getName(), 2);
            if (this.fUpdateReferences) {
                this.modifyClassPaths((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            if ((project = this.getProject()) != null) {
                IProjectDescription description = project.getDescription();
                description.setName(this.getNewName());
                project.move(description, 33, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)this.getModifiedElement();
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_rename, new String[]{this.getOldName(), this.getNewName()});
    }

    private IProject getProject() {
        IJavaProject jp = this.getJavaProject();
        if (jp == null) {
            return null;
        }
        return jp.getProject();
    }

    private boolean isOurEntry(IClasspathEntry cpe) {
        if (cpe.getEntryKind() != 2) {
            return false;
        }
        return cpe.getPath().equals((Object)this.getResourcePath());
    }

    private void modifyClassPath(IJavaProject referencingProject, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        IClasspathEntry[] oldEntries = referencingProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length];
        int i = 0;
        while (i < newEntries.length) {
            newEntries[i] = this.isOurEntry(oldEntries[i]) ? this.createModifiedEntry(oldEntries[i]) : oldEntries[i];
            ++i;
        }
        referencingProject.setRawClasspath(newEntries, pm);
        pm.done();
    }

    private void modifyClassPaths(IProgressMonitor pm) throws JavaModelException {
        IProject[] referencing = this.getProject().getReferencingProjects();
        pm.beginTask(RefactoringCoreMessages.RenameJavaProjectChange_update, referencing.length);
        int i = 0;
        while (i < referencing.length) {
            IJavaProject jp = JavaCore.create((IProject)referencing[i]);
            if (jp != null && jp.exists()) {
                this.modifyClassPath(jp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else {
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
    }
}

