/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.ElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.FilterTransform;
import org.eclipse.debug.internal.ui.viewers.model.IMementoManager;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

abstract class ModelContentProvider
implements IContentProvider,
IModelChangedListener {
    private Viewer fViewer;
    private Map fModelProxies = new HashMap();
    private FilterTransform fTransform = new FilterTransform();
    private ListenerList fModelListeners = new ListenerList();
    private ListenerList fUpdateListeners = new ListenerList();
    private Map fRequestsInProgress = new HashMap();
    private Map fWaitingRequests = new HashMap();
    private Map fViewerStates = new LRUMap(20);
    private ModelDelta fPendingState = null;
    private Map fCompareRequestsInProgress = new HashMap();
    private Set fPendingStateSaves = new HashSet();
    private Object fQueuedRestore = null;
    static final int UPDATE_SEQUENCE_BEGINS = 0;
    static final int UPDATE_SEQUENCE_COMPLETE = 1;
    static final int UPDATE_BEGINS = 2;
    static final int UPDATE_COMPLETE = 3;
    protected static final TreePath EMPTY_TREE_PATH = new TreePath(new Object[0]);
    public static boolean DEBUG_CONTENT_PROVIDER = false;
    public static boolean DEBUG_UPDATE_SEQUENCE = false;
    public static boolean DEBUG_STATE_SAVE_RESTORE = false;

    static {
        DEBUG_CONTENT_PROVIDER = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/contentProvider"));
        DEBUG_UPDATE_SEQUENCE = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/updateSequence"));
        DEBUG_STATE_SAVE_RESTORE = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/stateSaveRestore"));
    }

    ModelContentProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            Iterator iterator = this.fRequestsInProgress.values().iterator();
            while (iterator.hasNext()) {
                List requests = (List)iterator.next();
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ((IRequest)reqIter.next()).cancel();
                }
            }
            this.fWaitingRequests.clear();
        }
        this.fModelListeners.clear();
        this.fUpdateListeners.clear();
        this.disposeAllModelProxies();
        this.fViewer = null;
    }

    public synchronized boolean isDisposed() {
        return this.fViewer == null;
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
        if (oldInput != null) {
            Iterator itr = this.fCompareRequestsInProgress.values().iterator();
            while (itr.hasNext()) {
                ((ElementCompareRequest)itr.next()).cancel();
                itr.remove();
            }
            this.saveViewerState(oldInput);
        }
        if (newInput != oldInput) {
            this.cancelSubtreeUpdates(TreePath.EMPTY);
            this.disposeAllModelProxies();
            this.cancelSubtreeUpdates(TreePath.EMPTY);
            this.fTransform.clear();
            if (newInput != null) {
                this.installModelProxy(newInput);
                this.restoreViewerState(newInput);
            }
        }
    }

    protected synchronized void restoreViewerState(Object input) {
        this.fPendingState = null;
        if (this.isSavingState()) {
            this.fQueuedRestore = input;
        } else {
            this.startRestoreViewerState(input);
        }
    }

    private synchronized void startRestoreViewerState(final Object input) {
        this.fPendingState = null;
        final IElementMementoProvider defaultProvider = ViewerAdapterService.getMementoProvider(input);
        if (defaultProvider != null) {
            final ModelDelta delta = new ModelDelta(input, 0);
            XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
            IMementoManager manager = new IMementoManager(){
                private IElementMementoRequest fRequest;

                public synchronized void requestComplete(IElementMementoRequest request) {
                    if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                        XMLMemento keyMemento = (XMLMemento)delta.getElement();
                        StringWriter writer = new StringWriter();
                        try {
                            keyMemento.save((Writer)writer);
                            String keyMementoString = writer.toString();
                            ModelDelta stateDelta = (ModelDelta)ModelContentProvider.this.fViewerStates.get(keyMementoString);
                            if (stateDelta != null) {
                                stateDelta.setElement(input);
                                UIJob job = new UIJob(this, "restore state", input, stateDelta, keyMementoString){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ Object val$input;
                                    private final /* synthetic */ ModelDelta val$stateDelta;
                                    private final /* synthetic */ String val$keyMementoString;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$input = object;
                                        this.val$stateDelta = modelDelta;
                                        this.val$keyMementoString = string;
                                    }

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (!1.access$0(this.this$1).isDisposed() && this.val$input.equals(1.access$0(this.this$1).getViewer().getInput())) {
                                            if (DEBUG_STATE_SAVE_RESTORE) {
                                                System.out.println("RESTORE: " + this.val$stateDelta.toString());
                                            }
                                            ModelContentProvider.access$0(1.access$0(this.this$1)).remove(this.val$keyMementoString);
                                            ModelContentProvider.access$1(1.access$0(this.this$1), this.val$stateDelta);
                                            1.access$0(this.this$1).doInitialRestore(ModelContentProvider.access$2(1.access$0(this.this$1)));
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setSystem(true);
                                job.schedule();
                            }
                        }
                        catch (IOException e) {
                            DebugUIPlugin.log(e);
                        }
                    }
                }

                public void processReqeusts() {
                    defaultProvider.encodeElements(new IElementMementoRequest[]{this.fRequest});
                }

                public synchronized void addRequest(IElementMementoRequest req) {
                    this.fRequest = req;
                }

                static /* synthetic */ ModelContentProvider access$0(1 var0) {
                    return var0.ModelContentProvider.this;
                }
            };
            manager.addRequest(new ElementMementoRequest(this, this.getViewer().getInput(), manager, this.getPresentationContext(), delta.getElement(), this.getViewerTreePath(delta), (IMemento)inputMemento, delta));
            manager.processReqeusts();
        }
    }

    protected abstract void doInitialRestore(ModelDelta var1);

    abstract void doRestore(ModelDelta var1, boolean var2, boolean var3);

    protected synchronized void doRestore(final TreePath path, final int modelIndex, final boolean knowsHasChildren, final boolean knowsChildCount) {
        if (this.fPendingState == null) {
            return;
        }
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                Object potentialMatch;
                Object element = delta.getElement();
                Object object = potentialMatch = depth != 0 ? path.getSegment(depth - 1) : ModelContentProvider.this.getViewer().getInput();
                if (depth == path.getSegmentCount()) {
                    if (element instanceof IMemento) {
                        IElementMementoProvider provider = ViewerAdapterService.getMementoProvider(potentialMatch);
                        if (provider == null) {
                            provider = ViewerAdapterService.getMementoProvider(ModelContentProvider.this.getViewer().getInput());
                        }
                        if (provider != null) {
                            CompareRequestKey key = new CompareRequestKey(path, delta);
                            ElementCompareRequest existingRequest = (ElementCompareRequest)ModelContentProvider.this.fCompareRequestsInProgress.get(key);
                            if (existingRequest != null) {
                                existingRequest.setKnowsHasChildren(knowsHasChildren);
                                existingRequest.setKnowsChildCount(knowsChildCount);
                            } else {
                                ElementCompareRequest compareRequest = new ElementCompareRequest(ModelContentProvider.this, ModelContentProvider.this.getViewer().getInput(), potentialMatch, path, (IMemento)element, (ModelDelta)delta, modelIndex, knowsHasChildren, knowsChildCount);
                                ModelContentProvider.this.fCompareRequestsInProgress.put(key, compareRequest);
                                provider.compareElements(new IElementCompareRequest[]{compareRequest});
                            }
                        }
                    } else if (element.equals(potentialMatch)) {
                        ModelContentProvider.this.doRestore((ModelDelta)delta, knowsHasChildren, knowsChildCount);
                    }
                    return false;
                }
                return element.equals(potentialMatch);
            }
        };
        this.fPendingState.accept(visitor);
    }

    void compareFinished(ElementCompareRequest request, ModelDelta delta) {
        this.fCompareRequestsInProgress.remove(request);
        if (!request.isCanceled()) {
            if (request.isEqual()) {
                delta.setElement(request.getElement());
                this.doRestore(delta, request.knowsHasChildren(), request.knowChildCount());
            } else if (request.getModelIndex() != -1 && (delta.getFlags() & 0x1000000) != 0 && delta.getIndex() == request.getModelIndex()) {
                delta.setFlags(delta.getFlags() & 0xFEFFFFFF);
            }
        }
    }

    protected void saveViewerState(Object input) {
        IElementMementoProvider stateProvider = ViewerAdapterService.getMementoProvider(input);
        if (stateProvider != null) {
            if (DEBUG_STATE_SAVE_RESTORE) {
                System.out.println("SAVE BEGIN: " + input);
            }
            final ModelDelta saveDeltaRoot = new ModelDelta(input, 0);
            this.buildViewerState(saveDeltaRoot);
            if (DEBUG_STATE_SAVE_RESTORE) {
                System.out.println("SAVE DELTA FROM VIEW: " + saveDeltaRoot);
            }
            if (this.fPendingState != null) {
                if (DEBUG_STATE_SAVE_RESTORE) {
                    System.out.println("SAVE OUTSTANDING RESTORE: " + this.fPendingState);
                }
                IModelDeltaVisitor pendingStateVisitor = new IModelDeltaVisitor(){

                    public boolean visit(IModelDelta pendingDeltaNode, int depth) {
                        if (pendingDeltaNode.getParentDelta() == null) {
                            return true;
                        }
                        ModelDelta saveDeltaNode = ModelContentProvider.this.findSaveDelta(saveDeltaRoot, pendingDeltaNode);
                        if (saveDeltaNode != null && !ModelContentProvider.this.isDeltaInParent(pendingDeltaNode, saveDeltaNode) && pendingDeltaNode.getFlags() != 0) {
                            if ((pendingDeltaNode.getFlags() & 0x1000000) != 0) {
                                ModelContentProvider.this.clearRevealFlag(saveDeltaRoot);
                            }
                            saveDeltaNode.setChildCount(pendingDeltaNode.getParentDelta().getChildCount());
                            ModelContentProvider.this.copyIntoDelta(pendingDeltaNode, saveDeltaNode);
                        } else if (DEBUG_STATE_SAVE_RESTORE) {
                            System.out.println(" Skipping: " + pendingDeltaNode.getElement());
                        }
                        if (pendingDeltaNode.getElement() instanceof IMemento) {
                            return false;
                        }
                        return pendingDeltaNode.getChildCount() > 0;
                    }
                };
                this.fPendingState.accept(pendingStateVisitor);
            }
            if (saveDeltaRoot.getChildDeltas().length > 0) {
                this.encodeDelta(saveDeltaRoot, stateProvider);
            } else if (DEBUG_STATE_SAVE_RESTORE) {
                System.out.println("SAVE CANCELED, NO DATA");
            }
        }
    }

    private void clearRevealFlag(ModelDelta saveRootDelta) {
        IModelDeltaVisitor clearDeltaVisitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0x1000000) != 0) {
                    ((ModelDelta)delta).setFlags(delta.getFlags() & 0xFEFFFFFF);
                }
                return true;
            }
        };
        saveRootDelta.accept(clearDeltaVisitor);
    }

    private ModelDelta findSaveDelta(ModelDelta saveDeltaRoot, IModelDelta pendingStateDelta) {
        LinkedList<IModelDelta> deltaPath = new LinkedList<IModelDelta>();
        IModelDelta delta = pendingStateDelta;
        while (delta.getParentDelta() != null) {
            delta = delta.getParentDelta();
            deltaPath.addFirst(delta);
        }
        Iterator itr = deltaPath.iterator();
        itr.next();
        ModelDelta saveDelta = saveDeltaRoot;
        block1: while (itr.hasNext()) {
            IModelDelta itrDelta = (IModelDelta)itr.next();
            int i = 0;
            while (i < saveDelta.getChildDeltas().length) {
                if (this.deltasEqual(saveDelta.getChildDeltas()[i], itrDelta)) {
                    saveDelta = (ModelDelta)saveDelta.getChildDeltas()[i];
                    continue block1;
                }
                ++i;
            }
            return null;
        }
        return saveDelta;
    }

    private boolean deltasEqual(IModelDelta d1, IModelDelta d2) {
        return d1.getElement().equals(d2.getElement()) && d1.getIndex() == d2.getIndex();
    }

    private boolean isDeltaInParent(IModelDelta delta, ModelDelta destParent) {
        int i = 0;
        while (i < destParent.getChildDeltas().length) {
            if (this.deltasEqual(destParent.getChildDeltas()[i], delta)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void copyIntoDelta(IModelDelta delta, ModelDelta destParent) {
        ModelDelta newDelta = destParent.addNode(delta.getElement(), delta.getIndex(), delta.getFlags(), delta.getChildCount());
        int i = 0;
        while (i < delta.getChildDeltas().length) {
            this.copyIntoDelta(delta.getChildDeltas()[i], newDelta);
            ++i;
        }
    }

    protected void encodeDelta(final ModelDelta rootDelta, final IElementMementoProvider defaultProvider) {
        final XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
        final XMLMemento childrenMemento = XMLMemento.createWriteRoot((String)"CHILDREN_MEMENTO");
        final IMementoManager manager = new IMementoManager(){
            private List requests = new ArrayList();
            private boolean abort = false;

            public synchronized void requestComplete(IElementMementoRequest request) {
                if (!this.abort) {
                    if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                        this.requests.remove(request);
                        if (this.requests.isEmpty()) {
                            XMLMemento keyMemento = (XMLMemento)rootDelta.getElement();
                            StringWriter writer = new StringWriter();
                            try {
                                keyMemento.save((Writer)writer);
                                ModelContentProvider.this.fViewerStates.put(writer.toString(), rootDelta);
                            }
                            catch (IOException e) {
                                DebugUIPlugin.log(e);
                            }
                            if (DEBUG_STATE_SAVE_RESTORE) {
                                System.out.println("SAVE COMPLETED: " + rootDelta);
                            }
                            ModelContentProvider.this.stateSaveComplete(this);
                        }
                    } else {
                        this.abort = true;
                        Iterator iterator = this.requests.iterator();
                        while (iterator.hasNext()) {
                            IElementMementoRequest req = (IElementMementoRequest)iterator.next();
                            req.cancel();
                        }
                        this.requests.clear();
                        if (DEBUG_STATE_SAVE_RESTORE) {
                            System.out.println("SAVE ABORTED: " + rootDelta.getElement());
                        }
                        ModelContentProvider.this.stateSaveComplete(this);
                    }
                }
            }

            public synchronized void processReqeusts() {
                ArrayList<IElementMementoRequest> reqs;
                IElementMementoProvider provider;
                HashMap<IElementMementoProvider, ArrayList<IElementMementoRequest>> providers = new HashMap<IElementMementoProvider, ArrayList<IElementMementoRequest>>();
                Iterator<Object> iterator = this.requests.iterator();
                while (iterator.hasNext()) {
                    IElementMementoRequest request = (IElementMementoRequest)iterator.next();
                    provider = ViewerAdapterService.getMementoProvider(request.getElement());
                    if (provider == null) {
                        provider = defaultProvider;
                    }
                    if ((reqs = (ArrayList<IElementMementoRequest>)providers.get(provider)) == null) {
                        reqs = new ArrayList<IElementMementoRequest>();
                        providers.put(provider, reqs);
                    }
                    reqs.add(request);
                }
                iterator = providers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    provider = (IElementMementoProvider)entry.getKey();
                    reqs = (List)entry.getValue();
                    provider.encodeElements(reqs.toArray(new IElementMementoRequest[reqs.size()]));
                }
            }

            public synchronized void addRequest(IElementMementoRequest request) {
                this.requests.add(request);
            }
        };
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if (delta.getParentDelta() == null) {
                    manager.addRequest(new ElementMementoRequest(ModelContentProvider.this, ModelContentProvider.this.getViewer().getInput(), manager, ModelContentProvider.this.getPresentationContext(), delta.getElement(), ModelContentProvider.this.getViewerTreePath(delta), (IMemento)inputMemento, (ModelDelta)delta));
                } else if (!(delta.getElement() instanceof XMLMemento)) {
                    manager.addRequest(new ElementMementoRequest(ModelContentProvider.this, ModelContentProvider.this.getViewer().getInput(), manager, ModelContentProvider.this.getPresentationContext(), delta.getElement(), ModelContentProvider.this.getViewerTreePath(delta), childrenMemento.createChild("CHILD_ELEMENT"), (ModelDelta)delta));
                }
                return true;
            }
        };
        rootDelta.accept(visitor);
        this.stateSaveStarted(manager);
        manager.processReqeusts();
    }

    private synchronized void stateSaveStarted(IMementoManager manager) {
        this.fPendingStateSaves.add(manager);
    }

    private synchronized void stateSaveComplete(IMementoManager manager) {
        this.fPendingStateSaves.remove(manager);
        if (this.fQueuedRestore != null) {
            Object temp = this.fQueuedRestore;
            this.fQueuedRestore = null;
            this.restoreViewerState(temp);
        }
    }

    private synchronized boolean isSavingState() {
        return !this.fPendingStateSaves.isEmpty();
    }

    protected abstract void buildViewerState(ModelDelta var1);

    protected synchronized void disposeModelProxy(Object element) {
        IModelProxy proxy = (IModelProxy)this.fModelProxies.remove(element);
        if (proxy != null) {
            proxy.dispose();
        }
    }

    protected synchronized void disposeAllModelProxies() {
        Iterator updatePolicies = this.fModelProxies.values().iterator();
        while (updatePolicies.hasNext()) {
            IModelProxy proxy = (IModelProxy)updatePolicies.next();
            proxy.dispose();
        }
        this.fModelProxies.clear();
    }

    protected synchronized void installModelProxy(Object element) {
        IModelProxy proxy;
        IModelProxyFactory modelProxyFactory;
        if (!this.fModelProxies.containsKey(element) && (modelProxyFactory = ViewerAdapterService.getModelProxyFactory(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
            this.fModelProxies.put(element, proxy);
            Job job = new Job("Model Proxy installed notification job"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        ModelContentProvider modelContentProvider = ModelContentProvider.this;
                        synchronized (modelContentProvider) {
                            if (!ModelContentProvider.this.isDisposed()) {
                                proxy.init(ModelContentProvider.this.getPresentationContext());
                                Object[] mcls = ModelContentProvider.this.fModelListeners.getListeners();
                                int i = 0;
                                while (i < mcls.length) {
                                    proxy.addModelChangedListener((IModelChangedListener)mcls[i]);
                                    ++i;
                                }
                                proxy.addModelChangedListener(ModelContentProvider.this);
                                proxy.installed(ModelContentProvider.this.getViewer());
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected abstract IPresentationContext getPresentationContext();

    public void modelChanged(final IModelDelta delta, final IModelProxy proxy) {
        WorkbenchJob job = new WorkbenchJob("process model delta"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!proxy.isDisposed()) {
                    ModelContentProvider.this.updateNodes(new IModelDelta[]{delta});
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void updateNodes(IModelDelta[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags();
            if ((flags & 1) != 0) {
                this.handleAdd(node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(node);
            }
            if ((flags & 0x100000) != 0) {
                this.handleExpand(node);
            }
            if ((flags & 0x2000000) != 0) {
                this.handleCollapse(node);
            }
            if ((flags & 0x200000) != 0) {
                this.handleSelect(node);
            }
            if ((flags & 0x800) != 0) {
                this.handleState(node);
            }
            if ((flags & 0x10) != 0) {
                this.handleInsert(node);
            }
            if ((flags & 8) != 0) {
                this.handleReplace(node);
            }
            if ((flags & 0x400000) != 0) {
                this.handleInstall(node);
            }
            if ((flags & 0x800000) != 0) {
                this.handleUninstall(node);
            }
            if ((flags & 0x1000000) != 0) {
                this.handleReveal(node);
            }
            this.updateNodes(node.getChildDeltas());
            ++i;
        }
    }

    protected abstract void handleState(IModelDelta var1);

    protected abstract void handleSelect(IModelDelta var1);

    protected abstract void handleExpand(IModelDelta var1);

    protected abstract void handleCollapse(IModelDelta var1);

    protected abstract void handleContent(IModelDelta var1);

    protected abstract void handleRemove(IModelDelta var1);

    protected abstract void handleAdd(IModelDelta var1);

    protected abstract void handleInsert(IModelDelta var1);

    protected abstract void handleReplace(IModelDelta var1);

    protected abstract void handleReveal(IModelDelta var1);

    protected void handleInstall(IModelDelta delta) {
        this.installModelProxy(delta.getElement());
    }

    protected void handleUninstall(IModelDelta delta) {
        this.disposeModelProxy(delta.getElement());
    }

    protected TreePath getViewerTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        IModelDelta parentDelta = node.getParentDelta();
        while (parentDelta != null) {
            list.add(0, node.getElement());
            node = parentDelta;
            parentDelta = node.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    public int viewToModelIndex(TreePath parentPath, int index) {
        return this.fTransform.viewToModelIndex(parentPath, index);
    }

    public int viewToModelCount(TreePath parentPath, int count) {
        return this.fTransform.viewToModelCount(parentPath, count);
    }

    protected int modelToViewIndex(TreePath parentPath, int index) {
        return this.fTransform.modelToViewIndex(parentPath, index);
    }

    protected int modelToViewChildCount(TreePath parentPath, int count) {
        return this.fTransform.modelToViewCount(parentPath, count);
    }

    protected boolean addFilteredIndex(TreePath parentPath, int index, Object element) {
        return this.fTransform.addFilteredIndex(parentPath, index, element);
    }

    protected void removeElementFromFilters(TreePath parentPath, int index) {
        this.fTransform.removeElementFromFilters(parentPath, index);
    }

    protected boolean removeElementFromFilters(TreePath parentPath, Object element) {
        return this.fTransform.removeElementFromFilters(parentPath, element);
    }

    protected void setModelChildCount(TreePath parentPath, int childCount) {
        this.fTransform.setModelChildCount(parentPath, childCount);
    }

    protected boolean shouldFilter(Object parentElementOrTreePath, Object element) {
        ViewerFilter[] filters = ((StructuredViewer)this.fViewer).getFilters();
        if (filters.length > 0) {
            int j = 0;
            while (j < filters.length) {
                if (!filters[j].select(this.fViewer, parentElementOrTreePath, element)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected boolean isFiltered(TreePath parentPath, int index) {
        return this.fTransform.isFiltered(parentPath, index);
    }

    protected void unmapPath(TreePath path) {
        this.fTransform.clear(path);
        this.cancelSubtreeUpdates(path);
    }

    protected int[] getFilteredChildren(TreePath parent) {
        return this.fTransform.getFilteredChildren(parent);
    }

    protected void clearFilteredChild(TreePath parent, int modelIndex) {
        this.fTransform.clear(parent, modelIndex);
    }

    protected void clearFilters(TreePath parent) {
        this.fTransform.clear(parent);
    }

    protected synchronized void checkIfRestoreComplete() {
        if (this.fPendingState == null) {
            return;
        }
        CheckState state = new CheckState();
        this.fPendingState.accept(state);
        if (state.isComplete()) {
            if (DEBUG_STATE_SAVE_RESTORE) {
                System.out.println("RESTORE COMPELTE: " + this.fPendingState);
            }
            this.fPendingState = null;
        }
    }

    void addViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.add((Object)listener);
    }

    void removeViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStarted(ViewerUpdateMonitor update) {
        boolean begin = false;
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            begin = this.fRequestsInProgress.isEmpty();
            ArrayList<ViewerUpdateMonitor> requests = (ArrayList<ViewerUpdateMonitor>)this.fRequestsInProgress.get(update.getSchedulingPath());
            if (requests == null) {
                requests = new ArrayList<ViewerUpdateMonitor>();
                this.fRequestsInProgress.put(update.getSchedulingPath(), requests);
            }
            requests.add(update);
        }
        if (begin) {
            if (DEBUG_UPDATE_SEQUENCE) {
                System.out.println("MODEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (DEBUG_UPDATE_SEQUENCE) {
            System.out.println("\tBEGIN - " + update);
        }
        this.notifyUpdate(2, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateComplete(ViewerUpdateMonitor update) {
        boolean end = false;
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            List requests = (List)this.fRequestsInProgress.get(update.getSchedulingPath());
            if (requests != null) {
                requests.remove(update);
                this.trigger(update);
                if (requests.isEmpty()) {
                    this.fRequestsInProgress.remove(update.getSchedulingPath());
                }
            }
            end = this.fRequestsInProgress.isEmpty();
        }
        this.notifyUpdate(3, update);
        if (DEBUG_UPDATE_SEQUENCE) {
            System.out.println("\tEND - " + update);
        }
        if (end) {
            if (DEBUG_UPDATE_SEQUENCE) {
                System.out.println("MODEL SEQUENCE ENDS");
            }
            this.notifyUpdate(1, null);
        }
    }

    protected void notifyUpdate(final int type, final IViewerUpdate update) {
        if (!this.fUpdateListeners.isEmpty()) {
            Object[] listeners = this.fUpdateListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IViewerUpdateListener listener = (IViewerUpdateListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.viewerUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.viewerUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.updateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.updateComplete(update);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSubtreeUpdates(TreePath path) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            TreePath entryPath;
            Iterator iterator = this.fRequestsInProgress.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entryPath = (TreePath)entry.getKey();
                if (!entryPath.startsWith(path, null)) continue;
                List requests = (List)entry.getValue();
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ((IRequest)reqIter.next()).cancel();
                }
            }
            ArrayList<TreePath> purge = new ArrayList<TreePath>();
            iterator = this.fWaitingRequests.keySet().iterator();
            while (iterator.hasNext()) {
                entryPath = (TreePath)iterator.next();
                if (!entryPath.startsWith(path, null)) continue;
                purge.add(entryPath);
            }
            iterator = purge.iterator();
            while (iterator.hasNext()) {
                this.fWaitingRequests.remove(iterator.next());
            }
        }
        Iterator itr = this.fCompareRequestsInProgress.keySet().iterator();
        while (itr.hasNext()) {
            CompareRequestKey key = (CompareRequestKey)itr.next();
            if (!key.fPath.startsWith(path, null)) continue;
            ElementCompareRequest compareRequest = (ElementCompareRequest)this.fCompareRequestsInProgress.get(key);
            compareRequest.cancel();
            itr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(ViewerUpdateMonitor update) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            TreePath schedulingPath = update.getSchedulingPath();
            ArrayList<ViewerUpdateMonitor> requests = (ArrayList<ViewerUpdateMonitor>)this.fWaitingRequests.get(schedulingPath);
            if (requests == null) {
                TreePath parentPath = schedulingPath;
                while (this.fRequestsInProgress.get(parentPath) == null) {
                    if ((parentPath = parentPath.getParentPath()) != null) continue;
                    update.start();
                    return;
                }
            } else {
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ViewerUpdateMonitor waiting = (ViewerUpdateMonitor)reqIter.next();
                    if (!waiting.coalesce(update)) continue;
                    return;
                }
                requests.add(update);
                return;
            }
            requests = new ArrayList<ViewerUpdateMonitor>();
            requests.add(update);
            this.fWaitingRequests.put(schedulingPath, requests);
        }
    }

    void trigger(ViewerUpdateMonitor request) {
        if (this.fWaitingRequests.isEmpty()) {
            return;
        }
        TreePath schedulingPath = request.getSchedulingPath();
        List waiting = (List)this.fWaitingRequests.get(schedulingPath);
        if (waiting == null) {
            int length = Integer.MAX_VALUE;
            Iterator entries = this.fWaitingRequests.entrySet().iterator();
            Map.Entry candidate = null;
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                TreePath key = (TreePath)entry.getKey();
                if (key.getSegmentCount() >= length) continue;
                candidate = entry;
                length = key.getSegmentCount();
            }
            if (candidate != null) {
                this.startHighestPriorityRequest((TreePath)candidate.getKey(), (List)candidate.getValue());
            }
        } else {
            this.startHighestPriorityRequest(schedulingPath, waiting);
        }
    }

    private void startHighestPriorityRequest(TreePath key, List waiting) {
        int priority = 4;
        ViewerUpdateMonitor next = null;
        Iterator requests = waiting.iterator();
        while (requests.hasNext()) {
            ViewerUpdateMonitor vu = (ViewerUpdateMonitor)requests.next();
            if (vu.getPriority() >= priority) continue;
            next = vu;
            priority = next.getPriority();
        }
        waiting.remove(next);
        if (waiting.isEmpty()) {
            this.fWaitingRequests.remove(key);
        }
        next.start();
    }

    void addModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.add((Object)listener);
        Iterator proxies = this.fModelProxies.values().iterator();
        while (proxies.hasNext()) {
            IModelProxy proxy = (IModelProxy)proxies.next();
            proxy.addModelChangedListener(listener);
        }
    }

    void removeModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.remove((Object)listener);
        Iterator proxies = this.fModelProxies.values().iterator();
        while (proxies.hasNext()) {
            IModelProxy proxy = (IModelProxy)proxies.next();
            proxy.removeModelChangedListener(listener);
        }
    }

    protected Object getElement(TreePath path) {
        if (path.getSegmentCount() > 0) {
            return path.getLastSegment();
        }
        return this.getViewer().getInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleUpdates(TreePath parentPath, int modelIndex) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            IChildrenUpdate childrenUpdate;
            IViewerUpdate update;
            Iterator iterator;
            List requests = (List)this.fRequestsInProgress.get(parentPath);
            ArrayList<IChildrenUpdate> reCreate = null;
            if (requests != null) {
                iterator = requests.iterator();
                while (iterator.hasNext()) {
                    update = (IViewerUpdate)iterator.next();
                    if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)update).getOffset() <= modelIndex) continue;
                    childrenUpdate.cancel();
                    if (reCreate == null) {
                        reCreate = new ArrayList<IChildrenUpdate>();
                    }
                    reCreate.add(childrenUpdate);
                    if (!DEBUG_CONTENT_PROVIDER) continue;
                    System.out.println("canceled update in progress handling REMOVE: " + childrenUpdate);
                }
            }
            if ((requests = (List)this.fWaitingRequests.get(parentPath)) != null) {
                iterator = requests.iterator();
                while (iterator.hasNext()) {
                    update = (IViewerUpdate)iterator.next();
                    if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)update).getOffset() <= modelIndex) continue;
                    ((ChildrenUpdate)childrenUpdate).setOffset(childrenUpdate.getOffset() - 1);
                    if (!DEBUG_CONTENT_PROVIDER) continue;
                    System.out.println("modified waiting update handling REMOVE: " + childrenUpdate);
                }
            }
            if (reCreate != null) {
                iterator = reCreate.iterator();
                while (iterator.hasNext()) {
                    IChildrenUpdate childrenUpdate2 = (IChildrenUpdate)iterator.next();
                    int start = childrenUpdate2.getOffset() - 1;
                    int end = start + childrenUpdate2.getLength();
                    int i = start;
                    while (i < end) {
                        ((TreeModelContentProvider)this).doUpdateElement(parentPath, i);
                        ++i;
                    }
                }
            }
        }
    }

    static /* synthetic */ void access$1(ModelContentProvider modelContentProvider, ModelDelta modelDelta) {
        modelContentProvider.fPendingState = modelDelta;
    }

    static /* synthetic */ ModelDelta access$2(ModelContentProvider modelContentProvider) {
        return modelContentProvider.fPendingState;
    }

    class CheckState
    implements IModelDeltaVisitor {
        private boolean complete = true;
        private IModelDelta topDelta = null;

        CheckState() {
        }

        public boolean visit(IModelDelta delta, int depth) {
            if (delta.getFlags() != 0) {
                if (delta.getFlags() == 0x1000000 && !(delta.getElement() instanceof IMemento)) {
                    this.topDelta = delta;
                } else {
                    this.complete = false;
                    return false;
                }
            }
            return true;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public IModelDelta getTopItemDelta() {
            return this.topDelta;
        }
    }

    private static class CompareRequestKey {
        TreePath fPath;
        IModelDelta fDelta;

        CompareRequestKey(TreePath path, IModelDelta delta) {
            this.fPath = path;
            this.fDelta = delta;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompareRequestKey) {
                CompareRequestKey key = (CompareRequestKey)obj;
                return key.fDelta.equals(this.fDelta) && key.fPath.equals((Object)this.fPath);
            }
            return false;
        }

        public int hashCode() {
            return this.fDelta.hashCode() + this.fPath.hashCode();
        }
    }

    class LRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private int fMaxSize;

        LRUMap(int maxSize) {
            this.fMaxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fMaxSize;
        }
    }
}

