/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabImageDescriptor;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchDelegateContribution;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchConfigurationManager
implements ILaunchListener,
ISaveParticipant {
    protected Map fLaunchGroups;
    protected Map fLaunchHistories;
    protected List fLaunchHistoryChangedListeners = new ArrayList(3);
    private List fLaunchShortcuts = null;
    private Map fLaunchShortcutsByPerspective = null;
    protected ImageRegistry fErrorImages = null;
    protected boolean fRestoring = false;
    private static final String LAUNCH_CONFIGURATION_HISTORY_FILENAME = "launchConfigurationHistory.xml";

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        DebugUIPlugin.getDefault().addSaveParticipant(this);
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            this.launchAdded(launches[i]);
            ++i;
        }
    }

    public boolean launchModeAvailable(String mode) {
        return ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).launchModeAvailable(mode);
    }

    public static boolean isVisible(ILaunchConfiguration launchConfiguration) {
        try {
            return !launchConfiguration.getAttribute("org.eclipse.debug.ui.private", false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static ILaunchConfiguration[] filterConfigs(ILaunchConfiguration[] configurations) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport == null) {
            return configurations;
        }
        ArrayList<ILaunchConfiguration> filteredConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfigurationType type = null;
        LaunchConfigurationTypeContribution contribution = null;
        ILaunchConfiguration configuration = null;
        int i = 0;
        while (i < configurations.length) {
            configuration = configurations[i];
            try {
                type = configuration.getType();
                contribution = new LaunchConfigurationTypeContribution(type);
                if (DebugUIPlugin.doLaunchConfigurationFiltering(configuration) & !WorkbenchActivityHelper.filterItem((Object)contribution)) {
                    filteredConfigs.add(configuration);
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
            ++i;
        }
        return filteredConfigs.toArray(new ILaunchConfiguration[filteredConfigs.size()]);
    }

    public static ILaunchDelegate[] filterLaunchDelegates(ILaunchConfigurationType type, Set modes) throws CoreException {
        IWorkbenchActivitySupport as = PlatformUI.getWorkbench().getActivitySupport();
        ILaunchDelegate[] delegates = type.getDelegates(modes);
        if (as == null) {
            return delegates;
        }
        HashSet<ILaunchDelegate> set = new HashSet<ILaunchDelegate>();
        int i = 0;
        while (i < delegates.length) {
            if (!WorkbenchActivityHelper.filterItem((Object)new LaunchDelegateContribution(delegates[i]))) {
                set.add(delegates[i]);
            }
            ++i;
        }
        return set.toArray(new ILaunchDelegate[set.size()]);
    }

    public void shutdown() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener((ILaunchListener)this);
        if (this.fLaunchHistories != null) {
            Iterator histories = this.fLaunchHistories.values().iterator();
            while (histories.hasNext()) {
                LaunchHistory history = (LaunchHistory)histories.next();
                history.dispose();
            }
        }
        DebugUIPlugin.getDefault().removeSaveParticipant(this);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        this.removeTerminatedLaunches(launch);
    }

    protected void removeTerminatedLaunches(ILaunch newLaunch) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches")) {
            ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] launches = lManager.getLaunches();
            int i = 0;
            while (i < launches.length) {
                ILaunch launch = launches[i];
                if (launch != newLaunch && launch.isTerminated()) {
                    lManager.removeLaunch(launch);
                }
                ++i;
            }
        }
    }

    public ILaunchConfiguration getLastLaunch(String groupId) {
        LaunchHistory history = this.getLaunchHistory(groupId);
        if (history != null) {
            return history.getRecentLaunch();
        }
        return null;
    }

    public ILaunchConfiguration getFilteredLastLaunch(String groupId) {
        ILaunchConfiguration[] filterConfigs;
        LaunchHistory history = this.getLaunchHistory(groupId);
        if (history != null && (filterConfigs = history.getCompleteLaunchHistory()).length > 0) {
            return filterConfigs[0];
        }
        return null;
    }

    public void addLaunchHistoryListener(ILaunchHistoryChangedListener listener) {
        if (!this.fLaunchHistoryChangedListeners.contains(listener)) {
            this.fLaunchHistoryChangedListeners.add(listener);
        }
    }

    public void removeLaunchHistoryListener(ILaunchHistoryChangedListener listener) {
        this.fLaunchHistoryChangedListeners.remove(listener);
    }

    protected void fireLaunchHistoryChanged() {
        Iterator iterator = this.fLaunchHistoryChangedListeners.iterator();
        ILaunchHistoryChangedListener listener = null;
        while (iterator.hasNext()) {
            listener = (ILaunchHistoryChangedListener)iterator.next();
            listener.launchHistoryChanged();
        }
    }

    protected String getHistoryAsXML() throws CoreException, ParserConfigurationException {
        Document doc = DebugUIPlugin.getDocument();
        Element historyRootElement = doc.createElement("launchHistory");
        doc.appendChild(historyRootElement);
        Iterator histories = this.fLaunchHistories.values().iterator();
        LaunchHistory history = null;
        while (histories.hasNext()) {
            history = (LaunchHistory)histories.next();
            Element groupElement = doc.createElement("launchGroup");
            groupElement.setAttribute("id", history.getLaunchGroup().getIdentifier());
            historyRootElement.appendChild(groupElement);
            Element historyElement = doc.createElement("mruHistory");
            groupElement.appendChild(historyElement);
            this.createEntry(doc, historyElement, history.getCompleteLaunchHistory());
            Element favs = doc.createElement("favorites");
            groupElement.appendChild(favs);
            this.createEntry(doc, favs, history.getFavorites());
            history.setSaved(true);
        }
        return DebugPlugin.serializeDocument((Document)doc);
    }

    protected void createEntry(Document doc, Element historyRootElement, ILaunchConfiguration[] configurations) throws CoreException {
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.exists()) {
                Element launch = doc.createElement("launch");
                launch.setAttribute("memento", configuration.getMemento());
                historyRootElement.appendChild(launch);
            }
            ++i;
        }
    }

    protected IPath getHistoryFilePath() {
        return DebugUIPlugin.getDefault().getStateLocation().append(LAUNCH_CONFIGURATION_HISTORY_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistLaunchHistory() throws IOException, CoreException, ParserConfigurationException {
        LaunchConfigurationManager launchConfigurationManager = this;
        synchronized (launchConfigurationManager) {
            if (this.fLaunchHistories == null || this.fRestoring) {
                return;
            }
        }
        boolean shouldsave = false;
        Iterator iter = this.fLaunchHistories.values().iterator();
        while (iter.hasNext()) {
            shouldsave |= ((LaunchHistory)iter.next()).needsSaving();
        }
        if (shouldsave) {
            IPath historyPath = this.getHistoryFilePath();
            String osHistoryPath = historyPath.toOSString();
            String xml = this.getHistoryAsXML();
            File file = new File(osHistoryPath);
            file.createNewFile();
            FileOutputStream stream = new FileOutputStream(file);
            stream.write(xml.getBytes("UTF8"));
            stream.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void restoreLaunchHistory() {
        historyPath = this.getHistoryFilePath();
        osHistoryPath = historyPath.toOSString();
        file = new File(osHistoryPath);
        if (!file.exists()) {
            return;
        }
        stream = null;
        rootHistoryElement = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            try {
                try {
                    parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    rootHistoryElement = parser.parse(new InputSource(stream)).getDocumentElement();
                }
                catch (SAXException e) {
                    DebugUIPlugin.log(e);
lbl18:
                    // 2 sources

                    while (true) {
                        stream.close();
                        return;
                    }
                }
                catch (ParserConfigurationException e) {
                    DebugUIPlugin.log(e);
                    ** continue;
                }
            }
            finally {
                stream.close();
            }
        }
        catch (IOException exception) {
            DebugUIPlugin.log(exception);
            return;
        }
        if (!rootHistoryElement.getNodeName().equalsIgnoreCase("launchHistory")) {
            return;
        }
        l = this.fLaunchHistories.values();
        histories = l.toArray(new LaunchHistory[l.size()]);
        list = rootHistoryElement.getChildNodes();
        length = list.getLength();
        node = null;
        entry = null;
        i = 0;
        while (i < length) {
            node = list.item(i);
            type = node.getNodeType();
            if (type == 1) {
                entry = (Element)node;
                if (entry.getNodeName().equalsIgnoreCase("launch")) {
                    this.createHistoryElement(entry, histories, false);
                } else if (entry.getNodeName().equalsIgnoreCase("lastLaunch")) {
                    this.createHistoryElement(entry, histories, true);
                } else if (entry.getNodeName().equals("launchGroup") && (id = entry.getAttribute("id")) != null && (history = this.getLaunchHistory(id)) != null) {
                    this.restoreHistory(entry, history);
                }
            }
            ++i;
        }
    }

    private void restoreHistory(Element groupElement, LaunchHistory history) {
        NodeList nodes = groupElement.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getNodeName().equals("mruHistory")) {
                    ILaunchConfiguration[] configs = this.getLaunchConfigurations(element);
                    int j = 0;
                    while (j < configs.length) {
                        history.addHistory(configs[j], false);
                        ++j;
                    }
                } else if (element.getNodeName().equals("favorites")) {
                    ILaunchConfiguration[] favs = this.getLaunchConfigurations(element);
                    history.setFavorites(favs);
                }
            }
            ++i;
        }
    }

    private ILaunchConfiguration[] getLaunchConfigurations(Element root) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        NodeList nodes = root.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            String memento;
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals("launch") && (memento = element.getAttribute("memento")) != null) {
                try {
                    ILaunchConfiguration configuration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
                    configuration.getType();
                    if (configuration.exists()) {
                        configs.add(configuration);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    private void createHistoryElement(Element entry, LaunchHistory[] histories, boolean prepend) {
        String memento = entry.getAttribute("memento");
        String mode = entry.getAttribute("mode");
        try {
            ILaunchConfiguration launchConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
            launchConfig.getType();
            if (launchConfig.exists()) {
                LaunchHistory history = null;
                int i = 0;
                while (i < histories.length) {
                    history = histories[i];
                    if (history.accepts(launchConfig) && history.getLaunchGroup().getMode().equals(mode)) {
                        history.addHistory(launchConfig, prepend);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void loadLaunchShortcuts() {
        if (this.fLaunchShortcuts == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchShortcuts");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchShortcuts = new ArrayList(infos.length);
            int i = 0;
            while (i < infos.length) {
                this.fLaunchShortcuts.add(new LaunchShortcutExtension(infos[i]));
                ++i;
            }
            Collections.sort(this.fLaunchShortcuts, new ShortcutComparator());
        }
    }

    private void loadLaunchGroups() {
        if (this.fLaunchGroups == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchGroups");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchGroups = new HashMap(infos.length);
            LaunchGroupExtension ext = null;
            int i = 0;
            while (i < infos.length) {
                ext = new LaunchGroupExtension(infos[i]);
                this.fLaunchGroups.put(ext.getIdentifier(), ext);
                ++i;
            }
        }
    }

    public List getLaunchShortcuts() {
        if (this.fLaunchShortcuts == null) {
            this.loadLaunchShortcuts();
        }
        return this.fLaunchShortcuts;
    }

    public List getLaunchShortcuts(IResource resource) {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        List sc = this.getLaunchShortcuts();
        ArrayList<IResource> ctxt = new ArrayList<IResource>();
        if (resource != null) {
            ctxt.add(resource);
        }
        EvaluationContext context = new EvaluationContext(null, ctxt);
        context.addVariable("selection", ctxt);
        LaunchShortcutExtension ext = null;
        Iterator iter = sc.iterator();
        while (iter.hasNext()) {
            ext = (LaunchShortcutExtension)iter.next();
            try {
                if (!ext.evalEnablementExpression((IEvaluationContext)context, ext.getContextualLaunchEnablementExpression()) || WorkbenchActivityHelper.filterItem((Object)ext) || list.contains(ext)) continue;
                list.add(ext);
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    public List getApplicableConfigurationTypes(IResource resource) {
        ArrayList<ILaunchConfigurationType> types = new ArrayList<ILaunchConfigurationType>();
        List exts = this.getLaunchShortcuts();
        LaunchShortcutExtension ext = null;
        ArrayList<IResource> list = new ArrayList<IResource>();
        list.add(resource);
        EvaluationContext context = new EvaluationContext(null, list);
        context.setAllowPluginActivation(true);
        context.addVariable("selection", list);
        HashSet set = new HashSet();
        ListIterator iter = exts.listIterator();
        while (iter.hasNext()) {
            ext = (LaunchShortcutExtension)iter.next();
            try {
                if (!ext.evalEnablementExpression((IEvaluationContext)context, ext.getContextualLaunchEnablementExpression())) continue;
                set.addAll(ext.getAssociatedConfigurationTypes());
            }
            catch (CoreException ce) {
                Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Launch shortcut '" + ext.getId() + "' enablement expression caused exception. Shortcut was removed.", (Throwable)ce);
                DebugUIPlugin.log((IStatus)status);
                iter.remove();
            }
        }
        LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = null;
        Iterator iter2 = set.iterator();
        while (iter2.hasNext()) {
            type = lm.getLaunchConfigurationType((String)iter2.next());
            if (type == null || types.contains(type) || !type.isPublic() || "org.eclipse.ui.externaltools.builder".equals(type.getCategory())) continue;
            types.add(type);
        }
        return types;
    }

    public List getApplicableLaunchConfigurations(List types, IResource resource) {
        ArrayList<ILaunchConfiguration> list;
        block9: {
            list = new ArrayList<ILaunchConfiguration>();
            try {
                if (resource == null) break block9;
                List ctypes = types;
                if (ctypes == null) {
                    ctypes = this.getApplicableConfigurationTypes(resource);
                }
                ILaunchConfiguration[] configurations = LaunchConfigurationManager.filterConfigs(this.getLaunchManager().getLaunchConfigurations());
                ILaunchConfiguration configuration = null;
                IResource[] resrcs = null;
                int i = 0;
                while (i < configurations.length) {
                    configuration = configurations[i];
                    if (ctypes.contains(configuration.getType()) && this.acceptConfiguration(configuration)) {
                        resrcs = configuration.getMappedResources();
                        if (resrcs != null) {
                            int j = 0;
                            while (j < resrcs.length) {
                                if (resource.equals((Object)resrcs[j]) || resource.getFullPath().isPrefixOf(resrcs[j].getFullPath())) {
                                    list.add(configuration);
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            list.add(configuration);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                list.clear();
                DebugPlugin.log((Throwable)e);
            }
        }
        return list;
    }

    private boolean acceptConfiguration(ILaunchConfiguration config) throws CoreException {
        if (config != null && !DebugUITools.isPrivate(config)) {
            if (!"org.eclipse.ui.externaltools".equals(config.getType().getCategory())) {
                return true;
            }
            IResource[] res = config.getMappedResources();
            if (res != null) {
                return true;
            }
        }
        return false;
    }

    public List getLaunchShortcuts(String category) {
        return this.filterShortcuts(this.getLaunchShortcuts(), category);
    }

    protected List filterShortcuts(List unfiltered, String category) {
        ArrayList<LaunchShortcutExtension> filtered = new ArrayList<LaunchShortcutExtension>(unfiltered.size());
        Iterator iter = unfiltered.iterator();
        LaunchShortcutExtension extension = null;
        while (iter.hasNext()) {
            extension = (LaunchShortcutExtension)iter.next();
            if (category == null) {
                if (extension.getCategory() != null) continue;
                filtered.add(extension);
                continue;
            }
            if (!category.equals(extension.getCategory())) continue;
            filtered.add(extension);
        }
        return filtered;
    }

    public List getLaunchShortcuts(String perpsective, String category) {
        List list;
        if (this.fLaunchShortcutsByPerspective == null) {
            Iterator shortcuts = this.getLaunchShortcuts().iterator();
            this.fLaunchShortcutsByPerspective = new HashMap(10);
            LaunchShortcutExtension ext = null;
            Iterator perspectives = null;
            while (shortcuts.hasNext()) {
                ext = (LaunchShortcutExtension)shortcuts.next();
                perspectives = ext.getPerspectives().iterator();
                while (perspectives.hasNext()) {
                    String id = (String)perspectives.next();
                    ArrayList<LaunchShortcutExtension> list2 = (ArrayList<LaunchShortcutExtension>)this.fLaunchShortcutsByPerspective.get(id);
                    if (list2 == null) {
                        list2 = new ArrayList<LaunchShortcutExtension>(4);
                        this.fLaunchShortcutsByPerspective.put(id, list2);
                    }
                    list2.add(ext);
                }
            }
        }
        if ((list = (List)this.fLaunchShortcutsByPerspective.get(perpsective)) == null) {
            return new ArrayList();
        }
        return this.filterShortcuts(list, category);
    }

    public ILaunchConfiguration getMRUConfiguration(List configurations, ILaunchGroup group, IResource resource) {
        if (group != null) {
            ArrayList<ILaunchConfiguration> candidates = new ArrayList<ILaunchConfiguration>();
            LaunchHistory history = this.getLaunchHistory(group.getIdentifier());
            if (history != null) {
                ILaunchConfiguration[] configs = history.getCompleteLaunchHistory();
                int i = 0;
                while (i < configs.length) {
                    if (configurations.contains(configs[i])) {
                        if (resource instanceof IContainer) {
                            return configs[i];
                        }
                        candidates.add(configs[i]);
                    }
                    ++i;
                }
                ILaunchConfiguration config = null;
                if (resource != null) {
                    IResource[] res = null;
                    Iterator iter = candidates.iterator();
                    while (iter.hasNext()) {
                        config = (ILaunchConfiguration)iter.next();
                        try {
                            res = config.getMappedResources();
                            if (res == null) continue;
                            int i2 = 0;
                            while (i2 < res.length) {
                                if (res[i2].equals((Object)resource)) {
                                    return config;
                                }
                                ++i2;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                int i3 = 0;
                while (i3 < configs.length) {
                    if (candidates.contains(configs[i3])) {
                        return configs[i3];
                    }
                    ++i3;
                }
            }
        }
        return null;
    }

    public ILaunchConfiguration isSharedConfig(Object receiver) {
        if (receiver instanceof IFile) {
            ILaunchConfiguration config;
            IFile file = (IFile)receiver;
            String ext = file.getFileExtension();
            if (ext == null) {
                return null;
            }
            if (ext.equals("launch") && (config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(file)) != null && config.exists()) {
                return config;
            }
        } else {
            if (receiver instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)receiver;
                return this.isSharedConfig(input.getFile());
            }
            if (receiver instanceof IEditorPart) {
                return this.isSharedConfig(((IEditorPart)receiver).getEditorInput());
            }
        }
        return null;
    }

    public Image getErrorTabImage(ILaunchConfigurationTab tab) {
        String key;
        Image image;
        if (this.fErrorImages == null) {
            this.fErrorImages = new ImageRegistry();
        }
        if ((image = this.fErrorImages.get(key = tab.getClass().getName())) == null) {
            Image base = tab.getImage();
            if (base == null) {
                base = DebugPluginImages.getImage("IMG_OVR_TRANSPARENT");
            }
            base = new Image((Device)Display.getCurrent(), base, 0);
            LaunchConfigurationTabImageDescriptor desc = new LaunchConfigurationTabImageDescriptor(base, 1);
            image = desc.createImage();
            this.fErrorImages.put(key, image);
        }
        return image;
    }

    public LaunchGroupExtension getLaunchGroup(String id) {
        if (this.fLaunchGroups == null) {
            this.loadLaunchGroups();
        }
        return (LaunchGroupExtension)this.fLaunchGroups.get(id);
    }

    public ILaunchGroup[] getLaunchGroups() {
        if (this.fLaunchGroups == null) {
            this.loadLaunchGroups();
        }
        Collection groups = this.fLaunchGroups.values();
        return groups.toArray(new ILaunchGroup[groups.size()]);
    }

    public LaunchHistory getLaunchHistory(String id) {
        this.loadLaunchHistories();
        return (LaunchHistory)this.fLaunchHistories.get(id);
    }

    private LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    private synchronized void loadLaunchHistories() {
        if (this.fLaunchHistories == null) {
            this.fRestoring = true;
            ILaunchGroup[] groups = this.getLaunchGroups();
            this.fLaunchHistories = new HashMap(groups.length);
            ILaunchGroup extension = null;
            int i = 0;
            while (i < groups.length) {
                extension = groups[i];
                if (extension.isPublic()) {
                    this.fLaunchHistories.put(extension.getIdentifier(), new LaunchHistory(extension));
                }
                ++i;
            }
            this.restoreLaunchHistory();
            this.fRestoring = false;
        }
    }

    public LaunchGroupExtension getDefaultLaunchGroup(String mode) {
        if (mode.equals("debug")) {
            return this.getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug");
        }
        return this.getLaunchGroup("org.eclipse.debug.ui.launchGroup.run");
    }

    public ILaunchGroup getLaunchGroup(ILaunchConfigurationType type, String mode) {
        String category = type.getCategory();
        ILaunchGroup[] groups = this.getLaunchGroups();
        ILaunchGroup extension = null;
        int i = 0;
        while (i < groups.length) {
            extension = groups[i];
            if (category == null ? extension.getCategory() == null && extension.getMode().equals(mode) : category.equals(extension.getCategory()) && extension.getMode().equals(mode)) {
                return extension;
            }
            ++i;
        }
        return null;
    }

    public ILaunchGroup getLaunchGroup(ILaunchConfigurationType type, Set modeset) {
        StringBuffer buff = new StringBuffer();
        Object item = null;
        Iterator iter = modeset.iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!(item instanceof String)) continue;
            buff.append((Object)item);
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return this.getLaunchGroup(type, buff.toString());
    }

    public static ILaunchConfiguration getSharedTypeConfig(ILaunchConfigurationType type) throws CoreException {
        String id = type.getIdentifier();
        String name = String.valueOf(id) + ".SHARED_INFO";
        ILaunchConfiguration shared = null;
        ILaunchConfiguration[] configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
        ILaunchConfiguration configuration = null;
        int i = 0;
        while (i < configurations.length) {
            configuration = configurations[i];
            if (configuration.getName().equals(name)) {
                shared = configuration;
                break;
            }
            ++i;
        }
        if (shared == null) {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            shared = workingCopy.doSave();
        }
        return shared;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        try {
            this.persistLaunchHistory();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Internal error saving launch history", (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Internal error saving launch history", (Throwable)e));
        }
    }

    public void setRecentLaunch(ILaunch launch) {
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        int size = groups.length;
        int i = 0;
        while (i < size) {
            String id = groups[i].getIdentifier();
            LaunchHistory history = this.getLaunchHistory(id);
            if (history != null) {
                history.launchAdded(launch);
            }
            ++i;
        }
    }

    class ShortcutComparator
    implements Comparator {
        ShortcutComparator() {
        }

        public int compare(Object a, Object b) {
            LaunchShortcutExtension shorcutA = (LaunchShortcutExtension)a;
            String labelA = shorcutA.getLabel();
            String pathA = shorcutA.getMenuPath();
            LaunchShortcutExtension shortcutB = (LaunchShortcutExtension)b;
            String labelB = shortcutB.getLabel();
            String pathB = shortcutB.getMenuPath();
            if (this.nullOrEqual(pathA, pathB)) {
                if (labelA == labelB) {
                    return 0;
                }
                if (labelA == null) {
                    return 1;
                }
                if (labelB == null) {
                    return -1;
                }
                return labelA.compareToIgnoreCase(labelB);
            }
            if (pathA == null) {
                return 1;
            }
            if (pathB == null) {
                return -1;
            }
            return pathA.compareToIgnoreCase(pathB);
        }

        private boolean nullOrEqual(String a, String b) {
            if (a == null) {
                return b == null;
            }
            return a.equals(b);
        }
    }
}

