/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing;

import java.io.OutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;

public class ProcessingStepHandler {
    private static final String PROCESSING_STEPS_EXTENSION_ID = "org.eclipse.equinox.p2.artifact.repository.processingSteps";

    public static IStatus checkStatus(OutputStream output) {
        if (!(output instanceof ProcessingStep)) {
            return Status.OK_STATUS;
        }
        return ((ProcessingStep)output).getStatus(true);
    }

    public static boolean canProcess(IArtifactDescriptor descriptor) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PROCESSING_STEPS_EXTENSION_ID);
        if (point == null) {
            return false;
        }
        ProcessingStepDescriptor[] steps = descriptor.getProcessingSteps();
        int i = 0;
        while (i < steps.length) {
            if (point.getExtension(steps[i].getProcessorId()) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ProcessingStep[] create(ProcessingStepDescriptor[] descriptors, IArtifactDescriptor context) {
        ProcessingStep[] result = new ProcessingStep[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            result[i] = this.create(descriptors[i], context);
            ++i;
        }
        return result;
    }

    public ProcessingStep create(ProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        Exception error;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtension extension = registry.getExtension(PROCESSING_STEPS_EXTENSION_ID, descriptor.getProcessorId());
        if (extension != null) {
            IConfigurationElement[] config = extension.getConfigurationElements();
            try {
                Object object = config[0].createExecutableExtension("class");
                ProcessingStep step = (ProcessingStep)object;
                step.initialize(descriptor, context);
                return step;
            }
            catch (Exception e) {
                error = e;
            }
        } else {
            error = new ProcessingStepHandlerException("Could not get extension org.eclipse.equinox.p2.artifact.repository.processingSteps for desriptor id " + descriptor.getProcessorId());
        }
        int severity = descriptor.isRequired() ? 4 : 1;
        EmptyProcessingStep result = new EmptyProcessingStep();
        result.setStatus((IStatus)new Status(severity, "org.eclipse.equinox.p2.artifact.repository", "Could not instantiate step:" + descriptor.getProcessorId(), (Throwable)error));
        return result;
    }

    public OutputStream createAndLink(ProcessingStepDescriptor[] descriptors, IArtifactDescriptor context, OutputStream output, IProgressMonitor monitor) {
        if (descriptors == null) {
            return output;
        }
        ProcessingStep[] steps = this.create(descriptors, context);
        return this.link(steps, output, monitor);
    }

    public OutputStream link(ProcessingStep[] steps, OutputStream output, IProgressMonitor monitor) {
        OutputStream previous = output;
        int i = steps.length - 1;
        while (i >= 0) {
            ProcessingStep step = steps[i];
            step.link(previous, monitor);
            previous = step;
            --i;
        }
        return previous;
    }

    protected static final class EmptyProcessingStep
    extends ProcessingStep {
        protected EmptyProcessingStep() {
        }
    }

    protected static final class ProcessingStepHandlerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ProcessingStepHandlerException(String message) {
            super(message);
        }
    }
}

