/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IStateful;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;

public abstract class ProcessingStep
extends OutputStream
implements IStateful {
    private OutputStream destination;
    private IProgressMonitor monitor;
    private IStatus status = Status.OK_STATUS;

    protected ProcessingStep() {
    }

    public void initialize(ProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
    }

    public void link(OutputStream destination, IProgressMonitor monitor) {
        this.destination = destination;
        this.monitor = monitor;
    }

    public void write(int b) throws IOException {
    }

    public void flush() throws IOException {
        super.flush();
        if (this.destination != null) {
            this.destination.flush();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.destination instanceof ProcessingStep) {
            this.destination.close();
        }
        this.monitor = null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status == null ? Status.OK_STATUS : status;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected OutputStream getDestination() {
        return this.destination;
    }

    public IStatus getStatus(boolean deep) {
        if (!deep) {
            return this.getStatus();
        }
        ArrayList list = new ArrayList();
        int severity = this.collectStatus(list);
        if (severity == 0) {
            return Status.OK_STATUS;
        }
        IStatus[] result = list.toArray(new IStatus[list.size()]);
        return new MultiStatus("org.eclipse.equinox.p2.artifact.repository", severity, result, "Result of processing steps", null);
    }

    private int collectStatus(ArrayList list) {
        list.add(this.getStatus());
        if (!(this.destination instanceof ProcessingStep)) {
            return this.getStatus().getSeverity();
        }
        int result = ((ProcessingStep)this.destination).collectStatus(list);
        if (this.getStatus().getSeverity() > result) {
            return this.getStatus().getSeverity();
        }
        return result;
    }
}

