/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.osgi.util.NLS;

public class MirrorRequest
extends ArtifactRequest {
    private static final ProcessingStepDescriptor[] EMPTY_STEPS = new ProcessingStepDescriptor[0];
    private final IArtifactRepository target;
    private final Properties targetDescriptorProperties;
    private final Properties targetRepositoryProperties;

    public MirrorRequest(IArtifactKey key, IArtifactRepository targetRepository, Properties targetDescriptorProperties, Properties targetRepositoryProperties) {
        super(key);
        this.target = targetRepository;
        if (targetDescriptorProperties == null || targetDescriptorProperties.isEmpty()) {
            this.targetDescriptorProperties = null;
        } else {
            this.targetDescriptorProperties = new Properties();
            this.targetDescriptorProperties.putAll((Map<?, ?>)targetDescriptorProperties);
        }
        if (targetRepositoryProperties == null || targetRepositoryProperties.isEmpty()) {
            this.targetRepositoryProperties = null;
        } else {
            this.targetRepositoryProperties = new Properties();
            this.targetRepositoryProperties.putAll((Map<?, ?>)targetRepositoryProperties);
        }
    }

    public void perform(IProgressMonitor monitor) {
        IStatus status;
        IArtifactDescriptor[] descriptors;
        monitor.subTask(NLS.bind((String)Messages.downloading, (Object)this.getArtifactKey().getId()));
        if (this.target.contains(this.getArtifactKey())) {
            this.setResult((IStatus)new Status(0, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.available_already_in, (Object)this.getArtifactKey())));
            return;
        }
        IArtifactDescriptor optimized = null;
        IArtifactDescriptor canonical = null;
        if (this.descriptor == null && (descriptors = this.source.getArtifactDescriptors(this.getArtifactKey())).length > 0) {
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].getProperty("format") == null) {
                    canonical = descriptors[i];
                } else if (ProcessingStepHandler.canProcess(descriptors[i])) {
                    optimized = descriptors[i];
                }
                ++i;
            }
            boolean chooseCanonical = this.source.getLocation().getProtocol().equals("file");
            IArtifactDescriptor iArtifactDescriptor = this.descriptor = chooseCanonical ? canonical : optimized;
            if (this.descriptor == null) {
                IArtifactDescriptor iArtifactDescriptor2 = this.descriptor = !chooseCanonical ? canonical : optimized;
            }
        }
        if (this.descriptor == null) {
            this.setResult((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.artifact_not_found, (Object)this.getArtifactKey())));
            return;
        }
        ArtifactDescriptor destinationDescriptor = new ArtifactDescriptor(this.getArtifactDescriptor());
        destinationDescriptor.setProcessingSteps(EMPTY_STEPS);
        destinationDescriptor.setProperty("download.md5", null);
        if (this.targetDescriptorProperties != null) {
            destinationDescriptor.addProperties(this.targetDescriptorProperties);
        }
        if (this.targetRepositoryProperties != null) {
            destinationDescriptor.addRepositoryProperties(this.targetRepositoryProperties);
        }
        if ((status = this.transfer(destinationDescriptor, this.descriptor, monitor)).isOK() || this.descriptor == canonical || canonical == null) {
            this.setResult(status);
            return;
        }
        if (this.target.contains(destinationDescriptor)) {
            this.target.removeDescriptor(destinationDescriptor);
        }
        this.setResult(this.transfer(destinationDescriptor, canonical, monitor));
    }

    private IStatus transfer(IArtifactDescriptor destinationDescriptor, IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) {
        OutputStream destination;
        try {
            destination = this.target.getOutputStream(destinationDescriptor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        try {
            IStatus iStatus = this.getSourceRepository().getArtifact(this.descriptor, destination, monitor);
            return iStatus;
        }
        finally {
            try {
                destination.close();
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
            }
        }
    }

    public String toString() {
        return String.valueOf(Messages.mirroring) + this.getArtifactKey() + " into " + this.target;
    }
}

