/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.Transport;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IStateful;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ECFTransport
extends Transport {
    private static final int LOGIN_RETRIES = 3;
    private static final ProtocolException ERROR_401 = new ProtocolException();
    private static final String SERVER_REDIRECT = "Server redirected too many times";
    private static ECFTransport instance;
    private final ServiceTracker retrievalFactoryTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static synchronized ECFTransport getInstance() {
        if (instance == null) {
            instance = new ECFTransport();
        }
        return instance;
    }

    private ECFTransport() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.retrievalFactoryTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.retrievalFactoryTracker.open();
    }

    protected IStatus convertToStatus(IFileTransferEvent event, Exception failure, long startTime, String location) {
        long bytes;
        long speed = -1L;
        if (event instanceof IIncomingFileTransferEvent && (bytes = ((IIncomingFileTransferEvent)event).getSource().getBytesReceived()) > 0L) {
            long elapsed = (System.currentTimeMillis() - startTime) / 1000L;
            if (elapsed == 0L) {
                elapsed = 1L;
            }
            speed = bytes / elapsed;
        }
        DownloadStatus result = null;
        result = failure == null ? new DownloadStatus(0, "org.eclipse.equinox.p2.artifact.repository", Status.OK_STATUS.getMessage()) : (failure instanceof UserCancelledException ? new DownloadStatus(8, "org.eclipse.equinox.p2.artifact.repository", failure.getMessage(), failure) : new DownloadStatus(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.io_failedRead, (Object)location), failure));
        result.setTransferRate(speed);
        return result;
    }

    public IStatus download(String url, OutputStream destination, IProgressMonitor monitor) {
        try {
            IConnectContext context = this.getConnectionContext(url, false);
            int i = 0;
            while (i < 3) {
                try {
                    return this.performDownload(url, destination, context, monitor);
                }
                catch (ProtocolException e) {
                    if (e == ERROR_401) {
                        context = this.getConnectionContext(url, true);
                    }
                    ++i;
                }
            }
        }
        catch (UserCancelledException userCancelledException) {
            return Status.CANCEL_STATUS;
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1007, NLS.bind((String)Messages.io_failedRead, (Object)url), null);
    }

    public IStatus performDownload(String toDownload, OutputStream target, IConnectContext context, IProgressMonitor monitor) throws ProtocolException {
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)this.retrievalFactoryTracker.getService();
        if (factory == null) {
            return ECFTransport.statusOn(target, (IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.io_failedRead, (Object)toDownload)));
        }
        return this.transfer((IRetrieveFileTransferContainerAdapter)factory.newInstance(), toDownload, target, context, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus transfer(IRetrieveFileTransferContainerAdapter retrievalContainer, final String toDownload, final OutputStream target, IConnectContext context, final IProgressMonitor monitor) throws ProtocolException {
        final IStatus[] result = new IStatus[1];
        final long startTime = System.currentTimeMillis();
        IFileTransferListener listener = new IFileTransferListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void handleTransferEvent(IFileTransferEvent event) {
                if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                    IIncomingFileTransferReceiveStartEvent rse = (IIncomingFileTransferReceiveStartEvent)event;
                    try {
                        if (target != null) {
                            rse.receive(target);
                        }
                    }
                    catch (IOException e) {
                        IStatus status = ECFTransport.this.convertToStatus(event, e, startTime, toDownload);
                        IStatus[] iStatusArray = result;
                        // MONITORENTER : result
                        result[0] = status;
                        result.notify();
                        // MONITOREXIT : iStatusArray
                    }
                }
                if (event instanceof IIncomingFileTransferReceiveDataEvent) {
                    IIncomingFileTransfer source = ((IIncomingFileTransferReceiveDataEvent)event).getSource();
                    if (monitor != null && monitor.isCanceled()) {
                        source.cancel();
                    }
                }
                if (!(event instanceof IIncomingFileTransferReceiveDoneEvent)) return;
                Exception exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
                IStatus status = ECFTransport.this.convertToStatus(event, exception, startTime, toDownload);
                IStatus[] iStatusArray = result;
                // MONITORENTER : result
                result[0] = status;
                result.notify();
                // MONITOREXIT : iStatusArray
                return;
            }
        };
        try {
            retrievalContainer.setConnectContextForAuthentication(context);
            retrievalContainer.sendRetrieveRequest(FileIDFactory.getDefault().createFileID(retrievalContainer.getRetrieveNamespace(), toDownload), listener, null);
        }
        catch (IncomingFileTransferException e) {
            IStatus status = e.getStatus();
            Throwable exception = status.getException();
            if (!(exception instanceof IOException)) return ECFTransport.statusOn(target, status);
            if (exception.getMessage() == null) return ECFTransport.statusOn(target, status);
            if (exception.getMessage().indexOf("401") != -1) throw ERROR_401;
            if (exception.getMessage().indexOf(SERVER_REDIRECT) == -1) return ECFTransport.statusOn(target, status);
            throw ERROR_401;
        }
        catch (FileCreateException e) {
            return ECFTransport.statusOn(target, e.getStatus());
        }
        IStatus[] iStatusArray = result;
        synchronized (result) {
            while (true) {
                if (result[0] != null) {
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    return ECFTransport.statusOn(target, result[0]);
                }
                boolean logged = false;
                try {
                    result.wait();
                }
                catch (InterruptedException e) {
                    if (logged) continue;
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", "Unexpected interrupt while waiting on ECF transfer", (Throwable)e));
                }
            }
        }
    }

    public IConnectContext getConnectionContext(String xmlLocation, boolean prompt) throws UserCancelledException, ProvisionException {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        IPath hostLocation = new Path(xmlLocation).removeLastSegments(1);
        String nodeName = "org.eclipse.equinox.p2.repository/" + hostLocation.toOSString().replace('/', '\\');
        ISecurePreferences prefNode = null;
        if (securePreferences.nodeExists(nodeName)) {
            prefNode = securePreferences.node(nodeName);
        }
        if (!prompt) {
            String password;
            String username;
            block16: {
                if (prefNode == null) {
                    return null;
                }
                try {
                    username = prefNode.get("username", null);
                    password = prefNode.get("password", null);
                    if (username != null && password != null) break block16;
                    return null;
                }
                catch (StorageException storageException) {
                    String msg = NLS.bind((String)Messages.repoMan_internalError, (Object)xmlLocation.toString());
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1, msg, null));
                }
            }
            return ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)password);
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker adminUITracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        adminUITracker.open();
        IServiceUI adminUIService = (IServiceUI)adminUITracker.getService();
        IServiceUI.AuthenticationInfo loginDetails = null;
        if (adminUIService != null) {
            loginDetails = adminUIService.getUsernamePassword(hostLocation.toString());
        }
        if (loginDetails == null) {
            throw new UserCancelledException();
        }
        if (loginDetails.saveResult()) {
            if (prefNode == null) {
                prefNode = securePreferences.node(nodeName);
            }
            try {
                prefNode.put("username", loginDetails.getUserName(), true);
                prefNode.put("password", loginDetails.getPassword(), true);
                prefNode.flush();
            }
            catch (StorageException storageException) {
                String msg = NLS.bind((String)Messages.repoMan_internalError, (Object)xmlLocation.toString());
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1, msg, null));
            }
            catch (IOException iOException) {
                String msg = NLS.bind((String)Messages.repoMan_internalError, (Object)xmlLocation.toString());
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1, msg, null));
            }
        }
        return ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
    }

    private static IStatus statusOn(OutputStream target, IStatus status) {
        if (target instanceof IStateful) {
            ((IStateful)((Object)target)).setStatus(status);
        }
        return status;
    }
}

