/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.ITag;

public class TableViewerAction
extends Action {
    private TableViewer viewer;

    public TableViewerAction(TableViewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        StructuredSelection selection;
        if (this.viewer.getSelection() instanceof StructuredSelection && !(selection = (StructuredSelection)this.viewer.getSelection()).isEmpty()) {
            Iterator selectionIter = selection.iterator();
            StringBuffer buf = new StringBuffer();
            ITag firstTag = (ITag)selectionIter.next();
            buf.append(firstTag.getName());
            while (selectionIter.hasNext()) {
                String tagName = ((ITag)selectionIter.next()).getName();
                buf.append(this.getLineSeparator()).append(tagName);
            }
            Clipboard clipboard = new Clipboard(Display.getDefault());
            Object[] data = new Object[]{buf.toString()};
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
            try {
                try {
                    clipboard.setContents(data, dataTypes);
                }
                catch (SWTError e) {
                    if (e.code != 2002) {
                        throw e;
                    }
                    clipboard.dispose();
                }
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private String getLineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\r\n";
        }
        return lineSeparator;
    }
}

