/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PasswordManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer viewer;
    private Button removeButton;
    private Button removeAllButton;

    public void init(IWorkbench workbench) {
        this.setDescription(CVSUIMessages.PasswordManagementPreferencePage_2);
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        parent.setLayoutData((Object)data);
        this.viewer = new TableViewer(parent, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PasswordManagementPreferencePage.this.handleSelection();
            }
        });
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setText(CVSUIMessages.PasswordManagementPreferencePage_3);
        columns[1].setText(CVSUIMessages.PasswordManagementPreferencePage_4);
        this.viewer.setColumnProperties(new String[]{"location", "username"});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                ICVSRepositoryLocation[] locations = ((KnownRepositories)inputElement).getRepositories();
                ArrayList<ICVSRepositoryLocation> repos = new ArrayList<ICVSRepositoryLocation>();
                int i = 0;
                while (i < locations.length) {
                    ICVSRepositoryLocation l = locations[i];
                    if (l.getUserInfoCached()) {
                        repos.add(l);
                    }
                    ++i;
                }
                return repos.toArray(new ICVSRepositoryLocation[repos.size()]);
            }
        });
        TableLayout tl = new TableLayout();
        Dialog.applyDialogFont((Control)ancestor);
        PixelConverter converter = new PixelConverter((Control)table);
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(70, converter.convertWidthInCharsToPixels(40)));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(30, converter.convertWidthInCharsToPixels(12)));
        table.setLayout((Layout)tl);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(CVSUIMessages.PasswordManagementPreferencePage_5);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PasswordManagementPreferencePage.this.remove();
            }
        });
        this.removeAllButton = new Button(buttons, 8);
        this.removeAllButton.setText(CVSUIMessages.PasswordManagementPreferencePage_6);
        this.removeAllButton.setEnabled(true);
        this.removeAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PasswordManagementPreferencePage.this.removeAll();
            }
        });
        int buttonWidth = SWTUtils.calculateControlSize((PixelConverter)SWTUtils.createDialogPixelConverter((Control)parent), (Control[])new Button[]{this.removeButton, this.removeAllButton});
        data = SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)0x1000008, (int)0x1000000, (boolean)false, (boolean)false);
        this.removeButton.setLayoutData((Object)data);
        this.removeAllButton.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)ancestor);
        this.viewer.setInput((Object)KnownRepositories.getInstance());
        this.handleSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.password_management_preference_page_context");
        return parent;
    }

    public boolean performOk() {
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private void remove() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            ICVSRepositoryLocation location = (ICVSRepositoryLocation)it.next();
            location.flushUserInfo();
        }
        this.viewer.refresh();
        this.handleSelection();
    }

    private void removeAll() {
        ICVSRepositoryLocation[] locations = KnownRepositories.getInstance().getRepositories();
        int i = 0;
        while (i < locations.length) {
            ICVSRepositoryLocation l = locations[i];
            if (l.getUserInfoCached()) {
                l.flushUserInfo();
            }
            ++i;
        }
        this.viewer.refresh();
        this.handleSelection();
    }

    private void handleSelection() {
        if (this.viewer.getTable().getSelectionCount() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        this.removeAllButton.setEnabled(this.viewer.getTable().getItemCount() > 0);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ICVSRepositoryLocation entry = (ICVSRepositoryLocation)element;
            switch (columnIndex) {
                case 0: {
                    return entry.toString();
                }
                case 1: {
                    return entry.getUsername();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

