/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.view;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.model.MutationSession;
import pl.poznan.put.qjunit.view.MutationsView;

public abstract class OpenEditorAction
extends Action {
    protected String fClassName;
    protected MutationsView fMutationsView;
    private final boolean fActivate;

    protected OpenEditorAction(MutationsView mutationsView, String testClassName) {
        this(mutationsView, testClassName, true);
    }

    public OpenEditorAction(MutationsView mutationsView, String className, boolean activate) {
        super("Open Editor");
        this.fClassName = className;
        this.fMutationsView = mutationsView;
        this.fActivate = activate;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IJavaElement element = this.findElement(this.getLaunchedProject(), this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Cannot open editor", (String)"Test class not found in selected project");
                return;
            }
            textEditor = (ITextEditor)JavaUI.openInEditor((IJavaElement)element, (boolean)this.fActivate, (boolean)false);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Cannot open editor", (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fMutationsView.registerInfoMessage("Cannot open editor");
            return;
        }
        this.reveal(textEditor);
    }

    protected Shell getShell() {
        return this.fMutationsView.getSite().getShell();
    }

    protected IJavaProject getLaunchedProject() {
        MutationSession session = Activator.getMutationModel().getMutationSession();
        if (session != null) {
            return session.getJavaProject();
        }
        return null;
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected abstract IJavaElement findElement(IJavaProject var1, String var2) throws CoreException;

    protected abstract void reveal(ITextEditor var1);

    protected final IType findType(final IJavaProject project, String className) throws JavaModelException {
        final IType[] result = new IType[1];
        final String dottedName = className.replace('$', '.');
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (project == null) {
                            int lastDot = dottedName.lastIndexOf(46);
                            TypeNameMatchRequestor nameMatchRequestor = new TypeNameMatchRequestor(){

                                public void acceptTypeNameMatch(TypeNameMatch match) {
                                    result[0] = match.getType();
                                }
                            };
                            new SearchEngine().searchAllTypeNames(lastDot >= 0 ? dottedName.substring(0, lastDot).toCharArray() : null, 8, (lastDot >= 0 ? dottedName.substring(lastDot + 1) : dottedName).toCharArray(), 8, 0, SearchEngine.createWorkspaceScope(), nameMatchRequestor, 3, monitor);
                        } else {
                            result[0] = OpenEditorAction.this.internalFindType(project, dottedName, new HashSet(), monitor);
                        }
                    }
                    catch (JavaModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IType internalFindType(IJavaProject project, String className, Set visitedProjects, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (visitedProjects.contains(project)) {
                return null;
            }
            monitor.beginTask("", 2);
            IType type = project.findType(className, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (type != null) {
                IType iType = type;
                return iType;
            }
            visitedProjects.add(project);
            IJavaModel javaModel = project.getJavaModel();
            String[] requiredProjectNames = project.getRequiredProjectNames();
            SubProgressMonitor reqMonitor = new SubProgressMonitor(monitor, 1);
            reqMonitor.beginTask("", requiredProjectNames.length);
            int i = 0;
            while (i < requiredProjectNames.length) {
                IJavaProject requiredProject = javaModel.getJavaProject(requiredProjectNames[i]);
                if (requiredProject.exists() && (type = this.internalFindType(requiredProject, className, visitedProjects, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)reqMonitor, 1))) != null) {
                    IType iType = type;
                    return iType;
                }
                ++i;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }
}

