/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.view;

import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.SharedImages;
import pl.poznan.put.qjunit.model.ComplexResponse;
import pl.poznan.put.qjunit.model.MutationElement;
import pl.poznan.put.qjunit.model.MutationOperator;
import pl.poznan.put.qjunit.model.MutationResult;
import pl.poznan.put.qjunit.model.MutationSession;
import pl.poznan.put.qjunit.model.TestCaseAdapter;

public class MutationsViewLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private IMemento fMemento;

    public MutationsViewLabelProvider(IMemento memento) {
        this.fMemento = memento;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof ITestSuiteElement) {
            ITestElement.Result result = ((ITestSuiteElement)element).getTestResult(true);
            if (result.equals(ITestElement.Result.ERROR)) {
                return SharedImages.getImage("/icons/full/obj16/tsuiteerr.gif");
            }
            if (result.equals(ITestElement.Result.FAILURE)) {
                return SharedImages.getImage("/icons/full/obj16/tsuitefail.gif");
            }
            if (result.equals(ITestElement.Result.OK)) {
                return SharedImages.getImage("/icons/full/obj16/tsuiteok.gif");
            }
        }
        if (element instanceof ITestCaseElement) {
            ITestCaseElement tc = (ITestCaseElement)element;
            MutationSession session = Activator.getMutationModel().getMutationSession();
            if (session != null) {
                element = session.getTestCaseAdapter(tc.getTestClassName(), tc.getTestMethodName());
            }
        }
        if (element instanceof TestCaseAdapter) {
            TestCaseAdapter tca = (TestCaseAdapter)element;
            if (tca.getMutationsAlive() > 0) {
                return SharedImages.getImage("/icons/full/obj16/mutationfail.gif");
            }
            return SharedImages.getImage("/icons/full/obj16/mutationok.gif");
        }
        if (element instanceof MutationElement) {
            MutationElement mutationElement = (MutationElement)element;
            if (mutationElement.getResultsAlive() > 0) {
                return SharedImages.getImage("/icons/full/obj16/mutationfail.gif");
            }
            return SharedImages.getImage("/icons/full/obj16/mutationok.gif");
        }
        if (element instanceof MutationResult) {
            MutationResult mutationResult = (MutationResult)element;
            String result = mutationResult.getResult();
            if (result.equals("error")) {
                return SharedImages.getImage("/icons/full/obj16/testerr.gif");
            }
            if (result.equals("failure")) {
                return SharedImages.getImage("/icons/full/obj16/testfail.gif");
            }
            if (result.equals("ok")) {
                return SharedImages.getImage("/icons/full/obj16/testok.gif");
            }
        }
        if (element instanceof ComplexResponse) {
            return SharedImages.getImage("/icons/full/obj16/field_obj.gif");
        }
        if (element.getClass().getName().startsWith("java.lang")) {
            return SharedImages.getImage("/icons/full/obj16/field_obj.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object result;
        if (element instanceof MutationOperator) {
            MutationOperator oper = (MutationOperator)element;
            switch (columnIndex) {
                case 0: {
                    return oper.getName();
                }
                case 1: {
                    return String.valueOf(oper.getAliveCount()) + " / " + oper.getResultsCount();
                }
            }
        }
        if (element instanceof ITestSuiteElement) {
            ITestSuiteElement tec = (ITestSuiteElement)element;
            return columnIndex == 0 ? tec.getSuiteTypeName() : "";
        }
        if (element instanceof ITestCaseElement) {
            ITestCaseElement tce = (ITestCaseElement)element;
            MutationSession session = Activator.getMutationModel().getMutationSession();
            if (session == null) {
                return "";
            }
            element = session.getTestCaseAdapter(tce.getTestClassName(), tce.getTestMethodName());
        }
        if (element instanceof TestCaseAdapter) {
            TestCaseAdapter tca = (TestCaseAdapter)element;
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(tca.getClassName()) + "." + tca.getMethodName();
                }
                case 1: {
                    return String.valueOf(tca.getMutationsAlive()) + " / " + tca.getMutationsCount();
                }
            }
            return "";
        }
        if (element instanceof MutationElement) {
            MutationElement mutation = (MutationElement)element;
            switch (columnIndex) {
                case 0: {
                    return mutation.getSignature();
                }
                case 1: {
                    return String.valueOf(mutation.getResultsAlive()) + " / " + mutation.getResults().length;
                }
            }
            return "";
        }
        if (element instanceof MutationResult) {
            result = (MutationResult)element;
            if (columnIndex == 0) {
                if (((MutationResult)result).getResponse() instanceof ComplexResponse) {
                    return ((ComplexResponse)((MutationResult)result).getResponse()).getType();
                }
                return "Response = " + ((MutationResult)result).getResponse();
            }
            if (columnIndex == 2) {
                return ((MutationResult)result).getGenerator();
            }
        }
        if (element instanceof ComplexResponse) {
            result = (ComplexResponse)element;
            if (columnIndex == 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(((ComplexResponse)result).getName());
                if (((ComplexResponse)result).getType().startsWith("java.lang")) {
                    sb.append(" = ");
                    sb.append(((ComplexResponse)result).getValue());
                } else {
                    sb.append(" : ");
                    sb.append(((ComplexResponse)result).getType());
                }
                return sb.toString();
            }
            return "";
        }
        if (columnIndex == 0) {
            return element == null ? "" : element.toString();
        }
        return "";
    }
}

