/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.view;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.junit.ui.TestViewer;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;
import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.model.MutationElement;
import pl.poznan.put.qjunit.model.MutationOperator;
import pl.poznan.put.qjunit.model.MutationResult;
import pl.poznan.put.qjunit.model.MutationSession;
import pl.poznan.put.qjunit.model.TestCaseAdapter;
import pl.poznan.put.qjunit.view.MutationsViewContentProvider;
import pl.poznan.put.qjunit.view.MutationsViewLabelProvider;
import pl.poznan.put.qjunit.view.OpenTestAction;

public class MutationsView
extends ViewPart {
    public static final String ID = "pl.poznan.put.qjunit.view";
    public static final String SHOW_CONTENT = "show_content";
    public static final String CONTENT_DETAILS = "details";
    public static final String CONTENT_SUMMARY = "summary";
    public static final String CONTENT_OPERATORS = "operators";
    public static final String FILTER_DEAD = "filter_dead";
    private ISelectionChangedListener junitViewListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            MutationsView.this.showDetails(selection);
        }
    };
    private TestRunListener testRunListener = new TestRunListener(){

        private void updateInUIThread() {
            MutationsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MutationsView.this.updateContents();
                }
            });
        }

        public void sessionFinished(ITestRunSession session) {
            this.updateInUIThread();
        }

        public void sessionStarted(ITestRunSession session) {
            this.updateInUIThread();
        }
    };
    private ViewerFilter deadMutantsFilter = new DeadMutantsFilter();
    private TreeViewer fViewer;
    private IAction showSummaryAction;
    private IAction showTestDetailsAction;
    private IAction showOperatorsAction;
    private IAction filterDeadMutantsAction;
    private IMemento fMemento;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)ID);
        }
        this.fMemento = memento;
        this.readSettings();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.writeSettings();
        memento.putMemento(memento);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        this.fViewer = new TreeViewer(composite, 516);
        Tree tree = this.fViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MutationsViewLabelProvider(this.fMemento));
        this.fViewer.setContentProvider((IContentProvider)new MutationsViewContentProvider());
        TreeColumn tc = new TreeColumn(tree, 16384);
        tc.setMoveable(true);
        tc.setResizable(true);
        tc.setText("Test Case");
        tc.setWidth(250);
        tc = new TreeColumn(tree, 16384);
        tc.setMoveable(true);
        tc.setResizable(true);
        tc.setText("Alive");
        tree.setHeaderVisible(true);
        tc.setWidth(50);
        tc = new TreeColumn(tree, 16384);
        tc.setMoveable(true);
        tc.setResizable(true);
        tc.setText("Name");
        tree.setHeaderVisible(true);
        tc.setWidth(50);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    MutationsView.this.openSelection(selection.getFirstElement());
                }
            }
        });
        this.updateFilters();
        this.makeActions();
        this.hookMenuActions();
        JUnitCore.addTestRunListener((TestRunListener)this.testRunListener);
        this.updateContents();
    }

    protected void updateFilters() {
        if (Boolean.valueOf(this.fMemento.getString(FILTER_DEAD)).booleanValue()) {
            this.fViewer.addFilter(this.deadMutantsFilter);
        } else {
            this.fViewer.removeFilter(this.deadMutantsFilter);
        }
    }

    protected void makeActions() {
        this.showSummaryAction = new Action("Mutations summary", 8){

            public void run() {
                MutationsView.this.fMemento.putString(MutationsView.SHOW_CONTENT, MutationsView.CONTENT_SUMMARY);
                MutationsView.this.showSummary();
            }
        };
        this.showSummaryAction.setToolTipText("Enables all mutations summary report");
        this.showSummaryAction.setChecked(CONTENT_SUMMARY.equals(this.fMemento.getString(SHOW_CONTENT)));
        this.showTestDetailsAction = new Action("Mutation details", 8){

            public void run() {
                MutationsView.this.fMemento.putString(MutationsView.SHOW_CONTENT, MutationsView.CONTENT_DETAILS);
                TreeViewer junit = MutationsView.this.getJUnitTreeViewer(true);
                MutationsView.this.showDetails((IStructuredSelection)junit.getSelection());
            }
        };
        this.showTestDetailsAction.setToolTipText("Enables mutation details for currently selected test");
        this.showTestDetailsAction.setChecked(CONTENT_DETAILS.equals(this.fMemento.getString(SHOW_CONTENT)));
        this.showOperatorsAction = new Action("Operators summary", 8){

            public void run() {
                MutationsView.this.fMemento.putString(MutationsView.SHOW_CONTENT, MutationsView.CONTENT_OPERATORS);
                MutationsView.this.showOperators();
            }
        };
        this.showOperatorsAction.setToolTipText("Switch to operators details");
        this.showOperatorsAction.setChecked(CONTENT_OPERATORS.equals(this.fMemento.getString(SHOW_CONTENT)));
        this.filterDeadMutantsAction = new Action("Failures only", 2){

            public void run() {
                MutationsView.this.fMemento.putString(MutationsView.FILTER_DEAD, Boolean.toString(MutationsView.this.filterDeadMutantsAction.isChecked()));
                MutationsView.this.updateFilters();
            }
        };
        this.filterDeadMutantsAction.setToolTipText("Filters out killer tests, leaving suspected ones.");
        this.filterDeadMutantsAction.setChecked(Boolean.valueOf(this.fMemento.getString(FILTER_DEAD)).booleanValue());
    }

    protected void hookMenuActions() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add(this.showSummaryAction);
        mgr.add(this.showTestDetailsAction);
        mgr.add(this.showOperatorsAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.filterDeadMutantsAction);
    }

    protected void showDetails(IStructuredSelection selection) {
        if (!CONTENT_DETAILS.equals(this.fMemento.getString(SHOW_CONTENT))) {
            return;
        }
        if (selection.isEmpty()) {
            this.fViewer.setInput(null);
        } else {
            this.fViewer.setInput((Object)selection.toArray());
        }
        MutationSession session = Activator.getMutationModel().getMutationSession();
        if (session != null) {
            Object[] elements = selection.toArray();
            int count = 0;
            int alive = 0;
            int i = 0;
            while (i < elements.length) {
                TestCaseElement tce;
                TestCaseAdapter adapter;
                if (elements[i] instanceof TestCaseElement && (adapter = session.getTestCaseAdapter((tce = (TestCaseElement)elements[i]).getTestClassName(), tce.getTestMethodName())) != null) {
                    count += adapter.getMutationsCount();
                    alive += adapter.getMutationsAlive();
                }
                ++i;
            }
            this.setContentDescription(String.valueOf(alive) + " out of total " + count + " responses are alive");
        } else {
            this.setContentDescription("");
        }
    }

    protected void updateContents() {
        if (CONTENT_DETAILS.equals(this.fMemento.getString(SHOW_CONTENT))) {
            TreeViewer viewer = this.getJUnitTreeViewer(false);
            if (viewer != null) {
                this.showDetails((IStructuredSelection)viewer.getSelection());
            }
        } else if (CONTENT_OPERATORS.equals(this.fMemento.getString(SHOW_CONTENT))) {
            this.showOperators();
        } else {
            this.showSummary();
        }
    }

    protected void showOperators() {
        if (!CONTENT_OPERATORS.equals(this.fMemento.getString(SHOW_CONTENT))) {
            return;
        }
        MutationSession session = Activator.getMutationModel().getMutationSession();
        if (session != null) {
            MutationOperator[] operators = session.getOperators();
            this.fViewer.setInput((Object)operators);
            this.setContentDescription("Total " + operators.length + " operators used");
        } else {
            this.setContentDescription("");
        }
    }

    protected void showSummary() {
        if (!CONTENT_SUMMARY.equals(this.fMemento.getString(SHOW_CONTENT))) {
            return;
        }
        this.fViewer.setInput((Object)Activator.getMutationModel());
        MutationSession session = Activator.getMutationModel().getMutationSession();
        if (session != null) {
            int count = session.getMutationsCount();
            int alive = session.getMutationsAlive();
            this.setContentDescription(String.valueOf(alive) + " out of total " + count + " responses are alive");
        } else {
            this.setContentDescription("");
        }
    }

    protected void openSelection(Object object) {
        Object element;
        String className = null;
        String methodName = null;
        int line = 0;
        if (object instanceof ITestSuiteElement) {
            element = (ITestSuiteElement)object;
            className = element.getSuiteTypeName();
        }
        if (object instanceof ITestCaseElement) {
            element = (ITestCaseElement)object;
            className = element.getTestClassName();
            methodName = element.getTestMethodName();
        }
        if (object instanceof TestCaseAdapter) {
            element = (TestCaseAdapter)object;
            className = ((TestCaseAdapter)element).getClassName();
            methodName = ((TestCaseAdapter)element).getMethodName();
        }
        if (object instanceof MutationResult) {
            object = ((MutationResult)object).getParent();
        }
        if (object instanceof MutationElement) {
            MutationElement result = (MutationElement)object;
            line = result.getLine();
            className = result.getClassName();
            methodName = result.getMethodName();
        }
        if (className == null) {
            return;
        }
        OpenTestAction action = new OpenTestAction(this, className, methodName, line);
        if (action.isEnabled()) {
            action.run();
        }
    }

    protected TreeViewer getJUnitTreeViewer(boolean force) {
        TestRunnerViewPart junitView;
        TestViewer viewer;
        IViewPart view = this.getSite().getPage().findView("org.eclipse.jdt.junit.ResultView");
        if (view == null && !force) {
            return null;
        }
        if (view == null) {
            try {
                view = this.getSite().getPage().showView("org.eclipse.jdt.junit.ResultView");
            }
            catch (PartInitException e) {
                Activator.log(e);
                return null;
            }
        }
        if ((viewer = (TestViewer)MutationsView.getField(junitView = (TestRunnerViewPart)view, "fTestViewer")) == null) {
            return null;
        }
        return (TreeViewer)MutationsView.getField(viewer, "fTreeViewer");
    }

    private static Object getField(Object object, String name) {
        try {
            Field field = object.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (SecurityException e) {
            Activator.log(e);
        }
        catch (NoSuchFieldException e) {
            Activator.log(e);
        }
        catch (IllegalArgumentException e) {
            Activator.log(e);
        }
        catch (IllegalAccessException e) {
            Activator.log(e);
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.writeSettings();
        TreeViewer junitViewer = this.getJUnitTreeViewer(false);
        if (junitViewer != null) {
            junitViewer.removeSelectionChangedListener(this.junitViewListener);
        }
        JUnitCore.removeTestRunListener((TestRunListener)this.testRunListener);
    }

    public void setFocus() {
        TreeViewer junitViewer = this.getJUnitTreeViewer(true);
        if (junitViewer != null) {
            junitViewer.addSelectionChangedListener(this.junitViewListener);
        }
    }

    public void registerInfoMessage(String message) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected void readSettings() {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        prefs.setDefault(SHOW_CONTENT, CONTENT_SUMMARY);
        prefs.setDefault(FILTER_DEAD, Boolean.FALSE.toString());
        this.fMemento.putString(SHOW_CONTENT, prefs.getString(SHOW_CONTENT));
        this.fMemento.putString(FILTER_DEAD, prefs.getString(FILTER_DEAD));
    }

    protected void writeSettings() {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        prefs.setValue(SHOW_CONTENT, this.fMemento.getString(SHOW_CONTENT));
        prefs.setValue(FILTER_DEAD, this.fMemento.getString(FILTER_DEAD));
    }

    public static class DeadMutantsFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof MutationResult) {
                return "ok".equals(((MutationResult)element).getResult());
            }
            if (element instanceof MutationElement) {
                MutationElement mutationElement = (MutationElement)element;
                return mutationElement.getResults().length > 0 && mutationElement.getResultsAlive() > 0;
            }
            if (element instanceof ITestCaseElement) {
                ITestCaseElement tc = (ITestCaseElement)element;
                MutationSession session = Activator.getMutationModel().getMutationSession();
                element = session.getTestCaseAdapter(tc.getTestClassName(), tc.getTestMethodName());
            }
            if (element instanceof TestCaseAdapter) {
                TestCaseAdapter tca = (TestCaseAdapter)element;
                return tca.getMutationsCount() > 0 && tca.getMutationsAlive() > 0;
            }
            return true;
        }
    }
}

