/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.core.IJavaProject;
import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.model.MutationElement;
import pl.poznan.put.qjunit.model.MutationOperator;
import pl.poznan.put.qjunit.model.MutationResult;
import pl.poznan.put.qjunit.model.ObjectDeserializer;
import pl.poznan.put.qjunit.model.TestCaseAdapter;

public class MutationSession {
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private BufferedReader fBufferedReader;
    private IJavaProject fJavaProject;
    private ObjectDeserializer deserializer;
    private List fMutationElements = new ArrayList();
    private Map operators = new HashMap();

    public MutationSession(ILaunch launch, IJavaProject javaProject, int port) {
        this.fJavaProject = javaProject;
        this.deserializer = new ObjectDeserializer();
        ServerConnection connection = new ServerConnection(port);
        connection.start();
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    private void receiveMessage(String message) {
        MutationElement element;
        StringTokenizer st = new StringTokenizer(message, ";");
        String testClass = null;
        String testName = null;
        int responseType = -1;
        try {
            testClass = new String(st.nextToken());
            testName = new String(st.nextToken());
            element = new MutationElement(testClass, testName);
            responseType = Integer.parseInt(st.nextToken());
            element.setResponseType(responseType);
            element.setFileName(new String(st.nextToken()));
            element.setLine(Integer.parseInt(st.nextToken()));
            element.setSignature(new String(st.nextToken()));
            String[] learnedStrings = this.readArray(st);
            Object[] learned = new Object[learnedStrings.length];
            int i = 0;
            while (i < learnedStrings.length) {
                learned[i] = this.deserializer.create("learned", learnedStrings[i], responseType);
                ++i;
            }
            element.setLearned(learned);
        }
        catch (RuntimeException e) {
            Activator.log("Error parsing message=" + message, e);
            return;
        }
        try {
            String[] generators = this.readArray(st);
            String[] generated = this.readArray(st);
            String[] results = this.readArray(st);
            String[] resultMessages = this.readArray(st);
            long[] timings = this.readLongArray(st);
            MutationResult[] mutationResults = new MutationResult[generated.length];
            int i = 0;
            while (i < mutationResults.length) {
                Object resp = this.deserializer.create("response", generated[i], responseType);
                mutationResults[i] = new MutationResult(element, generators[i], resp, results[i], resultMessages[i], timings[i]);
                this.updateOperator(generators[i], mutationResults[i]);
                ++i;
            }
            element.setResults(mutationResults);
        }
        catch (RuntimeException e) {
            Activator.log(e);
        }
        st = null;
        TestCaseAdapter tc = this.getTestCaseAdapter(testClass, testName);
        tc.put(element);
    }

    private void updateOperator(String operator, MutationResult mutationResult) {
        MutationOperator oper = (MutationOperator)this.operators.get(operator);
        if (oper == null) {
            oper = new MutationOperator(operator);
            this.operators.put(operator, oper);
        }
        oper.addResult(mutationResult);
    }

    private String[] readArray(StringTokenizer st) {
        int count = 0;
        try {
            count = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            Activator.log(e);
        }
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = new String(st.nextToken());
            ++i;
        }
        return result;
    }

    private long[] readLongArray(StringTokenizer st) {
        int count = 0;
        try {
            count = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            Activator.log(e);
        }
        long[] result = new long[count];
        int i = 0;
        while (i < count) {
            result[i] = Long.parseLong(st.nextToken());
            ++i;
        }
        return result;
    }

    private synchronized void shutDown() {
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    public TestCaseAdapter getTestCaseAdapter(String className, String methodName) {
        TestCaseAdapter tmp = new TestCaseAdapter(className, methodName);
        int i = this.fMutationElements.indexOf(tmp);
        if (i == -1) {
            this.fMutationElements.add(tmp);
        } else {
            tmp = (TestCaseAdapter)this.fMutationElements.get(i);
        }
        return tmp;
    }

    public TestCaseAdapter[] getTestCases() {
        return this.fMutationElements.toArray(new TestCaseAdapter[this.fMutationElements.size()]);
    }

    public MutationOperator[] getOperators() {
        Collection allOperators = this.operators.values();
        return allOperators.toArray(new MutationOperator[allOperators.size()]);
    }

    public int getMutationsCount() {
        int count = 0;
        Iterator i = this.fMutationElements.iterator();
        while (i.hasNext()) {
            count += ((TestCaseAdapter)i.next()).getMutationsCount();
        }
        return count;
    }

    public int getMutationsAlive() {
        int count = 0;
        Iterator i = this.fMutationElements.iterator();
        while (i.hasNext()) {
            count += ((TestCaseAdapter)i.next()).getMutationsAlive();
        }
        return count;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    private class ServerConnection
    extends Thread {
        int fServerPort;

        public ServerConnection(int port) {
            super("ServerConnection");
            this.fServerPort = port;
        }

        public void run() {
            try {
                String message;
                MutationSession.this.fServerSocket = new ServerSocket(this.fServerPort);
                MutationSession.this.fSocket = MutationSession.this.fServerSocket.accept();
                try {
                    MutationSession.this.fBufferedReader = new BufferedReader(new InputStreamReader(MutationSession.this.fSocket.getInputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MutationSession.this.fBufferedReader = new BufferedReader(new InputStreamReader(MutationSession.this.fSocket.getInputStream()));
                }
                while (MutationSession.this.fBufferedReader != null && (message = MutationSession.this.readMessage(MutationSession.this.fBufferedReader)) != null) {
                    MutationSession.this.receiveMessage(message);
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException e) {
                Activator.log(e);
            }
            MutationSession.this.shutDown();
        }
    }
}

