/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.model;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.core.InstrumentationHelper;
import pl.poznan.put.qjunit.model.MutationSession;
import pl.poznan.put.qjunit.view.MutationsView;

public class MutationModel {
    private ILaunchListener fLaunchListener = new LaunchListener();
    private MutationSession fMutationSession;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();

    public void start() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fLaunchListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener);
    }

    public void stop() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
    }

    public MutationSession getMutationSession() {
        return this.fMutationSession;
    }

    private class LaunchListener
    implements ILaunchListener {
        private HashSet fTrackedLaunches = new HashSet(20);

        private LaunchListener() {
        }

        public void launchAdded(ILaunch launch) {
            this.fTrackedLaunches.add(launch);
        }

        public void launchRemoved(ILaunch launch) {
            this.fTrackedLaunches.remove(launch);
        }

        public void launchChanged(final ILaunch launch) {
            if (!this.fTrackedLaunches.contains(launch)) {
                return;
            }
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config == null) {
                return;
            }
            final IJavaProject javaProject = JUnitLaunchConfigurationConstants.getJavaProject((ILaunchConfiguration)config);
            if (javaProject == null) {
                return;
            }
            String portStr = launch.getAttribute("pl.poznan.put.qjunit.PORT");
            if (portStr == null) {
                return;
            }
            try {
                final int port = Integer.parseInt(portStr);
                this.fTrackedLaunches.remove(launch);
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        LaunchListener.this.connectTestRunner(launch, javaProject, port);
                    }
                });
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }

        private void connectTestRunner(ILaunch launch, IJavaProject javaProject, int port) {
            this.showMutationsView();
            MutationModel.this.fMutationSession = new MutationSession(launch, javaProject, port);
        }

        private MutationsView showMutationsView() {
            IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            try {
                return (MutationsView)page.showView("pl.poznan.put.qjunit.view");
            }
            catch (PartInitException e) {
                Activator.log(e);
                return null;
            }
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            return display;
        }
    }

    private static class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();

        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this.visitor);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    private static class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource == null) {
                return true;
            }
            IProject project = resource.getProject();
            if (project == null) {
                return true;
            }
            InstrumentationHelper.removeInstrumentation(project.getName());
            return false;
        }
    }
}

