/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.core;

import java.io.File;
import java.util.ArrayList;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.bridge.IMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.ajcompiler.BuildMessageHandler;
import pl.poznan.put.qjunit.ajcompiler.BuildProgressMonitor;
import pl.poznan.put.qjunit.ajcompiler.CompilerConfiguration;
import pl.poznan.put.qjunit.core.FileUtils;

public class InstrumentationHelper {
    protected static boolean hasInstrumentation(String projectName) {
        String outPath = InstrumentationHelper.getWovenBinPath(projectName);
        File file = new File(outPath);
        return file.exists();
    }

    public static void removeInstrumentation(String projectName) {
        String outPath = InstrumentationHelper.getWovenBinPath(projectName);
        File file = new File(outPath);
        InstrumentationHelper.delete(file);
    }

    public static String getInstrumentedPath(ILaunchConfiguration configuration, String inPath, String[] classpath, String projectName) throws CoreException {
        String outPath = InstrumentationHelper.getWovenBinPath(projectName);
        if (!InstrumentationHelper.hasInstrumentation(projectName)) {
            InstrumentationHelper.prepareDir(outPath);
            classpath = InstrumentationHelper.prepareCompilerClasspath(configuration, classpath);
            InstrumentationHelper.weaveAspects(inPath, classpath, outPath);
        }
        return outPath;
    }

    protected static String weaveAspects(String inPath, String[] classpath, String outPath) throws CoreException {
        String aspectPath = FileUtils.getBundleJarPath("pl.poznan.put.qjunit.runtime.interceptor", null);
        BuildMessageHandler buildMessageHandler = new BuildMessageHandler();
        BuildProgressMonitor buildProgressMonitor = new BuildProgressMonitor();
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration(inPath, classpath, aspectPath, outPath);
        AjCompiler compiler = new AjCompiler(outPath, (ICompilerConfiguration)compilerConfiguration, (IBuildProgressMonitor)buildProgressMonitor, (IBuildMessageHandler)buildMessageHandler);
        compiler.buildFresh();
        compiler.clearLastState();
        if (buildMessageHandler.hasErrors()) {
            IMessage[] ms = buildMessageHandler.getMessages();
            ArrayList<Status> errors = new ArrayList<Status>();
            int i = 0;
            while (i < ms.length) {
                if (!ms[i].getKind().isSameOrLessThan(IMessage.WARNING)) {
                    errors.add(new Status(4, "pl.poznan.put.qjunit", ms[i].getMessage(), ms[i].getThrown()));
                }
                ++i;
            }
            if (errors.size() > 1) {
                throw new CoreException((IStatus)new MultiStatus("pl.poznan.put.qjunit", 0, errors.toArray(new IStatus[errors.size()]), "Multiple errors during tests instrumentation", null));
            }
            if (errors.size() == 1) {
                throw new CoreException((IStatus)errors.get(0));
            }
        }
        return outPath;
    }

    protected static String[] prepareCompilerClasspath(ILaunchConfiguration configuration, String[] classpath) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < entries.length) {
            list.add(entries[i].getLocation());
            ++i;
        }
        list.add(FileUtils.getBundleJarPath("org.aspectj.runtime", "/aspectjrt.jar"));
        list.add(FileUtils.getBundleJarPath("pl.poznan.put.qjunit.runtime.interceptor", null));
        return list.toArray(new String[list.size()]);
    }

    private static boolean prepareDir(String pathname) {
        File f = new File(pathname);
        if (!f.exists()) {
            return f.mkdirs();
        }
        if (f.isDirectory()) {
            return InstrumentationHelper.delete(f);
        }
        f.delete();
        return f.mkdir();
    }

    private static boolean delete(File f) {
        String[] list = f.list();
        if (f.isDirectory()) {
            int i = 0;
            while (i < list.length) {
                InstrumentationHelper.delete(new File(f, list[i]));
                ++i;
            }
        }
        return f.delete();
    }

    protected static String getWovenBinPath(String projectName) {
        IPath path = Activator.getDefault().getStateLocation();
        return String.valueOf(path.toOSString()) + "/bin/" + projectName;
    }
}

