/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.ajcompiler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.eclipse.core.runtime.Path;
import pl.poznan.put.qjunit.ajcompiler.OutLocationManager;
import pl.poznan.put.qjunit.core.FileUtils;

public class CompilerConfiguration
implements ICompilerConfiguration {
    private Set inPath;
    private Map resourcesPath;
    private String[] classpath;
    private File aspectPath;
    private IOutputLocationManager outPath;

    public CompilerConfiguration(String inPath, String[] classpath, String aspectPath, String outPath) {
        this.classpath = classpath;
        this.aspectPath = new File(aspectPath);
        this.outPath = new OutLocationManager(outPath);
        this.inPath = Collections.singleton(new File(inPath));
        Path path = new Path(inPath);
        Set inFiles = FileUtils.findFiles(inPath);
        this.resourcesPath = new HashMap();
        for (Path f : inFiles) {
            if ("class".equals(f.getFileExtension())) continue;
            String key = f.removeFirstSegments(path.segmentCount()).setDevice(null).toOSString();
            this.resourcesPath.put(key, f.toFile());
        }
    }

    public Set getAspectPath() {
        return Collections.singleton(this.aspectPath);
    }

    public Set getInpath() {
        return this.inPath;
    }

    public Map getJavaOptionsMap() {
        return Collections.EMPTY_MAP;
    }

    public String getNonStandardOptions() {
        return "-showWeaveInfo -verbose";
    }

    public String getOutJar() {
        return null;
    }

    public IOutputLocationManager getOutputLocationManager() {
        return this.outPath;
    }

    public List getProjectSourceFiles() {
        return Collections.EMPTY_LIST;
    }

    public Map getSourcePathResources() {
        return this.resourcesPath;
    }

    public String getClasspath() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.classpath.length) {
            sb.append(this.classpath[i]);
            if (i < this.classpath.length - 1) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }
}

