/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.jarpackager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.swt.widgets.Shell;

public class JarWriter2 {
    private JarOutputStream fJarOutputStream;
    private JarPackageData fJarPackage;
    private Set fDirectories = new HashSet();

    public JarWriter2(JarPackageData jarPackage, Shell parent) throws CoreException {
        Assert.isNotNull((Object)jarPackage, (String)"The JAR specification is null");
        this.fJarPackage = jarPackage;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The JAR package specification is invalid");
        if (!this.canCreateJar(parent)) {
            throw new OperationCanceledException();
        }
        try {
            if (this.fJarPackage.usesManifest() && this.fJarPackage.areGeneratedFilesExported()) {
                Manifest manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                this.fJarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toFile()), manifest);
            } else {
                this.fJarOutputStream = new JarOutputStream(new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toFile()));
            }
            String comment = jarPackage.getComment();
            if (comment != null) {
                this.fJarOutputStream.setComment(comment);
            }
        }
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    public void close() throws CoreException {
        if (this.fJarOutputStream != null) {
            try {
                this.fJarOutputStream.close();
                this.registerInWorkspaceIfNeeded();
            }
            catch (IOException ex) {
                throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    public void write(IFile resource, IPath destinationPath) throws CoreException {
        try {
            IPath fileLocation = resource.getLocation();
            File file = null;
            if (fileLocation != null) {
                file = fileLocation.toFile();
            }
            if (this.fJarPackage.areDirectoryEntriesIncluded()) {
                this.addDirectories(destinationPath, file);
            }
            this.addFile(resource, destinationPath, file);
        }
        catch (IOException ex) {
            String message = null;
            message = ex.getLocalizedMessage() != null ? Messages.format(JarPackagerMessages.JarWriter_writeProblemWithMessage, new Object[]{BasicElementLabels.getPathLabel(resource.getFullPath(), false), ex.getLocalizedMessage()}) : Messages.format(JarPackagerMessages.JarWriter_writeProblem, resource.getFullPath());
            throw JarPackagerUtil.createCoreException(message, ex);
        }
    }

    protected void addFile(IFile resource, IPath path, File correspondingFile) throws IOException, CoreException {
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        byte[] readBuffer = new byte[4096];
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            this.calculateCrcAndSize(newEntry, resource, readBuffer);
        }
        long lastModified = correspondingFile != null && correspondingFile.exists() ? correspondingFile.lastModified() : System.currentTimeMillis();
        newEntry.setTime(lastModified);
        InputStream contentStream = resource.getContents(false);
        try {
            int count;
            this.fJarOutputStream.putNextEntry(newEntry);
            while ((count = contentStream.read(readBuffer, 0, readBuffer.length)) != -1) {
                this.fJarOutputStream.write(readBuffer, 0, count);
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
    }

    private void calculateCrcAndSize(JarEntry jarEntry, IFile resource, byte[] readBuffer) throws IOException, CoreException {
        InputStream contentStream = resource.getContents(false);
        int size = 0;
        CRC32 checksumCalculator = new CRC32();
        try {
            int count;
            while ((count = contentStream.read(readBuffer, 0, readBuffer.length)) != -1) {
                checksumCalculator.update(readBuffer, 0, count);
                size += count;
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
        jarEntry.setSize(size);
        jarEntry.setCrc(checksumCalculator.getValue());
    }

    protected void addDirectories(IPath destinationPath, File correspondingFile) throws IOException {
        String path = destinationPath.toString().replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> directories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            if (!this.fDirectories.add(path = path.substring(0, lastSlash + 1))) break;
            if (correspondingFile != null) {
                correspondingFile = correspondingFile.getParentFile();
            }
            long timeStamp = correspondingFile != null && correspondingFile.exists() ? correspondingFile.lastModified() : System.currentTimeMillis();
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(timeStamp);
            directories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = directories.size() - 1;
        while (i >= 0) {
            this.fJarOutputStream.putNextEntry((JarEntry)directories.get(i));
            --i;
        }
    }

    protected boolean canCreateJar(Shell parent) {
        File file = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && JarPackagerUtil.askForOverwritePermission(parent, this.fJarPackage.getAbsoluteJarLocation(), true);
        }
        String path = file.getAbsolutePath();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        File directory = new File(path.substring(0, separatorIndex));
        if (!directory.exists()) {
            if (JarPackagerUtil.askToCreateDirectory(parent, directory)) {
                return directory.mkdirs();
            }
            return false;
        }
        return true;
    }

    private void registerInWorkspaceIfNeeded() {
        IPath jarPath = this.fJarPackage.getAbsoluteJarLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(jarPath)) {
                try {
                    jarPath = jarPath.removeFirstSegments(projectLocation.segmentCount());
                    jarPath = jarPath.removeLastSegments(1);
                    IResource containingFolder = project.findMember(jarPath);
                    if (containingFolder != null && containingFolder.isAccessible()) {
                        containingFolder.refreshLocal(1, null);
                    }
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex);
                }
            }
            ++i;
        }
    }
}

