/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.text.correction.ClasspathFixProcessorDescriptor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ClasspathFixSelectionDialog
extends StatusDialog {
    private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final Object BUILD_PATH_BLOCK = "block_until_buildpath_applied";
    private TableViewer fFixSelectionTable;
    private ClasspathFixProcessor.ClasspathFixProposal fSelectedFix;
    private final IJavaProject fProject;
    private final String fMissingType;
    private final ClasspathFixProcessor.ClasspathFixProposal[] fClasspathFixProposals;

    public static boolean openClasspathFixSelectionDialog(Shell parent, final IJavaProject project, final String missingType, IRunnableContext context) {
        final ClasspathFixProcessor.ClasspathFixProposal[][] classPathFixProposals = new ClasspathFixProcessor.ClasspathFixProposal[1][];
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, NewWizardMessages.ClasspathFixSelectionDialog_eval_proposals_error_message, null);
                    classPathFixProposals[0] = ClasspathFixProcessorDescriptor.getProposals(project, missingType, status);
                    if (!status.isOK()) {
                        JavaPlugin.log((IStatus)status);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            JavaPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        ClasspathFixSelectionDialog dialog = new ClasspathFixSelectionDialog(parent, project, missingType, classPathFixProposals[0]);
        if (dialog.open() == 0) {
            try {
                context.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask(NewWizardMessages.ClasspathFixSelectionDialog_process_fix_description, 4);
                        try {
                            try {
                                ClasspathFixProcessor.ClasspathFixProposal fix = ClasspathFixSelectionDialog.this.getSelectedClasspathFix();
                                Change change = fix.createChange((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                new PerformChangeOperation(change).run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                throw new InterruptedException();
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
                return true;
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, NewWizardMessages.ClasspathFixSelectionDialog_apply_proposal_error_title, NewWizardMessages.ClasspathFixSelectionDialog_apply_proposal_error_message);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    private ClasspathFixSelectionDialog(Shell parent, IJavaProject project, String missingType, ClasspathFixProcessor.ClasspathFixProposal[] classpathFixProposals) {
        super(parent);
        this.setTitle(NewWizardMessages.ClasspathFixSelectionDialog_dialog_title);
        this.fClasspathFixProposals = classpathFixProposals;
        this.fProject = project;
        this.fMissingType = missingType;
        this.fSelectedFix = null;
    }

    protected boolean isResizable() {
        return true;
    }

    private Link createLink(Composite composite, ListenerMix listener) {
        Link link = new Link(composite, 64);
        GridData layoutData = new GridData(4, 0x1000000, false, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(80);
        link.setLayoutData((Object)layoutData);
        link.addSelectionListener((SelectionListener)listener);
        return link;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ListenerMix listener = new ListenerMix();
        if (this.fClasspathFixProposals.length == 0) {
            Link link = this.createLink(composite, listener);
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(this.fMissingType), BasicElementLabels.getJavaElementName(this.fProject.getElementName())};
            link.setText(Messages.format(NewWizardMessages.ClasspathFixSelectionDialog_no_proposals_message, args));
            this.updateStatus(new StatusInfo(4, new String()));
        } else {
            Label label = new Label(composite, 64);
            GridData layoutData = new GridData(4, 0x1000000, false, false);
            layoutData.widthHint = this.convertWidthInCharsToPixels(80);
            label.setLayoutData((Object)layoutData);
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(this.fMissingType)};
            label.setText(Messages.format(NewWizardMessages.ClasspathFixSelectionDialog_proposals_message, args));
            this.fFixSelectionTable = new TableViewer(composite, 2052);
            this.fFixSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fFixSelectionTable.setLabelProvider((IBaseLabelProvider)new ClasspathFixLabelProvider());
            this.fFixSelectionTable.setComparator(new ViewerComparator());
            this.fFixSelectionTable.addDoubleClickListener((IDoubleClickListener)listener);
            this.fFixSelectionTable.setInput((Object)this.fClasspathFixProposals);
            this.fFixSelectionTable.setSelection((ISelection)new StructuredSelection((Object)this.fClasspathFixProposals[0]));
            this.fFixSelectionTable.addSelectionChangedListener((ISelectionChangedListener)listener);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.heightHint = this.convertHeightInCharsToPixels(4);
            this.fFixSelectionTable.getControl().setLayoutData((Object)gridData);
            Link link = this.createLink(composite, listener);
            link.setText(Messages.format(NewWizardMessages.ClasspathFixSelectionDialog_open_buld_path_dialog_message, BasicElementLabels.getJavaElementName(this.fProject.getElementName())));
            this.performSelectionChanged();
        }
        return composite;
    }

    protected final void configureBuildPathPressed() {
        this.cancelPressed();
        String id = BUILD_PATH_PAGE_ID;
        HashMap<Object, Boolean> input = new HashMap<Object, Boolean>();
        input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
        if (PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)id, (String[])new String[]{id}, input).open() != 0) {
            return;
        }
    }

    protected final void performSelectionChanged() {
        StatusInfo status = new StatusInfo();
        IStructuredSelection selection = (IStructuredSelection)this.fFixSelectionTable.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ClasspathFixProcessor.ClasspathFixProposal) {
            this.fSelectedFix = (ClasspathFixProcessor.ClasspathFixProposal)firstElement;
        } else {
            status.setError("");
        }
        this.updateStatus(status);
    }

    protected final void performDoubleClick() {
        if (this.fSelectedFix != null) {
            this.okPressed();
        }
    }

    public ClasspathFixProcessor.ClasspathFixProposal getSelectedClasspathFix() {
        return this.fSelectedFix;
    }

    private static class ClasspathFixLabelProvider
    extends LabelProvider {
        private ClasspathFixLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                return classpathFixProposal.getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                return classpathFixProposal.getDisplayString();
            }
            return null;
        }
    }

    private class ListenerMix
    implements IDoubleClickListener,
    ISelectionChangedListener,
    SelectionListener {
        private ListenerMix() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ClasspathFixSelectionDialog.this.performDoubleClick();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ClasspathFixSelectionDialog.this.performSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ClasspathFixSelectionDialog.this.configureBuildPathPressed();
        }

        public void widgetSelected(SelectionEvent e) {
            ClasspathFixSelectionDialog.this.configureBuildPathPressed();
        }
    }
}

