/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;

public class JavaElementLinks {
    public static final String OPEN_LINK_SCHEME = "eclipse-open";
    public static final String JAVADOC_SCHEME = "eclipse-javadoc";
    public static final String JAVADOC_VIEW_SCHEME = "eclipse-javadoc-view";
    private static final char LINK_BRACKET_REPLACEMENT = '\u2603';
    private static final char LINK_SEPARATOR = '\u2602';

    private JavaElementLinks() {
    }

    public static LocationListener createLocationListener(final ILinkHandler handler) {
        return new LocationAdapter(){

            public void changing(LocationEvent event) {
                URI uri;
                event.doit = false;
                String loc = event.location;
                try {
                    uri = new URI(loc);
                }
                catch (URISyntaxException e) {
                    JavaPlugin.log(e);
                    return;
                }
                String scheme = uri.getScheme();
                if (JavaElementLinks.JAVADOC_VIEW_SCHEME.equals(scheme)) {
                    IJavaElement linkTarget = JavaElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleJavadocViewLink(linkTarget);
                } else if (JavaElementLinks.JAVADOC_SCHEME.equals(scheme)) {
                    IJavaElement linkTarget = JavaElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleInlineJavadocLink(linkTarget);
                } else if (JavaElementLinks.OPEN_LINK_SCHEME.equals(scheme)) {
                    IJavaElement linkTarget = JavaElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleDeclarationLink(linkTarget);
                } else if (!"about:blank".equals(loc)) {
                    if (loc.startsWith("about:")) {
                        return;
                    }
                    try {
                        if (handler.handleExternalLink(new URL(loc), event.display)) {
                            return;
                        }
                        event.doit = true;
                    }
                    catch (MalformedURLException e) {
                        JavaPlugin.log(e);
                    }
                } else {
                    event.doit = true;
                    handler.handleTextSet();
                }
            }
        };
    }

    public static String createURI(String scheme, IJavaElement element) throws URISyntaxException {
        return JavaElementLinks.createURI(scheme, element, null, null, null);
    }

    public static String createURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
        StringBuffer ssp = new StringBuffer(60);
        ssp.append('\u2602');
        ssp.append(element.getHandleIdentifier().replace('[', '\u2603'));
        if (refTypeName != null) {
            ssp.append('\u2602');
            ssp.append(refTypeName);
            if (refMemberName != null) {
                ssp.append('\u2602');
                ssp.append(refMemberName);
                if (refParameterTypes != null) {
                    ssp.append('\u2602');
                    int i = 0;
                    while (i < refParameterTypes.length) {
                        ssp.append(refParameterTypes[i]);
                        if (i != refParameterTypes.length - 1) {
                            ssp.append('\u2602');
                        }
                        ++i;
                    }
                }
            }
        }
        return new URI(scheme, ssp.toString(), null).toASCIIString();
    }

    public static IJavaElement parseURI(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String[] segments = ssp.split(String.valueOf('\u2602'), -1);
        IJavaElement element = JavaCore.create((String)segments[1].replace('\u2603', '['));
        if (segments.length > 2) {
            if (element instanceof IMember && !(element instanceof IType)) {
                element = ((IMember)element).getDeclaringType();
            }
            if (element instanceof IType) {
                String refTypeName = segments[2];
                try {
                    IType baseType = (IType)element;
                    IType type = JavaElementLinks.resolveType(baseType, refTypeName);
                    if (type != null) {
                        element = type;
                        if (segments.length > 3) {
                            String refMemberName = segments[3];
                            if (segments.length > 4) {
                                String[] paramSignatures = new String[segments[4].length() == 0 ? 0 : segments.length - 4];
                                int i = 0;
                                while (i < paramSignatures.length) {
                                    paramSignatures[i] = Signature.createTypeSignature((String)segments[i + 4], (boolean)false);
                                    ++i;
                                }
                                IMethod method = type.getMethod(refMemberName, paramSignatures);
                                IMethod[] methods = type.findMethods(method);
                                if (methods != null) {
                                    return methods[0];
                                }
                            } else {
                                IField field = type.getField(refMemberName);
                                if (field.exists()) {
                                    return field;
                                }
                                IMethod[] methods = type.getMethods();
                                int i = 0;
                                while (i < methods.length) {
                                    IMethod method = methods[i];
                                    if (method.getElementName().equals(refMemberName)) {
                                        return method;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    return type;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return element;
    }

    private static IType resolveType(IType baseType, String refTypeName) throws JavaModelException {
        if (refTypeName.length() == 0) {
            return baseType;
        }
        String[][] resolvedNames = baseType.resolveType(refTypeName);
        if (resolvedNames != null && resolvedNames.length > 0) {
            return baseType.getJavaProject().findType(resolvedNames[0][0], resolvedNames[0][1].replace('$', '.'), null);
        }
        if (baseType.isBinary()) {
            IType type = baseType.getJavaProject().findType(refTypeName, null);
            if (type == null) {
                type = baseType.getJavaProject().findType(String.valueOf(baseType.getPackageFragment().getElementName()) + '.' + refTypeName, null);
            }
            return type;
        }
        return null;
    }

    public static interface ILinkHandler {
        public void handleInlineJavadocLink(IJavaElement var1);

        public void handleJavadocViewLink(IJavaElement var1);

        public void handleDeclarationLink(IJavaElement var1);

        public boolean handleExternalLink(URL var1, Display var2);

        public void handleTextSet();
    }
}

