/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ConstructorFromSuperclassProposal
extends LinkedCorrectionProposal {
    private TypeDeclaration fTypeNode;
    private IMethodBinding fSuperConstructor;

    public ConstructorFromSuperclassProposal(ICompilationUnit cu, TypeDeclaration typeNode, IMethodBinding superConstructor, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fTypeNode = typeNode;
        this.fSuperConstructor = superConstructor;
    }

    public Image getImage() {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE));
    }

    public String getName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fTypeNode.getName().getIdentifier());
        buf.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] paramTypes = this.fSuperConstructor.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(paramTypes[i].getName());
                ++i;
            }
        }
        buf.append(')');
        return Messages.format(CorrectionMessages.ConstructorFromSuperclassProposal_description, buf.toString());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fTypeNode.getRoot());
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaProject());
        if (!settings.createComments) {
            settings = null;
        }
        MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, this.fSuperConstructor, rewrite, settings);
        rewrite.getListRewrite((ASTNode)this.fTypeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethodDecl, null);
        this.addLinkedRanges(rewrite, newMethodDecl);
        return rewrite;
    }

    private void addLinkedRanges(ASTRewrite rewrite, MethodDeclaration newStub) {
        List parameters = newStub.parameters();
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)parameters.get(i);
            String name = curr.getName().getIdentifier();
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getType()), false, "arg_type_" + name);
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getName()), false, "arg_name_" + name);
            ++i;
        }
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String name = this.fTypeNode.getName().getIdentifier();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(true);
        decl.setName(ast.newSimpleName(name));
        Block body = ast.newBlock();
        decl.setBody(body);
        SuperConstructorInvocation invocation = null;
        List parameters = decl.parameters();
        String[] paramNames = this.getArgumentNames(binding);
        ITypeBinding enclosingInstance = this.getEnclosingInstance();
        if (enclosingInstance != null) {
            invocation = this.addEnclosingInstanceAccess(rewrite, parameters, paramNames, enclosingInstance);
        }
        if (binding == null) {
            decl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        } else {
            decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, binding.getModifiers()));
            ITypeBinding[] params = binding.getParameterTypes();
            int i = 0;
            while (i < params.length) {
                SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
                var.setType(this.getImportRewrite().addImport(params[i], ast));
                var.setName(ast.newSimpleName(paramNames[i]));
                parameters.add(var);
                ++i;
            }
            List thrownExceptions = decl.thrownExceptions();
            ITypeBinding[] excTypes = binding.getExceptionTypes();
            int i2 = 0;
            while (i2 < excTypes.length) {
                String excTypeName = this.getImportRewrite().addImport(excTypes[i2]);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
                ++i2;
            }
            if (invocation == null) {
                invocation = ast.newSuperConstructorInvocation();
            }
            List arguments = invocation.arguments();
            int i3 = 0;
            while (i3 < paramNames.length) {
                SimpleName argument = ast.newSimpleName(paramNames[i3]);
                arguments.add(argument);
                this.addLinkedPosition(rewrite.track((ASTNode)argument), false, "arg_name_" + paramNames[i3]);
                ++i3;
            }
        }
        String bodyStatement = invocation == null ? "" : ASTNodes.asFormattedString((ASTNode)invocation, 0, String.valueOf('\n'), this.getCompilationUnit().getJavaProject().getOptions(true));
        String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), name, name, true, bodyStatement, String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), name, decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private SuperConstructorInvocation addEnclosingInstanceAccess(ASTRewrite rewrite, List parameters, String[] paramNames, ITypeBinding enclosingInstance) {
        AST ast = rewrite.getAST();
        SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
        SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
        var.setType(this.getImportRewrite().addImport(enclosingInstance, ast));
        String[] enclosingArgNames = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaProject(), enclosingInstance.getTypeDeclaration().getName(), 0, paramNames);
        String firstName = enclosingArgNames[0];
        var.setName(ast.newSimpleName(firstName));
        parameters.add(var);
        SimpleName enclosing = ast.newSimpleName(firstName);
        invocation.setExpression((Expression)enclosing);
        String key = "arg_name_" + firstName;
        this.addLinkedPosition(rewrite.track((ASTNode)enclosing), false, key);
        int i = 0;
        while (i < enclosingArgNames.length) {
            this.addLinkedPositionProposal(key, enclosingArgNames[i], null);
            ++i;
        }
        return invocation;
    }

    private ITypeBinding getEnclosingInstance() {
        ITypeBinding currBinding = this.fTypeNode.resolveBinding();
        if (currBinding == null || Modifier.isStatic((int)currBinding.getModifiers())) {
            return null;
        }
        ITypeBinding superBinding = currBinding.getSuperclass();
        if (superBinding == null || superBinding.getDeclaringClass() == null || Modifier.isStatic((int)superBinding.getModifiers())) {
            return null;
        }
        ITypeBinding enclosing = superBinding.getDeclaringClass();
        while (currBinding != null) {
            if (Bindings.isSuperType(enclosing, currBinding)) {
                return null;
            }
            if (Modifier.isStatic((int)currBinding.getModifiers())) {
                return null;
            }
            currBinding = currBinding.getDeclaringClass();
        }
        return enclosing;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        if (binding == null) {
            return new String[0];
        }
        return StubUtility.suggestArgumentNames(this.getCompilationUnit().getJavaProject(), binding);
    }
}

