/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectMainTypeNameProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectPackageDeclarationProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathFixSelectionDialog;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IJavaProject javaProject = cu.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        CompilationUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        if (!(coveredNode instanceof SimpleName)) {
            return;
        }
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = ((SimpleName)coveredNode).getIdentifier();
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        boolean hasOtherPublicTypeBefore = false;
        boolean found = false;
        List types = root.types();
        int i = 0;
        while (i < types.size()) {
            AbstractTypeDeclaration curr = (AbstractTypeDeclaration)types.get(i);
            if (parentType != curr) {
                if (newTypeName.equals(curr.getName().getIdentifier())) {
                    return;
                }
                if (!found && Modifier.isPublic((int)curr.getModifiers())) {
                    hasOtherPublicTypeBefore = true;
                }
            } else {
                found = true;
            }
            ++i;
        }
        if (!JavaConventions.validateJavaTypeName((String)newTypeName, (String)sourceLevel, (String)compliance).matches(4)) {
            proposals.add(new CorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5));
        }
        if (!hasOtherPublicTypeBefore) {
            String newCUName = JavaModelUtil.getRenamedCUName(cu, currTypeName);
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName, (String)sourceLevel, (String)compliance).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, newCUName);
                proposals.add(new ChangeCorrectionProposal(label, (Change)change, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif")));
            }
        }
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
        proposals.add(new CorrectPackageDeclarationProposal(cu, problem, relevance));
        IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
        String newPackName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
        IPackageFragment newPack = root.getPackageFragment(newPackName);
        ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
        if (!newCU.exists() && !isLinked) {
            String label;
            if (newPack.isDefaultPackage()) {
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_default_description, BasicElementLabels.getFileName((ITypeRoot)cu));
            } else {
                String packageLabel = JavaElementLabels.getElementLabel((IJavaElement)newPack, JavaElementLabels.ALL_DEFAULT);
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_description, new Object[]{BasicElementLabels.getFileName((ITypeRoot)cu), packageLabel});
            }
            CompositeChange composite = new CompositeChange(label);
            composite.add((Change)new CreatePackageChange(newPack));
            composite.add((Change)new MoveCompilationUnitChange(cu, newPack));
            proposals.add(new ChangeCorrectionProposal(label, (Change)composite, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_move.gif")));
        }
    }

    public static void removeImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ChangeCorrectionProposal proposal;
        UnusedCodeFix fix = UnusedCodeFix.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_delete_import.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            proposal = new FixCorrectionProposal(fix, new UnusedCodeCleanUp(options), 6, image, context);
            proposals.add(proposal);
        }
        final ICompilationUnit cu = context.getCompilationUnit();
        String name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description;
        proposal = new ChangeCorrectionProposal(name, null, 5, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif")){

            public void apply(IDocument document) {
                FileEditorInput input = new FileEditorInput((IFile)cu.getResource());
                IWorkbenchPage p = JavaPlugin.getActivePage();
                if (p == null) {
                    return;
                }
                IEditorPart part = p.findEditor((IEditorInput)input);
                if (part instanceof JavaEditor) {
                    OrganizeImportsAction action = new OrganizeImportsAction((JavaEditor)part);
                    action.run(cu);
                }
            }
        };
        proposals.add(proposal);
    }

    public static void addProjectSetupFixProposal(IInvocationContext context, String missingType, Collection proposals) {
        proposals.add(new ClasspathFixCorrectionProposal(context.getCompilationUnit().getJavaProject(), missingType));
    }

    public static void importNotFoundProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent(selectedNode, 26);
        if (importDeclaration == null) {
            return;
        }
        if (!importDeclaration.isOnDemand()) {
            int kind = JavaModelUtil.is50OrHigher(cu.getJavaProject()) ? 30 : 6;
            UnresolvedElementsSubProcessor.addNewTypeProposals(cu, importDeclaration.getName(), kind, 5, proposals);
        }
        String name = ASTNodes.asString((ASTNode)importDeclaration.getName());
        if (importDeclaration.isOnDemand()) {
            name = JavaModelUtil.concatenateName(name, "*");
        }
        ReorgCorrectionsSubProcessor.addProjectSetupFixProposal(context, name, proposals);
    }

    public static void getNeed50ComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        String label1 = CorrectionMessages.ReorgCorrectionsSubProcessor_50_project_compliance_description;
        proposals.add(new ChangeTo50Compliance(label1, project, false, 5));
        if (project.getOption("org.eclipse.jdt.core.compiler.compliance", false) == null) {
            String label2 = CorrectionMessages.ReorgCorrectionsSubProcessor_50_workspace_compliance_description;
            proposals.add(new ChangeTo50Compliance(label2, project, true, 6));
        }
    }

    public static void getIncorrectBuildPathProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        String label = CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label;
        OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, null);
        proposals.add(proposal);
    }

    public static void getAccessRulesProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ITypeBinding referencedElement = null;
        ASTNode node = problem.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            referencedElement = ((Type)node).resolveBinding();
        } else if (node instanceof Name) {
            referencedElement = ((Name)node).resolveBinding();
        }
        if (referencedElement != null && ReorgCorrectionsSubProcessor.canModifyAccessRules((IBinding)referencedElement)) {
            IProject project = context.getCompilationUnit().getJavaProject().getProject();
            String label = CorrectionMessages.ReorgCorrectionsSubProcessor_accessrules_description;
            OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, (IBinding)referencedElement);
            proposals.add(proposal);
        }
    }

    private static boolean canModifyAccessRules(IBinding binding) {
        IClasspathEntry classpathEntry;
        IPackageFragmentRoot root;
        block8: {
            block7: {
                IJavaElement element = binding.getJavaElement();
                if (element == null) {
                    return false;
                }
                root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root == null) {
                    return false;
                }
                try {
                    classpathEntry = root.getRawClasspathEntry();
                    if (classpathEntry != null) break block7;
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            if (classpathEntry.getEntryKind() != 1) break block8;
            return true;
        }
        if (classpathEntry.getEntryKind() == 5) {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)classpathEntry.getPath().segment(0));
            IStatus status = classpathContainerInitializer.getAccessRulesStatus(classpathEntry.getPath(), root.getJavaProject());
            return status.isOK();
        }
        return false;
    }

    private static final class ChangeTo50Compliance
    extends ChangeCorrectionProposal
    implements IWorkspaceRunnable {
        private final IJavaProject fProject;
        private final boolean fChangeOnWorkspace;
        private Job fUpdateJob;
        private boolean f50JREFound;

        public ChangeTo50Compliance(String name, IJavaProject project, boolean changeOnWorkspace, int relevance) {
            super(name, null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fProject = project;
            this.fChangeOnWorkspace = changeOnWorkspace;
            this.fUpdateJob = null;
            this.f50JREFound = false;
        }

        private boolean is50orGreaterVMInstall(IVMInstall install) {
            if (install instanceof IVMInstall2) {
                String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, "1.3");
                return JavaModelUtil.is50OrHigher(compliance);
            }
            return false;
        }

        private IVMInstall find50OrGreaterVMInstall() {
            IVMInstallType[] installTypes = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IVMInstall[] installs = installTypes[i].getVMInstalls();
                int k = 0;
                while (k < installs.length) {
                    if (this.is50orGreaterVMInstall(installs[k])) {
                        return installs[k];
                    }
                    ++k;
                }
                ++i;
            }
            return null;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            boolean needsBuild = this.updateJRE(monitor);
            if (needsBuild) {
                this.fUpdateJob = CoreUtility.getBuildJob(this.fChangeOnWorkspace ? null : this.fProject.getProject());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean updateJRE(IProgressMonitor monitor) throws CoreException, JavaModelException {
            try {
                IVMInstall vm50Install = this.find50OrGreaterVMInstall();
                boolean bl = this.f50JREFound = vm50Install != null;
                if (vm50Install == null) return true;
                IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.fProject);
                if (this.fChangeOnWorkspace) {
                    monitor.beginTask(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_operation, 4);
                    IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
                    if (defaultVM != null && !defaultVM.equals(install)) {
                        Path newPath = new Path(JavaRuntime.JRE_CONTAINER);
                        this.updateClasspath((IPath)newPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.worked(1);
                    }
                    if (defaultVM != null && this.is50orGreaterVMInstall(defaultVM)) return true;
                    JavaRuntime.setDefaultVMInstall((IVMInstall)vm50Install, (IProgressMonitor)new SubProgressMonitor(monitor, 3), (boolean)true);
                    return false;
                }
                if (install != null && this.is50orGreaterVMInstall(install)) return true;
                IPath newPath = new Path(JavaRuntime.JRE_CONTAINER).append(vm50Install.getVMInstallType().getId()).append(vm50Install.getName());
                this.updateClasspath(newPath, monitor);
                return false;
            }
            finally {
                monitor.done();
            }
        }

        private void updateClasspath(IPath newPath, IProgressMonitor monitor) throws JavaModelException {
            IClasspathEntry[] classpath = this.fProject.getRawClasspath();
            Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry curr = classpath[i];
                if (curr.getEntryKind() == 5 && curr.getPath().matchingFirstSegments((IPath)jreContainerPath) > 0) {
                    classpath[i] = JavaCore.newContainerEntry((IPath)newPath, (IAccessRule[])curr.getAccessRules(), (IClasspathAttribute[])curr.getExtraAttributes(), (boolean)curr.isExported());
                }
                ++i;
            }
            this.fProject.setRawClasspath(classpath, monitor);
        }

        public String getAdditionalProposalInfo() {
            StringBuffer message = new StringBuffer();
            if (this.fChangeOnWorkspace) {
                message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeworkspace_description);
            } else {
                message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeproject_description);
            }
            IVMInstall vm50Install = this.find50OrGreaterVMInstall();
            if (vm50Install != null) {
                try {
                    IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.fProject);
                    if (this.fChangeOnWorkspace) {
                        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
                        if (defaultVM != null && !defaultVM.equals(install)) {
                            message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJREToDefault_description);
                        }
                        if (defaultVM == null || !this.is50orGreaterVMInstall(defaultVM)) {
                            message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeWorkspaceJRE_description, vm50Install.getName()));
                        }
                    } else if (install == null || !this.is50orGreaterVMInstall(install)) {
                        message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJRE_description, vm50Install.getName()));
                    }
                }
                catch (CoreException coreException) {}
            }
            return message.toString();
        }

        public void apply(IDocument document) {
            Map map;
            if (this.fChangeOnWorkspace) {
                map = JavaCore.getOptions();
                JavaModelUtil.set50CompilanceOptions(map);
                JavaCore.setOptions((Hashtable)map);
            } else {
                map = this.fProject.getOptions(false);
                int optionsCount = map.size();
                JavaModelUtil.set50CompilanceOptions(map);
                if (map.size() > optionsCount) {
                    JavaModelUtil.setDefaultClassfileOptions(map, "1.5");
                }
                this.fProject.setOptions(map);
            }
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(this));
            }
            catch (InvocationTargetException e) {
                JavaPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.fUpdateJob != null) {
                this.fUpdateJob.schedule();
            }
            if (!this.f50JREFound) {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)CorrectionMessages.ReorgCorrectionsSubProcessor_no_50jre_title, (String)CorrectionMessages.ReorgCorrectionsSubProcessor_no_50jre_message);
            }
        }
    }

    private static class ClasspathFixCorrectionProposal
    extends ChangeCorrectionProposal {
        private final IJavaProject fProject;
        private final String fMissingType;

        public ClasspathFixCorrectionProposal(IJavaProject project, String missingType) {
            super(CorrectionMessages.ReorgCorrectionsSubProcessor_project_seup_fix_description, null, -10, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fProject = project;
            this.fMissingType = missingType;
        }

        public void apply(IDocument document) {
            Object context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = new BusyIndicatorRunnableContext();
            }
            ClasspathFixSelectionDialog.openClasspathFixSelectionDialog(JavaPlugin.getActiveWorkbenchShell(), this.fProject, this.fMissingType, (IRunnableContext)context);
        }

        public String getAdditionalProposalInfo() {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_project_seup_fix_info, BasicElementLabels.getJavaElementName(this.fMissingType));
        }
    }

    private static final class OpenBuildPathCorrectionProposal
    extends ChangeCorrectionProposal {
        private final IProject fProject;
        private final IBinding fReferencedType;

        private OpenBuildPathCorrectionProposal(IProject project, String label, int relevance, IBinding referencedType) {
            super(label, null, relevance, null);
            this.fProject = project;
            this.fReferencedType = referencedType;
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.access_restriction_attrib.gif"));
        }

        public void apply(IDocument document) {
            IPackageFragmentRoot root;
            IJavaElement elem;
            HashMap<Object, Object> data = null;
            if (this.fReferencedType != null && (elem = this.fReferencedType.getJavaElement()) != null && (root = (IPackageFragmentRoot)elem.getAncestor(3)) != null) {
                try {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    if (entry != null) {
                        data = new HashMap<Object, Object>(1);
                        data.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, entry);
                        if (entry.getEntryKind() != 5) {
                            data.put(BuildPathsPropertyPage.DATA_REVEAL_ATTRIBUTE_KEY, "accessrules");
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            PreferencesUtil.createPropertyDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (IAdaptable)this.fProject, (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, data).open();
        }

        public String getAdditionalProposalInfo() {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_description, this.fProject.getName());
        }
    }
}

