/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;

    public CutAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        this.setText(ReorgMessages.CutAction_text);
        this.fCopyToClipboardAction = new CopyToClipboardAction(site, clipboard);
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.cut_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            if (!CutAction.containsOnlyElementsInsideCompilationUnits(selection) || CutAction.containsTopLevelTypes(selection)) {
                this.setEnabled(false);
                return;
            }
            this.fCopyToClipboardAction.selectionChanged(selection);
            this.setEnabled(this.fCopyToClipboardAction.isEnabled() && RefactoringAvailabilityTester.isDeleteAvailable(selection));
        } else {
            this.setEnabled(false);
        }
    }

    private static boolean containsOnlyElementsInsideCompilationUnits(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof IJavaElement && ReorgUtils.isInsideCompilationUnit((IJavaElement)object)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTopLevelTypes(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IType) || ((IType)each).getDeclaringType() != null) continue;
            return true;
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        try {
            this.selectionChanged(selection);
            if (this.isEnabled()) {
                this.fCopyToClipboardAction.run(selection);
                RefactoringExecutionStarter.startCutRefactoring(selection.toArray(), this.getShell());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

