/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileManager;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CleanUpConfigurationBlock
extends ProfileConfigurationBlock {
    private static final String CLEANUP_PAGE_SETTINGS_KEY = "cleanup_page";
    private static final String DIALOGSTORE_LASTSAVELOADPATH = "org.eclipse.jdt.ui.cleanup";
    private final IScopeContext fCurrContext;
    private SelectionButtonDialogField fShowCleanUpWizardDialogField;
    private CleanUpProfileManager fProfileManager;
    private ProfileStore fProfileStore;

    public CleanUpConfigurationBlock(IProject project, PreferencesAccess access) {
        super(project, access, DIALOGSTORE_LASTSAVELOADPATH);
        this.fCurrContext = project != null ? null : access.getInstanceScope();
    }

    protected IProfileVersioner createProfileVersioner() {
        return new CleanUpProfileVersioner();
    }

    protected ProfileStore createProfileStore(IProfileVersioner versioner) {
        this.fProfileStore = new ProfileStore("org.eclipse.jdt.ui.cleanupprofiles", versioner);
        return this.fProfileStore;
    }

    protected ProfileManager createProfileManager(List profiles, IScopeContext context, PreferencesAccess access, IProfileVersioner profileVersioner) {
        profiles.addAll(CleanUpPreferenceUtil.getBuiltInProfiles());
        this.fProfileManager = new CleanUpProfileManager(profiles, context, access, profileVersioner);
        return this.fProfileManager;
    }

    protected void configurePreview(Composite composite, int numColumns, final ProfileManager profileManager) {
        Map settings = profileManager.getSelected().getSettings();
        final Hashtable sharedSettings = new Hashtable();
        this.fill(settings, sharedSettings);
        final ICleanUp[] cleanUps = CleanUpRefactoring.createCleanUps();
        MapCleanUpOptions options = new MapCleanUpOptions(sharedSettings);
        int i = 0;
        while (i < cleanUps.length) {
            cleanUps[i].setOptions(options);
            ++i;
        }
        CleanUpConfigurationBlock.createLabel(composite, CleanUpMessages.CleanUpConfigurationBlock_SelectedCleanUps_label, numColumns);
        final BulletListBlock cleanUpListBlock = new BulletListBlock(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = numColumns;
        cleanUpListBlock.setLayoutData(gridData);
        cleanUpListBlock.setText(this.getSelectedCleanUpsInfo(cleanUps));
        profileManager.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                int value = (Integer)arg;
                switch (value) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        CleanUpConfigurationBlock.this.fill(profileManager.getSelected().getSettings(), sharedSettings);
                        cleanUpListBlock.setText(CleanUpConfigurationBlock.this.getSelectedCleanUpsInfo(cleanUps));
                    }
                }
            }
        });
    }

    private String getSelectedCleanUpsInfo(ICleanUp[] cleanUps) {
        if (cleanUps.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < cleanUps.length) {
            String[] descriptions = cleanUps[i].getDescriptions();
            if (descriptions != null) {
                int j = 0;
                while (j < descriptions.length) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append('\n');
                    }
                    buf.append(descriptions[j]);
                    ++j;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private void fill(Map settings, Map sharedSettings) {
        sharedSettings.clear();
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            sharedSettings.put(key, settings.get(key));
        }
    }

    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile) {
        return new CleanUpModifyDialog(shell, profile, profileManager, profileStore, newProfile, CLEANUP_PAGE_SETTINGS_KEY, DIALOGSTORE_LASTSAVELOADPATH);
    }

    public Composite createContents(Composite parent) {
        Composite composite = super.createContents(parent);
        if (this.fCurrContext == null) {
            return composite;
        }
        this.fShowCleanUpWizardDialogField = new SelectionButtonDialogField(32);
        this.fShowCleanUpWizardDialogField.setLabelText(CleanUpMessages.CleanUpConfigurationBlock_ShowCleanUpWizard_checkBoxLabel);
        this.fShowCleanUpWizardDialogField.doFillIntoGrid(composite, 5);
        IEclipsePreferences node = this.fCurrContext.getNode("org.eclipse.jdt.ui");
        boolean showWizard = node.get("cleanup.showwizard", null) != null ? node.getBoolean("cleanup.showwizard", true) : new DefaultScope().getNode("org.eclipse.jdt.ui").getBoolean("cleanup.showwizard", true);
        if (showWizard) {
            this.fShowCleanUpWizardDialogField.setSelection(true);
        }
        this.fShowCleanUpWizardDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CleanUpConfigurationBlock.this.doShowCleanUpWizard(CleanUpConfigurationBlock.this.fShowCleanUpWizardDialogField.isSelected());
            }
        });
        return composite;
    }

    private void doShowCleanUpWizard(boolean showWizard) {
        IEclipsePreferences preferences = this.fCurrContext.getNode("org.eclipse.jdt.ui");
        if (preferences.get("cleanup.showwizard", null) != null && preferences.getBoolean("cleanup.showwizard", true) == showWizard) {
            return;
        }
        preferences.putBoolean("cleanup.showwizard", showWizard);
    }

    public void performDefaults() {
        super.performDefaults();
        if (this.fCurrContext == null) {
            return;
        }
        this.fCurrContext.getNode("org.eclipse.jdt.ui").remove("cleanup.showwizard");
        boolean showWizard = new DefaultScope().getNode("org.eclipse.jdt.ui").getBoolean("cleanup.showwizard", true);
        this.fShowCleanUpWizardDialogField.setDialogFieldListener(null);
        this.fShowCleanUpWizardDialogField.setSelection(showWizard);
        this.fShowCleanUpWizardDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CleanUpConfigurationBlock.this.doShowCleanUpWizard(CleanUpConfigurationBlock.this.fShowCleanUpWizardDialogField.isSelected());
            }
        });
    }

    protected void preferenceChanged(IEclipsePreferences.PreferenceChangeEvent event) {
        block13: {
            if ("org.eclipse.jdt.ui.cleanupprofiles".equals(event.getKey())) {
                try {
                    String id = this.fCurrContext.getNode("org.eclipse.jdt.ui").get("cleanup_profile", null);
                    if (id == null) {
                        this.fProfileManager.getDefaultProfile().getID();
                    }
                    List oldProfiles = this.fProfileManager.getSortedProfiles();
                    ProfileManager.Profile[] oldProfilesArray = oldProfiles.toArray(new ProfileManager.Profile[oldProfiles.size()]);
                    int i = 0;
                    while (i < oldProfilesArray.length) {
                        if (oldProfilesArray[i] instanceof ProfileManager.CustomProfile) {
                            this.fProfileManager.deleteProfile((ProfileManager.CustomProfile)oldProfilesArray[i]);
                        }
                        ++i;
                    }
                    List newProfiles = this.fProfileStore.readProfilesFromString((String)event.getNewValue());
                    Iterator iterator = newProfiles.iterator();
                    while (iterator.hasNext()) {
                        ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)iterator.next();
                        this.fProfileManager.addProfile(profile);
                    }
                    ProfileManager.Profile profile = this.fProfileManager.getProfile(id);
                    if (profile != null) {
                        this.fProfileManager.setSelected(profile);
                        break block13;
                    }
                    this.fProfileManager.setSelected(this.fProfileManager.getDefaultProfile());
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            } else if ("cleanup_profile".equals(event.getKey())) {
                if (event.getNewValue() == null) {
                    this.fProfileManager.setSelected(this.fProfileManager.getDefaultProfile());
                } else {
                    ProfileManager.Profile profile = this.fProfileManager.getProfile((String)event.getNewValue());
                    if (profile != null) {
                        this.fProfileManager.setSelected(profile);
                    }
                }
            }
        }
    }
}

