/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.jarpackager.JarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarManifestProvider;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackagerfat.JarWriter4;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.swt.widgets.Shell;

public class FatJarBuilder
extends JarBuilder {
    public static final String BUILDER_ID = "org.eclipse.jdt.ui.fat_jar_builder";
    private JarPackageData fJarPackage;
    private JarWriter4 fJarWriter;

    public String getId() {
        return BUILDER_ID;
    }

    public IManifestProvider getManifestProvider() {
        return new FatJarManifestProvider(this);
    }

    public String getManifestClasspath() {
        return ".";
    }

    public boolean isMergeManifests() {
        return true;
    }

    public boolean isRemoveSigners() {
        return true;
    }

    public void open(JarPackageData jarPackage, Shell displayShell, MultiStatus status) throws CoreException {
        super.open(jarPackage, displayShell, status);
        this.fJarPackage = jarPackage;
        this.fJarWriter = new JarWriter4(this.fJarPackage, displayShell);
    }

    public void writeFile(IFile resource, IPath destinationPath) throws CoreException {
        this.fJarWriter.write(resource, destinationPath);
    }

    public void writeArchive(ZipFile jarFile, IProgressMonitor progressMonitor) {
        Enumeration<? extends ZipEntry> jarEntriesEnum = jarFile.entries();
        while (jarEntriesEnum.hasMoreElements()) {
            ZipEntry jarEntry = jarEntriesEnum.nextElement();
            if (!jarEntry.isDirectory()) {
                String entryName = jarEntry.getName();
                this.addFile(entryName, jarEntry, jarFile);
            }
            progressMonitor.worked(1);
            if (!progressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    private void addFile(String destinationPath, ZipEntry jarEntry, ZipFile zipFile) {
        if (destinationPath.equalsIgnoreCase("META-INF/MANIFEST.MF") || this.isRemoveSigners() && destinationPath.startsWith("META-INF/") && destinationPath.endsWith(".SF")) {
            return;
        }
        try {
            this.fJarWriter.addZipEntry(jarEntry, zipFile, destinationPath);
        }
        catch (IOException ex) {
            if (ex instanceof ZipException && ex.getMessage() != null && ex.getMessage().startsWith("duplicate entry:")) {
                if (!destinationPath.startsWith("META-INF/")) {
                    this.addWarning(ex.getMessage(), ex);
                }
            }
            this.addWarning(Messages.format(FatJarPackagerMessages.FatJarBuilder_error_readingArchiveFile, new Object[]{BasicElementLabels.getFileName(zipFile.getName()), ex.getLocalizedMessage()}), ex);
        }
    }

    public void close() throws CoreException {
        if (this.fJarWriter != null) {
            this.fJarWriter.close();
        }
    }
}

