/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class JarPackagerUtil {
    static final String JAR_EXTENSION = "jar";
    static final String DESCRIPTION_EXTENSION = "jardesc";
    private static final String META_INF_ENTRY = "META-INF";
    private static final String REFACTORINGS_ENTRY = "META-INF/REFACTORINGS.XML";

    private JarPackagerUtil() {
    }

    public static boolean askToCreateDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(parent, JarPackagerMessages.JarPackage_confirmCreate_title, Messages.format(JarPackagerMessages.JarPackage_confirmCreate_message, directory.toString()));
    }

    public static String getRefactoringsEntry() {
        return REFACTORINGS_ENTRY;
    }

    public static String getDeprecationEntry(String name) {
        return "META-INF/" + name;
    }

    public static String getMetaEntry() {
        return META_INF_ENTRY;
    }

    public static List asResources(Object[] elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<Object> selectedResources = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IJavaElement) {
                selectedResources.add(((IJavaElement)element).getResource());
            } else if (element instanceof IResource) {
                selectedResources.add(element);
            }
            ++i;
        }
        return selectedResources;
    }

    public static boolean askForOverwritePermission(Shell parent, IPath filePath, boolean isOSPath) {
        if (parent == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(parent, JarPackagerMessages.JarPackage_confirmReplace_title, Messages.format(JarPackagerMessages.JarPackage_confirmReplace_message, BasicElementLabels.getPathLabel(filePath, isOSPath)));
    }

    static String getMainClassName(JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() == null) {
            return "";
        }
        return jarPackage.getManifestMainClass().getFullyQualifiedName();
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static CoreException createCoreException(String message, Exception ex) {
        if (message == null) {
            message = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)ex));
    }

    public static boolean isMainClassValid(JarPackageData data, IRunnableContext context) {
        IType mainClass;
        block5: {
            if (data == null) {
                return false;
            }
            mainClass = data.getManifestMainClass();
            if (mainClass == null) {
                return true;
            }
            try {
                IFile file = (IFile)mainClass.getResource();
                if (file != null && JarPackagerUtil.contains(JarPackagerUtil.asResources(data.getElements()), file)) break block5;
                return false;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e.getStatus());
                return false;
            }
        }
        return JavaModelUtil.hasMainMethod(mainClass);
    }

    static boolean contains(List resources, IFile file) {
        if (resources == null || file == null) {
            return false;
        }
        if (resources.contains(file)) {
            return true;
        }
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (resource == null || resource.getType() == 1) continue;
            List<IResource> children = null;
            try {
                children = Arrays.asList(((IContainer)resource).members());
            }
            catch (CoreException coreException) {
                continue;
            }
            if (children == null || !JarPackagerUtil.contains(children, file)) continue;
            return true;
        }
        return false;
    }

    public static void calculateCrcAndSize(JarEntry entry, InputStream stream, byte[] buffer) throws IOException {
        int size = 0;
        CRC32 crc = new CRC32();
        try {
            int count;
            while ((count = stream.read(buffer, 0, buffer.length)) != -1) {
                crc.update(buffer, 0, count);
                size += count;
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        entry.setSize(size);
        entry.setCrc(crc.getValue());
    }

    public static ZipFile getArchiveFile(IPath location) throws CoreException {
        File localFile = null;
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(location);
        if (file != null) {
            URI fileLocation = file.getLocationURI();
            IFileStore fileStore = EFS.getStore((URI)fileLocation);
            localFile = fileStore.toLocalFile(0, null);
            if (localFile == null) {
                localFile = fileStore.toLocalFile(4096, null);
            }
        } else {
            localFile = location.toFile();
        }
        if (localFile == null) {
            return null;
        }
        try {
            return new ZipFile(localFile);
        }
        catch (ZipException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", e.getLocalizedMessage(), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }
}

