/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.launching;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.launching.ICoverageLaunchInfo;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.StateFiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class CoverageLaunchInfo
implements ICoverageLaunchInfo {
    private static int idcounter = (int)System.currentTimeMillis();
    private static final Map instances = new WeakHashMap();
    private final String id = Integer.toHexString(idcounter++);
    private final ILaunchConfiguration configuration;
    private IPath coveragefile;
    private IPath propertiesjarfile;
    private final List instrumentations;
    private final Map instrumentationpaths;

    public CoverageLaunchInfo(ILaunch launch) {
        instances.put(this.id, this);
        this.configuration = launch.getLaunchConfiguration();
        StateFiles statefiles = EclEmmaCorePlugin.getInstance().getStateFiles();
        IPath base = statefiles.getLaunchDataFolder().append(this.id);
        this.coveragefile = base.addFileExtension("ec");
        statefiles.registerForCleanup(this.coveragefile);
        this.propertiesjarfile = base.addFileExtension("jar");
        statefiles.registerForCleanup(this.propertiesjarfile);
        this.instrumentations = new ArrayList();
        this.instrumentationpaths = new HashMap();
        instances.put(launch, this);
    }

    public static ICoverageLaunchInfo getInfo(ILaunch launch) {
        return (ICoverageLaunchInfo)instances.get(launch);
    }

    public IPath getCoverageFile() {
        return this.coveragefile;
    }

    public IPath getPropertiesJARFile() {
        return this.propertiesjarfile;
    }

    public void instrument(IProgressMonitor monitor, boolean inplace) throws CoreException {
        this.instrumentations.clear();
        this.instrumentationpaths.clear();
        IClassFiles[] classfiles = CoverageTools.getClassFilesForInstrumentation(this.configuration, inplace);
        monitor.beginTask(CoreMessages.InstrumentingClasses_task, classfiles.length);
        int i = 0;
        while (i < classfiles.length) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(NLS.bind((String)CoreMessages.InstrumentingClassesIn_task, (Object)classfiles[i].getLocation()));
            this.addInstrumentation(classfiles[i].instrument(inplace, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            ++i;
        }
        monitor.done();
    }

    private void addInstrumentation(IInstrumentation instrumentation) {
        this.instrumentations.add(instrumentation);
        IPath orig = EclEmmaCorePlugin.getAbsolutePath(instrumentation.getClassFiles().getLocation());
        this.instrumentationpaths.put(orig.toOSString(), instrumentation);
    }

    public IInstrumentation[] getInstrumentations() {
        IInstrumentation[] a = new IInstrumentation[this.instrumentations.size()];
        return this.instrumentations.toArray(a);
    }

    public IInstrumentation getInstrumentation(String originalpath) {
        return (IInstrumentation)this.instrumentationpaths.get(originalpath);
    }

    public void dispose() {
        this.coveragefile = null;
        this.propertiesjarfile = null;
    }
}

