/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.ILazyBinding;
import com.mountainminds.eclemma.internal.core.analysis.JavaElementCoverage;
import com.mountainminds.eclemma.internal.core.analysis.JavaModelCoverage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class TypeCoverage
extends JavaElementCoverage
implements ILazyBinding {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private UnboundMethodCoverage[] ubmethods = null;

    public TypeCoverage(JavaElementCoverage parent, boolean haslines, long stamp) {
        super(parent, haslines, stamp);
    }

    public TypeCoverage(JavaElementCoverage parent, boolean haslines, IResource resource) {
        super(parent, haslines, resource);
    }

    public void setUnboundMethods(UnboundMethodCoverage[] ubmethods) {
        this.ubmethods = ubmethods;
    }

    public void resolve(IJavaElement element, JavaModelCoverage modelcoverage) {
        IType type = (IType)element;
        if (this.ubmethods != null) {
            int i = 0;
            while (i < this.ubmethods.length) {
                String name = this.ubmethods[i].name;
                if (name.equals("<init>")) {
                    name = type.getElementName();
                }
                String[] paramtypes = Signature.getParameterTypes((String)this.ubmethods[i].signature);
                int j = 0;
                while (j < paramtypes.length) {
                    paramtypes[j] = paramtypes[j].replace('/', '.');
                    ++j;
                }
                IMethod pattern = type.getMethod(name, paramtypes);
                IMethod[] hits = type.findMethods(pattern);
                if (hits != null && hits.length == 1) {
                    modelcoverage.put((IJavaElement)hits[0], this.ubmethods[i].coverage);
                } else {
                    TRACER.trace("Method not found in Java model: {0}.{1}{2}", type.getElementName(), name, this.ubmethods[i].signature);
                }
                ++i;
            }
            this.ubmethods = null;
        }
    }

    public static class UnboundMethodCoverage {
        final String name;
        final String signature;
        final IJavaElementCoverage coverage;

        UnboundMethodCoverage(String name, String signature, IJavaElementCoverage coverage) {
            this.name = name;
            this.signature = signature;
            this.coverage = coverage;
        }
    }
}

