﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using Wyrocznia;

namespace Nosiciel
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("***** Nosiciel *****");

            using (ServiceHost serviceHost = new ServiceHost(typeof(Babka)))
            {
                // Set timeouts

                serviceHost.OpenTimeout = TimeSpan.FromMilliseconds(10);
                serviceHost.CloseTimeout = TimeSpan.FromMilliseconds(200);

                // Open the host and start listening for incoming messages.
                serviceHost.Open();

                // Display info
                DisplayHostInfo(serviceHost);

                // Keep the service running until Enter key is pressed.
                Console.WriteLine("Nosiciel Wyroczni nasłuchuje.");
                Console.WriteLine("Naciśnij Enter aby zakończyć pracę nosiciela.");
                Console.ReadLine();

                // Close service
                serviceHost.Close();
            }

        }


        static void DisplayHostInfo(ServiceHost host)
        {
            Console.WriteLine();
            Console.WriteLine("***** ABC *****");

            foreach (System.ServiceModel.Description.ServiceEndpoint se in host.Description.Endpoints)
            {
                Console.WriteLine("Address: {0}", se.Address);
                Console.WriteLine("Binding: {0}", se.Binding.Name);
                Console.WriteLine("Contract: {0}", se.Contract.Name);
                Console.WriteLine();
            }
            Console.WriteLine("**********************");
        }
    }
}
