﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.Runtime.Serialization;

namespace UnivLib
{
    [DataContract]
    public class Student
    {
        [DataMember]
        public string ForeName;

        [DataMember]
        public string LastName;

        [DataMember]
        public int Album;

        public double Score;

    }


    [DataContract]
    public class Faculty
    {
        [DataMember]
        public string ForeName;

        [DataMember]
        public string LastName;

        [DataMember]
        public long Pesel;

        public int Salary;

    }

    [ServiceContract]
    public interface IUniversity
    {
        [OperationContract]
        Student GetStudent(int album);
        [OperationContract]
        Faculty GetFaculty(long pesel);
    }
    public class University : IUniversity
    {

        List<Student> ls = new List<Student>();
        List<Faculty> lf = new List<Faculty>();

        public University()
        {
            ls.Add(new Student  {ForeName = "Adam", LastName = "Kowal",  Album = 12345, Score = 4.32});
            ls.Add(new Student  {ForeName = "Ewa",  LastName = "Berska", Album = 67789, Score = 4.35});
            ls.Add(new Student  {ForeName = "Piort", LastName = "Nowy",  Album = 91825, Score = 3.72});

            lf.Add(new Faculty { ForeName = "Karol",  LastName = "Derski", Pesel = 65021201234, Salary = 3000 });
            lf.Add(new Faculty { ForeName = "Zenon",  LastName = "Łuko",   Pesel = 55011705678, Salary = 4500 });
            lf.Add(new Faculty { ForeName = "Joanna", LastName = "Rycka",  Pesel = 75100102847, Salary = 2500 });


        }

        
        public Student GetStudent(int album)
        {
            var theSt = from st in ls where st.Album == album select st;

            if (theSt.Count() != 0)
                return theSt.First();
            else
                return null;

        }

        public Faculty GetFaculty(long pesel)
        {
            var theFa = from fa in lf where fa.Pesel == pesel select fa;

            if (theFa.Count() != 0)
                return theFa.First();
            else
                return null;

        }


    }
}
