//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.Diagnostics;
using System.ComponentModel;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Messaging;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

namespace TimeApp
{
	public delegate string ReturnTimeDelegate();
	public delegate string ReturnDateDelegate();

	/// <summary>
	/// Podsumowanie dla TimeForm.
	/// </summary>
	public class TimeForm : System.Windows.Forms.Form
	{
		private System.ComponentModel.IContainer components;

		public TimeForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			string configFilename = "timeclient.exe.config";

			if(!Initialize(configFilename))
				return;

			timeService = new TimeObject();
			if (true == RemotingServices.IsTransparentProxy(timeService))
			{
				returnTimeDelegate = new ReturnTimeDelegate(timeService.Time);
				returnDateDelegate = new ReturnDateDelegate(timeService.Date);
				asyncDateCallback = new AsyncCallback(DateCallBack);
				asyncTimeCallback = new AsyncCallback(TimeCallBack);
				MessageBox.Show("TimeObject zosta aktywowany na serwerze");
				timer.Enabled = true;
			}
           
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.date = new System.Windows.Forms.TextBox();
            this.time = new System.Windows.Forms.TextBox();
            this.timer = new System.Windows.Forms.Timer(this.components);
            this.dateCount = new System.Windows.Forms.TextBox();
            this.timeCount = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            // 
            // date
            // 
            this.date.BackColor = System.Drawing.Color.Black;
            this.date.Font = new System.Drawing.Font("Trebuchet MS", 20.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.date.ForeColor = System.Drawing.Color.Lime;
            this.date.Location = new System.Drawing.Point(8, 32);
            this.date.Name = "date";
            this.date.Size = new System.Drawing.Size(400, 39);
            this.date.TabIndex = 0;
            this.date.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // time
            // 
            this.time.BackColor = System.Drawing.Color.Black;
            this.time.Font = new System.Drawing.Font("Trebuchet MS", 20.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.time.ForeColor = System.Drawing.Color.Lime;
            this.time.Location = new System.Drawing.Point(8, 123);
            this.time.Name = "time";
            this.time.Size = new System.Drawing.Size(400, 39);
            this.time.TabIndex = 1;
            this.time.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // timer
            // 
            this.timer.Interval = 1000;
            this.timer.Tick += new System.EventHandler(this.OnTick);
            // 
            // dateCount
            // 
            this.dateCount.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(238)));
            this.dateCount.Location = new System.Drawing.Point(184, 80);
            this.dateCount.Name = "dateCount";
            this.dateCount.Size = new System.Drawing.Size(56, 23);
            this.dateCount.TabIndex = 2;
            this.dateCount.Text = "0";
            this.dateCount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // timeCount
            // 
            this.timeCount.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(238)));
            this.timeCount.Location = new System.Drawing.Point(184, 176);
            this.timeCount.Name = "timeCount";
            this.timeCount.Size = new System.Drawing.Size(56, 23);
            this.timeCount.TabIndex = 3;
            this.timeCount.Text = "0";
            this.timeCount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // TimeForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(416, 222);
            this.Controls.Add(this.timeCount);
            this.Controls.Add(this.dateCount);
            this.Controls.Add(this.time);
            this.Controls.Add(this.date);
            this.Name = "TimeForm";
            this.Text = "Zdalny czas";
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new TimeForm());
		}

		private static bool Initialize(string configfile)
		{
			if(!File.Exists(configfile))
			{
				configfile = @"..\..\" + configfile;
				if(!File.Exists(configfile))
					return false;
			}
			RemotingConfiguration.Configure(configfile, false);
			return true;
		}

		private System.Windows.Forms.TextBox date;
		private System.Windows.Forms.TextBox time;
		private System.Windows.Forms.Timer timer;
		private System.Windows.Forms.TextBox dateCount;
		private System.Windows.Forms.TextBox timeCount;
		private TimeObject timeService = null;
		private ReturnTimeDelegate returnTimeDelegate = null;
		private ReturnDateDelegate returnDateDelegate = null;
		private AsyncCallback asyncDateCallback = null;
		private AsyncCallback asyncTimeCallback = null;
        private bool loop1 = true;
        private bool loop2 = true;

		public void DateCallBack(IAsyncResult ar)
		{
			ReturnDateDelegate d = (ReturnDateDelegate)((AsyncResult)ar).AsyncDelegate;
			string rdate = d.EndInvoke(ar);
			date.Text = rdate;
			dateCount.Text = Convert.ToString(timeService.DateCount);
            loop1 = true;
		}

		public void TimeCallBack(IAsyncResult ar)
		{
			ReturnTimeDelegate d = (ReturnTimeDelegate)((AsyncResult)ar).AsyncDelegate;
			string rtime = d.EndInvoke(ar);
			time.Text = rtime;
			timeCount.Text = Convert.ToString(timeService.TimeCount);
            loop2 = true;
		}

        private void Run()
        {
             
			    if(timeService != null && loop1 && loop2)
			    {
				    try
				    {

					
                            returnTimeDelegate.BeginInvoke(asyncTimeCallback, null);
					  
                            returnDateDelegate.BeginInvoke(asyncDateCallback, null);

                       
                            loop1 = loop2 = false;


					    // Moliwe jest take przeksztacenie postaci asynchronicznej
					    // do synchronicznej poprzez wyczenie wywoania zwrotnego.
					    // W tym celu wystarczy oznaczy znakami komentarza powysze wiersze.

					    // IAsyncResult ar;
					    // ar = returnTimeDelegate.BeginInvoke(null, null);
					    // time.Text = returnTimeDelegate.EndInvoke(ar);
					    // ar = returnDateDelegate.BeginInvoke(null, null);
					    // date.Text = returnDateDelegate.EndInvoke(ar);
					    // timeCount.Text = Convert.ToString(timeService.TimeCount);
					    // dateCount.Text = Convert.ToString(timeService.DateCount);
				    }
				    catch(Exception exception)
				    {
					    Debug.WriteLine(exception);
					    timeService = null;
					    timer.Enabled = false;
				    }
                }
                
        }


		private void OnTick(object sender, System.EventArgs e)         
		{   
            int i;
            string str = dateCount.Text;
            i = int.Parse(str);
            ++i;
            dateCount.Text = i.ToString();
           
            str = timeCount.Text;
            i = int.Parse(str);
            ++i;
            timeCount.Text = i.ToString();
            Run();
        }
			
		
	}
}
