﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Dopasowacz
{
    public partial class Form1 : Form
    {
        double Wpłaty = 826595.06,
                 Maks = 2033482.06;

        string Data = "05.12.2024";   

        dana[] Historia =
        {
            new dana( 2023, 98.00),
            new dana( 2022, 49.59),
            new dana( 2021, 52.88),
            new dana( 2020, 88.51),
            new dana( 2019, 106.90),
            new dana( 2018, 111.43),
            new dana( 2017, 80.83),
            new dana( 2016, 98.09),
            new dana( 2015, 96.31),
            new dana( 2014, 93.82)
        };        
            
        double Wynik = 0, Procent = 0, Bezosy = 0;
        int Pom;

        struct dana
        {
            public int Rok;
            public double Proc;
            public dana(int x, double y)
            {
                Rok = x;
                Proc = y;
            }
        };

        private void Form1_Click(object sender, EventArgs e)
        {
            Przelicz();
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void hScrollBar2_ValueChanged(object sender, EventArgs e)
        {
            Przelicz();
        }

        private void hScrollBar1_ValueChanged(object sender, EventArgs e)
        {
            Przelicz();
        }

       

        private void Form1_Load(object sender, EventArgs e)
        {

      
            listView1.GridLines = true;
            listView1.View = View.Details;
    
            ListViewItem it;
            int ile = Historia.Length;

            ListViewItem[] lvi = new ListViewItem[ile];

            for (int i = 0; i < ile; ++i)
            {
                it = new ListViewItem(Historia[i].Rok.ToString());
                it.SubItems.Add(Historia[i].Proc.ToString("F2"));
                lvi[i] = it;
            }

          
            listView1.Columns.Add("Rok    ", 50, HorizontalAlignment.Center);
            listView1.Columns.Add("Procent", 90, HorizontalAlignment.Center);

            listView1.Items.AddRange(lvi);
 
            textBox1.Text = Wpłaty.ToString("N2");
            textBox2.Text = Maks.ToString("N2");
            textBox3.Text = Procent.ToString();
            textBox4.Text = Bezosy.ToString();
            textBox5.Text = Wynik.ToString();
            textBox6.Text = Data;

            Przelicz();

        }

        void Przelicz()
        {
                    Procent = hScrollBar1.Value;
                    textBox3.Text = Procent.ToString();
                    Pom = hScrollBar2.Value;
      
                    Bezosy = Maks * Pom / 100;
                    textBox4.Text = Bezosy.ToString("N2");

            Wynik = Maks - (Wpłaty * (100 - Procent) / 100) - Bezosy * 1.1964;
                    textBox5.Text = Wynik.ToString("N2");
                    if (Wynik < 0)
                        textBox5.BackColor = Color.Coral;
                    else
                        textBox5.BackColor = Color.Beige;
                
            }

        
    }
}

/*
Obliczenie wartości wejściowych.

    Wpłaty: Wyzerować 2KPO-KOU i 2KPO-KOW w dydaktyce stacjonarnej i niestacjonarnej, 
            a następnie zsumować 2KPO-KOU i 2KPO-KOW z kolumny Razem.

    Maks:   W kolumnach dydaktyki stacjonarnej i niestacjonarnej 
            oraz w kolumnie kosztów ogónoinstytutowych w pola 2WYN-BPL, 2WYN-HON, 2RZE-WYP 
            wpisać kwoty dotychczas wydane (z plików kosztów). W kolumnach tych obliczyć
            nowe wartości pól 2SWS-WYN_BFP i 2SWS-FP_BFP.
            Nastepnie obliczyć wynik finansowy Instytutu.
 
*/
