#include <stdio.h>
#include <string.h>


const unsigned char  SET  = 0;		// R = Arg
const unsigned char  MOVR = 1;		// R = Pamiec(Arg)
const unsigned char  MOVM = 2;		// Pamiec(Arg) = R
const unsigned char  ADD  = 3;		// R = R + Pamiec(Arg)
const unsigned char  SUB  = 4;		// R = R - Pamiec(Arg)
const unsigned char  INC  = 5;		// R = R + 1
const unsigned char  DEC  = 6;		// R = R - 1
const unsigned char  JMP  = 7;		// LR = Arg
const unsigned char  JLE  = 8;		// if ( R < 0 ) LR = Arg
const unsigned char  IN   = 9;		// R = input
const unsigned char  OUT  = 10;		// output = R
const unsigned char  HLT  = 11;		// stop

struct RejestrRozkazu
{
	unsigned char KodOp;
	unsigned char R;		// ==0 : RA, !=0 : RB
	int Arg;
};

struct Procesor
{
	RejestrRozkazu RR;
	int RA;
	int RB;
	unsigned int LR;
	bool Stop;
} PR;

	
unsigned char Pamiec [1024];

void CzytajRozkaz();
void WykonajRozkaz();
void Pokaz();
void CzytajProgram();


void main ()
{

	char Pol = 'L';

	while ((Pol & 0x5F) != 'Q')
	{
		switch(Pol & 0x5F)
		{
		case 'L' :	CzytajProgram();
					break;

		case 'R' :	
				
			printf("\nPodaj adres startowy : ");
			scanf("%u",&PR.LR);
			if (PR.LR > 1000)
				printf("\nnBledny adres startowy.\n");
			else
			{
				PR.Stop = false;
				PR.RA = PR.RB = 0;

				Pokaz();

				while (!PR.Stop)
				{
					CzytajRozkaz();
					PR.LR += sizeof(RejestrRozkazu);
					WykonajRozkaz();
					Pokaz();
				}
			}
			break;

		default : printf("\nZle polecenie [L, R, Q]\n");
		}

		printf("\nWybierz polecenie [L, R, Q] : ");
		fflush(stdin);
		scanf("%c",&Pol);
	}

	printf("\nKoniec pracy procesora\n");
}

inline void CzytajRozkaz()
{

	PR.RR = *((RejestrRozkazu*)(Pamiec + PR.LR));
}

void WykonajRozkaz()
{
	int* Rejestr = PR.RR.R ? &PR.RB : &PR.RA;

	switch (PR.RR.KodOp)
	{
		case SET	:	*Rejestr = PR.RR.Arg;
						break;

		case MOVR	:	*Rejestr = *((int*)(Pamiec + PR.RR.Arg));
						break;

		case MOVM	:	*((int*)(Pamiec + PR.RR.Arg)) = *Rejestr;
						break;

		case ADD	:	*Rejestr += *((int*)(Pamiec + PR.RR.Arg));
						break;

		case SUB	:	*Rejestr -= *((int*)(Pamiec + PR.RR.Arg));
						break;

		case INC	:	*Rejestr += 1;
						break;

		case DEC	:	*Rejestr -= 1;
						break;

		case JMP	:	PR.LR = PR.RR.Arg;
						break;

		case JLE	:	if (*Rejestr < 0)
							PR.LR = PR.RR.Arg;
						break;

		case IN		:	printf("\n< ");
						scanf("%d", Rejestr);
						break;

		case OUT	:	printf("\n> %d", *Rejestr);
						break;

		case HLT	:	PR.Stop = true;
						break;

	}

}

void Pokaz()
{
//	printf("\nLR = %5d   RA = %5d   RB =%5d", PR.LR, PR.RA, PR.RB);
}

void CzytajProgram()
{
	char* Rozkazy[] = 
		{ "SET", "MOVR", "MOVM", "ADD", "SUB", "INC", "DEC",
		  "JMP", "JLE",   "IN",   "OUT", "HLT"}; 


	unsigned char NazwaPliku [32];
	unsigned char NazwaRozkazu [10];

	int Koniec = 0;
	bool Again;

	printf("\nPodaj nazwe pliku : ");
	scanf("%31s", NazwaPliku);

	FILE* plik;
	plik = fopen((char*)NazwaPliku,"rt");

	if (plik == NULL)
	{
		printf("\nNie mozna otworzyc pliku.\n");
		return;
	}

	printf("\nPodaj adres ladowania : ");
	scanf("%u",&PR.LR);

	if (PR.LR > 1000)
	{
		printf("\nBledny adres ladowania");
		fclose(plik);
		return;
	}


	while ( !Koniec )
	{
		
		fscanf(plik,"%9s", NazwaRozkazu);
		
		if ( (Koniec = feof(plik)))
			fclose(plik);
		else
		{
			_strupr((char*)NazwaRozkazu);

			Again = true;

			for (int Ktory = 0; Ktory < 12 && Again; Ktory++)
				if(strcmp((char*)NazwaRozkazu, Rozkazy[Ktory]) == 0)
				{
					PR.RR.KodOp = (unsigned char)Ktory;
					Again = false;
				}

			if (Again)
			{
				printf("\nBledny kod rozkazu : %s", NazwaRozkazu);
				fclose(plik);
				return;
			}
					
			fscanf(plik, "%d", &Ktory);
			PR.RR.R = (unsigned char)Ktory;
			fscanf(plik, "%d", &PR.RR.Arg);

			*((RejestrRozkazu*)(Pamiec + PR.LR)) = PR.RR;
			PR.LR += sizeof(RejestrRozkazu); 

		}
	}

}




