#include <stdio.h>


const int Size = 64;

char Stack [Size];
int Top = 0;

void Push(char c)
{
	Stack[++Top] = c;
}

char Pop()
{
	return Stack[Top--];
}

char Read()
{
	return Stack[Top];
}

bool Empty()
{
	return Top == 0;
}

int Prior (char c)
{
	switch(c)
	{
	case '('	:	return 0;

	case '+'	:
	case '-'	:	
	case ')'	:	return 1;

	case '*'	:
	case '/'	:	return 2;
	}

	return 0;

}

void main()
{
	char *Expr = new char[Size];
	char *ONP = new char[Size], *Tmp;

	char aux;

	Tmp = ONP;

	printf("\nWprowadz wyrazenie (liczby jednocyfrowe) : ");
	scanf("%63[ -~]", Expr);


// translation

	while (*Expr)
		switch (*Expr)
		{
			case ' '	:	Expr++;
							break;

			case '('	:	Push(*Expr++);
							break;

			case ')'	:	while (!Empty() && Read() != '(' )
								*Tmp++ = Pop();
						
							Expr++;
							Pop();
						
							break;

			case '+'	:
			case '-'	:
			case '*'	:
			case '/'	:	if (Empty())
								Push(*Expr++);
							else
							{
								while (!Empty() && Prior(Read()) >= Prior(*Expr) )
									*Tmp++ = Pop();
								Push(*Expr++);
							}
							break;

			default		:	*Tmp++ = *Expr++;
		}

	while(!Empty())
		if(Read() != '(')
			*Tmp++ = Pop();
		else
			Pop();

	*Tmp = 0;

	printf("\nONP : %s\n", ONP);


// execution

	Top = 0;

	Tmp = ONP;


	while (*Tmp)
	{
		switch (*Tmp)
		{
			case '+' :	Push(Pop() + Pop());
						break;

			case '-' :	aux = Pop();
						Push(Pop() - aux);
						break;

			case '*' :	Push(Pop() * Pop());
						break;

			case '/' :	aux = Pop();
						
						if (aux == 0)
						{
							printf("\nPamietaj morelo nie dziel przez zero!\n\n");
							return;
						}
						
						Push(Pop() / aux);
						break;

			default	 :	Push(*Tmp - 0x30);
		}

		Tmp++;
	}


	printf("\nWartosc wyrazenia = %d\n\n", (int)Pop());

	printf("\nSprawdzenie = %d\n\n",((3 + 7)*5)/(2-4)/3-(7-3)/4 );

}
