#include <stdio.h>
#include <conio.h>


/*
	BitMapFileHeader
	BitmapInfoHeader
	ColorDefinitionTable
	Pixels
*/

struct BitMapFileHeader
{
	char aucType[2];				// typ pliku
	unsigned long ulSize;			// rozmiar w bajtach
	unsigned short unReserved1;
	unsigned short unReserved2;
	unsigned long ulPixelsOffset;	// wzgldny adres 
									// obszaru pikseli
};

struct BitMapInfoHeader
{
	unsigned long ulSize;			// rozmiar info w bajtach
	long lWidth;					// szeroko w pikselach
	long lHeight;					// wysoko w pikselach
	unsigned short usPlanes;		// liczba planw (=1)
	unsigned short usBitCount;		// bitw / piksel
	unsigned long ulCompression;	// BI_RGB bez kompresji
	unsigned long ulSizeImage;		// =0 dla BI_RGB
	long lXPixelsPerMeter;			// pikseli / metr, o X
	long lYPixelsPermeter;			// pikseli / metr, o Y
	unsigned long ulCLrUsed;		// rozmiar tabeli kolorw
	unsigned long ulClrImportrant;	// liczba istotnych kolorw
};

struct ColorDefinition
{
	unsigned char Blue;
	unsigned char Green;
	unsigned char Red;
	unsigned char Reserved;
};

bool ProcessHeaders	(BitMapFileHeader* file_info_in, 
					BitMapFileHeader* file_info_out,
				    BitMapInfoHeader* map_info_in,
					BitMapInfoHeader* map_info_out)
{
	*file_info_out = *file_info_in;
	*map_info_out = *map_info_in;

	map_info_out->usBitCount = 1;
	file_info_out->ulPixelsOffset = file_info_in->ulPixelsOffset + 
									2 * sizeof (ColorDefinition);
	map_info_out->ulSizeImage = map_info_out->lHeight *
							    ((0x20 - (map_info_out->lWidth & 0x1F) + 
								 map_info_out->lWidth) >> 3);
	file_info_out->ulSize = sizeof (BitMapFileHeader) +
							sizeof (BitMapInfoHeader) +
							2 * sizeof (ColorDefinition) +
							map_info_out->ulSizeImage;
	return true;
}	

void SetBit(unsigned char *Row, long lOffset, char cValue)
{
	static unsigned char ucNew = 0;

	
	if (!(lOffset & 7))
		ucNew = 0;

	if (cValue)
		ucNew |= 0x80 >> (lOffset & 7);

	*(Row + (lOffset >> 3)) = ucNew;

}

void RemoveRed_BlackWhite(unsigned char *Row24, long lPixels)
{
	unsigned char Blue, Green, Red;
	unsigned char *Row1 = Row24;

	const unsigned char RedLevel = 240;
	const unsigned char GreenLevel = 10;
	const unsigned char BlueLevel = 10;
	const unsigned char WhiteLevel = 250;

	for (long lPix = 0; lPix < lPixels; lPix++)
	{
		Blue  = *Row24++;
		Green = *Row24++;
		Red   = *Row24++;

		if (Red > RedLevel && Green < GreenLevel && Blue < BlueLevel)
			SetBit(Row1,lPix,1);		// white
		else
			if (Red > WhiteLevel && Green > WhiteLevel && Blue > WhiteLevel)
				SetBit(Row1,lPix,1);	// white
			else
				SetBit(Row1,lPix,0);	// black

	}

	*(Row1 + (lPix >> 3) + 1) = 0;
	*(Row1 + (lPix >> 3) + 2) = 0;
	*(Row1 + (lPix >> 3) + 3) = 0;
}

		


void main ( void )
{
	FILE *map_file_in, *map_file_out;

	BitMapFileHeader file_info_in, file_info_out;
	BitMapInfoHeader map_info_in, map_info_out;

	ColorDefinition for_zero = {0, 0 ,0, 0};
	ColorDefinition for_one  = {255, 255, 255, 0};

	long nRowBytes24;
	long nRowBytes1;
	unsigned char *Row;
	
	map_file_in = fopen("Test24.bmp","rb");

	if (map_file_in == NULL)
	{
		printf ("\nBrak pliku wejciowego.\n");
		return;
	}

	map_file_out = fopen("Test1.bmp","wb");
	
	if (map_file_out == NULL)
	{
		printf ("\nBd pliku wyjciowego.\n");
		return;
	}
	
	fread(&file_info_in, sizeof(BitMapFileHeader), 1, map_file_in);
	fread(&map_info_in, sizeof(BitMapInfoHeader), 1, map_file_in);

	if (map_info_in.usBitCount != 24)
	{
		printf ("\nNieodpowiedni format pliku wejciowego.\n");
		return;
	}

	ProcessHeaders(&file_info_in, &file_info_out,
				   &map_info_in,  &map_info_out);

	fwrite(&file_info_out, sizeof(BitMapFileHeader), 1, map_file_out);
	fwrite(&map_info_out, sizeof(BitMapInfoHeader), 1, map_file_out);
	fwrite(&for_zero, sizeof(ColorDefinition), 1, map_file_out);
	fwrite(&for_one, sizeof(ColorDefinition), 1, map_file_out);
	
	nRowBytes24 = 3l * map_info_in.lWidth + (map_info_in.lWidth & 3l);
	nRowBytes1  = (0x20 - (map_info_out.lWidth & 0x1F) + 
				  map_info_out.lWidth) >> 3;

	Row = new unsigned char [ nRowBytes24 ];

	for ( long lRow = 0 ; lRow < map_info_in.lHeight; lRow++)
	{
		fread(Row, 1, nRowBytes24, map_file_in);

		RemoveRed_BlackWhite(Row, map_info_in.lWidth);
		
		fwrite(Row, 1, nRowBytes1, map_file_out);
	}

	delete Row;

	fclose(map_file_in);
	fclose(map_file_out);

	printf("\nGotowe.\n");

}
