#include <stdio.h>

struct Header
{
	Header *Next;
	Header *Prev;
	int Size;		// with header
	bool Free;
};


Header *BlockList;

void *Answer;						// allocated block

// demand

//int Demand = 216;			
//int Demand = 2000;
//int Demand = 540;
int Demand = 214;					// the rest too small



void main()
{

	Header *Temp, *New;
	int Head = sizeof(Header);		// 16

	const int MinBlock = Head + 4;
	bool Fits;

// --------------------------------

	Header	f1 = {NULL, NULL, 150, true };
	Header	u1 = {NULL, &f1,  320, false};
	Header	f2 = {NULL, &u1,  232, true };
	Header	u2 = {NULL, &f2,  500, false};		
	Header	f3 = {NULL, &u2, 1000, true };		
	f1.Next = &u1;
	u1.Next = &f2;
	f2.Next = &u2;
	u2.Next = &f3;
	BlockList = &f1;

	
	printf("\nDemand = %d\n", Demand);

	printf("\n\nBefore\n");

	Temp = BlockList;

	printf("\nFree list  : ");
	
	while (Temp != NULL)
	{
		if (Temp->Free)
			printf("%8d", Temp->Size);
		Temp = Temp->Next;
	}

	Temp = BlockList;
	
	printf("\nInUse list : ");
	
	while (Temp != NULL)
	{
		if ( !Temp->Free )
			printf("%8d", Temp->Size);
		Temp = Temp->Next;
	}

// -------------------------------------
	
	Temp = BlockList;
	Fits = false;

	while (Temp != NULL &&  !Fits)
	{	
		if (Temp->Free && Temp->Size >=  Demand + Head)
			Fits = true;
		else
			Temp = Temp->Next;
	}

	if (!Fits)
	{
		printf("\n\nNo free memory.\n\n");
		return;
	}
	

	if (Temp->Size == Demand + Head ||
		Temp->Size < Demand + Head + MinBlock)
			Temp->Free = false;
	else
	{		
		New = new Header;

		New->Free = false;
		New->Next = Temp->Next;		
		New->Prev = Temp;
		Temp->Next = New;
			
		New->Size = Demand + Head;
		Temp->Size = Temp->Size - (Head + Demand);
	}


	Answer = (void*)((unsigned char*)Temp + Head);		

// ------------------------------
	printf("\n\nAfter\n");


	Temp = BlockList;
	
	printf("\nFree list  : ");
	
	while (Temp != NULL)
	{
		if (Temp->Free)
			printf("%8d", Temp->Size);
		Temp = Temp->Next;
	}

	Temp = BlockList;
	
	printf("\nInUse list : ");
	
	while (Temp != NULL)
	{
		if ( !Temp->Free )
			printf("%8d", Temp->Size);
		Temp = Temp->Next;
	}
 

	printf("\n\n");
}