// console.cpp
//
#include "stdafx.h"
#include "console.h"

using namespace std;

//
// Clears the screen
//
void clrscr(int color)
{
	COORD coordScreen = { 0, 0 }; 
	DWORD cCharsWritten; 
	CONSOLE_SCREEN_BUFFER_INFO csbi; 
	DWORD dwConSize; 
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE); 
  
	switch(color)
	{
	case 0 :	SetConsoleTextAttribute(hConsole, FOREGROUND_INTENSITY);	// black
				break;
	case 1 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_RED);	// red
				break;
	case 2 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_GREEN);	// green
				break;
	case 3 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_BLUE);	// blue
				break;
	case 4 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_BLUE);	// violet
				break;
	case 5 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN);	// yellow
				break;
	case 6 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_GREEN | BACKGROUND_BLUE);	// emerald
				break;
	case 7 :	SetConsoleTextAttribute(hConsole, BACKGROUND_INTENSITY | FOREGROUND_INTENSITY | BACKGROUND_RED| BACKGROUND_GREEN | BACKGROUND_BLUE);	// white
				break;
	default :	SetConsoleTextAttribute(hConsole, FOREGROUND_INTENSITY);	// black
				break;
	}


	GetConsoleScreenBufferInfo(hConsole, &csbi); 
	dwConSize = csbi.dwSize.X * csbi.dwSize.Y; 
	//FillConsoleOut_putcharacter(hConsole, TEXT(' '), dwConSize, coordScreen, &cCharsWritten); 
	GetConsoleScreenBufferInfo(hConsole, &csbi); 
	FillConsoleOutputAttribute(hConsole, csbi.wAttributes, dwConSize, coordScreen, &cCharsWritten); 
	SetConsoleCursorPosition(hConsole, coordScreen); 
}

void getmax(int &maxX, int &maxY)
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE); 
	GetConsoleScreenBufferInfo(hConsole, &csbi);
	maxX = csbi.srWindow.Right;
	maxY = csbi.srWindow.Bottom;
}


void settext(char* text)
{	
	int i, n = strlen(text);
	TCHAR* tt = new TCHAR[n + 1];

	for (i = 0; i < n; ++i)
		tt[i] = (TCHAR)text[i];
	tt[i] = 0;

	SetConsoleTitle((LPCWSTR)tt );
}



void setcursor(bool visible)
{
	CONSOLE_SCREEN_BUFFER_INFO csbi; 
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE); 
  
	GetConsoleScreenBufferInfo(hConsole, &csbi); 
	CONSOLE_CURSOR_INFO cinf;

	GetConsoleCursorInfo(hConsole, &cinf);
	cinf.bVisible = visible;
	SetConsoleCursorInfo(hConsole, &cinf);
}




//
// Moves the cursor to x, y in console window
// ie x=left\right y=top\bottom
//
void gotoxy(int x, int y)
{
	COORD point;
	point.X = x; point.Y = y;
	SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), point);
}

void gotox(int x)
{
	COORD point;
	CONSOLE_SCREEN_BUFFER_INFO csbi; 
	GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &csbi);
	point.Y = csbi.dwCursorPosition.Y;
	point.X = x;
	SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), point);
}

void gotoy(int y)
{
	COORD point;
	CONSOLE_SCREEN_BUFFER_INFO csbi; 
	GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &csbi);
	point.X = csbi.dwCursorPosition.X;
	point.Y = y;
	SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), point);
}
//
// Set text and background colors
//
void setrgb(int color)
{
	switch (color)
	{
	case 0:	// White on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
	case 1:	// Red on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_RED);
		break;
	case 2:	// Green on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_GREEN);
		break;
	case 3:	// Blue on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_BLUE);
		break;
	case 4:	// Yellow on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_RED | FOREGROUND_GREEN);
		break;
	case 5:	// Magenta on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_RED | FOREGROUND_BLUE);
		break;
	case 6:	// Cyan on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
	case 7:	// Black on Gray
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			BACKGROUND_INTENSITY);
		break;
	case 8:	// Black on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE);
		break;
	case 9:	// Red on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_RED);
		break;
	case 10: // Green on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_GREEN);
		break;
	case 11: // Yellow on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_RED | FOREGROUND_GREEN);
		break;
	case 12: // Blue on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_BLUE);
		break;
	case 13: // Magenta on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_RED | FOREGROUND_BLUE);
		break;
	case 14: // Cyan on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
	case 15: // White on White
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
			FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
	case 16: // Red on Yellow
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),BACKGROUND_INTENSITY |
			FOREGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN |
			FOREGROUND_RED );
		break;

	default : // White on Black
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),FOREGROUND_INTENSITY |
			FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
	}
}

