#!/bin/bash

if [ $# -ne 5 ]
then
    echo Usage:
    echo $0 algorithm_name dir_with_files minWin maxWin nGPUs
    exit
fi

dat_dir=$2
min_win=$3
max_win=$4
max_gpu=$5
alg=$1

echo "win_size : time [ms]"

ls $dat_dir | grep ".fax" |
while read file
do
    echo ""
    echo $file:

    for i in `seq $min_win 16 $max_win`
    do
        echo -n "$i : "
        ./seq.out -i $dat_dir/$file -ws $i -a $alg -ng $max_gpu | grep "total" | egrep -o [0-9]+
        #killall -9 seq.out
    done

done

